"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirSpecimen", {
    enumerable: true,
    get: function() {
        return FhirSpecimen;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("../Resource");
const _getQueryOptions = require("./getQueryOptions");
const _getValues = require("./getValues");
const _getQueryToFindUpstreamIds = require("./getQueryToFindUpstreamIds");
const _searchParameters = require("./searchParameters");
const _getQueryToFilterUpstream = require("./getQueryToFilterUpstream");
let FhirSpecimen = class FhirSpecimen extends _Resource.FhirResource {
    static init(options, models) {
        super.init({
            collection: _sequelize.DataTypes.JSONB,
            request: _sequelize.DataTypes.JSONB,
            type: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.LabRequest
        ];
        this.upstreams = [
            models.LabRequest
        ];
    }
    static CAN_DO = new Set([
        _constants.FHIR_INTERACTIONS.INSTANCE.READ,
        _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
        _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
    ]);
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _getQueryOptions.getQueryOptions)(this.sequelize.models));
        const values = await (0, _getValues.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id, deletedRow = null) {
        const { LabRequest } = this.sequelize.models;
        if (upstreamTable === LabRequest.tableName) {
            return (0, _getQueryToFindUpstreamIds.fromLabRequest)(this.sequelize.models, table, id, deletedRow);
        }
        return null;
    }
    static async queryToFilterUpstream(upstreamTable) {
        const { LabRequest } = this.sequelize.models;
        if (upstreamTable === LabRequest.tableName) {
            return (0, _getQueryToFilterUpstream.filterFromLabRequests)(this.sequelize.models, upstreamTable);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._searchParameters.searchParameters
        };
    }
};

//# sourceMappingURL=FhirSpecimen.js.map