import React from 'react';
import { getDisplayDate } from '../patientCertificates/getDisplayDate';
import { Divider } from './Divider';
import { Col, Row } from '../patientCertificates/Layout';
import { P } from '../patientCertificates/Typography';
import { getDOB, getName, getSex } from '../patientAccessors';
const PATIENT_FIELDS = [
    {
        key: 'name',
        label: 'Patient Name',
        accessor: getName,
        percentageWidth: 40
    },
    {
        key: 'displayId',
        label: 'Patient ID',
        percentageWidth: 40
    },
    {
        key: 'dateOfBirth',
        label: 'DOB',
        accessor: getDOB,
        percentageWidth: 20
    },
    {
        key: 'sex',
        label: 'Sex',
        accessor: getSex,
        percentageWidth: 40
    }
];
const ValueDisplay = ({ width, title, value })=>/*#__PURE__*/ React.createElement(Col, {
        style: {
            width
        }
    }, /*#__PURE__*/ React.createElement(P, {
        mb: 5,
        style: {
            fontSize: 10
        }
    }, /*#__PURE__*/ React.createElement(P, {
        style: {
            fontSize: 10
        },
        bold: true
    }, title, ":"), ' ', value));
export const HandoverPatient = ({ patient, location, arrivalDate, diagnosis, notes, getLocalisation, createdAt, isEdited })=>{
    const detailsToDisplay = PATIENT_FIELDS.filter(({ key })=>!getLocalisation(`fields.${key}.hidden`));
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(Row, {
        style: {
            width: '100%',
            marginBottom: 40
        }
    }, /*#__PURE__*/ React.createElement(Col, {
        style: {
            width: '100%'
        }
    }, /*#__PURE__*/ React.createElement(Row, null, detailsToDisplay.map(({ key, label: defaultLabel, accessor, percentageWidth = 33 })=>{
        const value = (accessor ? accessor(patient, getLocalisation) : patient[key]) || '';
        const label = defaultLabel || getLocalisation(`fields.${key}.shortLabel`);
        return /*#__PURE__*/ React.createElement(ValueDisplay, {
            key: key,
            width: `${percentageWidth}%`,
            title: label,
            value: value
        });
    }), /*#__PURE__*/ React.createElement(ValueDisplay, {
        width: "40%",
        title: "Location",
        value: location
    }), /*#__PURE__*/ React.createElement(ValueDisplay, {
        width: "20%",
        title: "Arrival date",
        value: getDisplayDate(arrivalDate, 'dd/MM/yy')
    })), diagnosis && /*#__PURE__*/ React.createElement(ValueDisplay, {
        width: "100%",
        title: "Diagnosis",
        value: diagnosis
    }), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(ValueDisplay, {
        width: "100%",
        title: "Notes",
        value: notes || 'N/A'
    }), !!notes && !!createdAt && /*#__PURE__*/ React.createElement(Col, {
        style: {
            width: '100%'
        }
    }, /*#__PURE__*/ React.createElement(P, {
        style: {
            fontSize: 8
        }
    }, `${getDisplayDate(createdAt, 'dd/MM/yyyy hh:mm a')}${isEdited ? ' (edited)' : ''}`))))), /*#__PURE__*/ React.createElement(Divider, null));
};

//# sourceMappingURL=HandoverPatient.js.map