import React from 'react';
import { DataSection } from './DataSection';
import { Col } from '../Layout';
import { getDOBWithAge, getSex, getVillageName } from '../../patientAccessors';
import { renderDataItems } from './renderDataItems';
const PATIENT_FIELDS = {
    leftCol: [
        {
            key: 'firstName',
            label: 'First name'
        },
        {
            key: 'lastName',
            label: 'Last name'
        },
        {
            key: 'dateOfBirth',
            label: 'DOB',
            accessor: getDOBWithAge
        }
    ],
    rightCol: [
        {
            key: 'displayId',
            label: 'Patient ID'
        },
        {
            key: 'sex',
            label: 'Sex',
            accessor: getSex
        },
        {
            key: 'villageName',
            label: 'Village',
            accessor: getVillageName
        }
    ]
};
export const PatientDetails = ({ patient, getLocalisation })=>{
    return /*#__PURE__*/ React.createElement(DataSection, {
        title: "Patient details"
    }, /*#__PURE__*/ React.createElement(Col, null, renderDataItems(PATIENT_FIELDS.leftCol, patient, getLocalisation)), /*#__PURE__*/ React.createElement(Col, null, renderDataItems(PATIENT_FIELDS.rightCol, patient, getLocalisation)));
};

//# sourceMappingURL=PatientDetails.js.map