(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsCs = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"a":[{"d":[{"a":[{},[0,4]],"e":[{},[0,4]],"i":[{},[0,4]],"o":[{},[0,4]],"é":[{},[0,4]]}],"k":[{"l":[{},[0,4]],"o":[{},[0,4]],"r":[{},[0,4]],"u":[{},[0,4]]}],"l":[{"e":[{"x":[{},[0,0,0,3]]}]}],"r":[{"a":[{},[0,4]],"e":[{},[0,4]],"i":[{},[0,4]],"o":[{},[0,4]],"y":[{},[0,4]],"á":[{},[0,4]]}],"s":[{"a":[{},[0,4]],"e":[{},[0,4]],"o":[{},[0,4]],"t":[{},[0,0,3,3]],"y":[{},[0,4]]}],"t":[{"a":[{},[0,4]],"e":[{},[0,4]],"l":[{},[0,0,3]],"o":[{},[0,4]],"r":[{},[0,4]],"y":[{},[0,4]]}],"v":[{"e":[{},[0,4]]}]},[0,2]],"b":[{},[0,2]],"c":[{"h":[{},[0,0,2]],"y":[{"k":[{},[0,0,0,3]]}]},[0,2]],"d":[{"e":[{"z":[{},[0,0,0,3]]}],"n":[{"a":[{},[0,4]],"e":[{"š":[{"k":[{},[0,0,0,0,4]]}]},[0,0,0,4]],"y":[{},[0,4]]}],"o":[{"s":[{},[0,0,0,4]]}],"v":[{"e":[{},[0,4]],"ě":[{},[0,4]],"í":[{},[0,4]]}]},[0,2]],"e":[{"c":[{"h":[{},[0,4]]}],"k":[{"o":[{},[0,4]]}],"s":[{"k":[{},[0,0,3]],"t":[{},[0,0,3]]}],"v":[{"e":[{},[0,4]]}]},[0,2]],"f":[{"r":[{"i":[{},[0,4]]}]}],"g":[{},[0,2]],"h":[{"l":[{"e":[{},[0,4]]}],"n":[{"e":[{},[0,4]]}]},[0,2]],"i":[{"n":[{"a":[{},[0,4]],"i":[{},[0,4]],"o":[{},[0,4]]}],"s":[{"l":[{},[0,0,3]]}]},[0,2]],"j":[{"a":[{"k":[{},[0,4]]}],"e":[{"d":[{"l":[{},[0,0,4]]}]}],"s":[{"e":[{},[0,4]]}],"z":[{"d":[{},[0,4]]}],"á":[{"d":[{},[0,0,0,4]]}]},[0,2]],"k":[{"l":[{"i":[{},[0,4]],"y":[{},[0,4]]}],"ř":[{"í":[{"d":[{},[0,0,0,3]]}]}]},[0,2]],"l":[{"e":[{"g":[{"r":[{},[0,0,4]]}]}],"i":[{"k":[{"v":[{},[0,0,3]]}]}]},[0,2]],"m":[{"i":[{"s":[{"t":[{},[0,0,3,0,4]]}]}],"o":[{"u":[{"d":[{},[0,0,0,0,3]]}]}]},[0,2]],"n":[{"a":[{"č":[{},[0,0,3,4]]}],"e":[{"c":[{},[0,0,3]],"č":[{},[0,0,0,4]],"š":[{},[0,0,3]]}],"i":[{"t":[{},[0,0,2]]}],"o":[{"s":[{"t":[{},[0,0,4,3]]}]}],"v":[{"p":[{},[0,4]]}],"á":[{"ř":[{"k":[{},[0,0,0,4]]}]},[0,0,1]]}],"o":[{"b":[{"é":[{},[0,4]]}],"d":[{"e":[{},[0,0,0,3]],"l":[{},[0,0,3]],"r":[{"á":[{},[0,0,3]]}]}],"k":[{"a":[{},[0,4]],"o":[{},[0,4]]}],"n":[{"a":[{},[0,4]],"e":[{},[0,4]],"i":[{},[0,4]],"o":[{},[0,4]],"u":[{},[0,4]],"y":[{},[0,4]],"ě":[{},[0,4]],"í":[{},[0,4]]}],"p":[{"e":[{},[0,4]],"o":[{},[0,4]]}],"s":[{"e":[{},[0,4]],"l":[{},[0,4]],"t":[{"o":[{},[0,0,4]],"r":[{},[0,0,3,3]],"ě":[{},[0,0,4]]}]}],"t":[{"r":[{"á":[{},[0,0,3]]}],"v":[{},[0,0,3]],"í":[{},[0,4]],"ř":[{},[0,4]]}],"v":[{"ě":[{"t":[{},[0,0,0,4]]}]}],"z":[{"a":[{},[0,4]],"d":[{"o":[{},[0,0,3]]}],"i":[{},[0,4]],"o":[{},[0,4]],"u":[{},[0,4]]}],"š":[{"k":[{},[0,4]],"l":[{},[0,4]]}],"ž":[{"i":[{},[0,4]]}]},[0,2]],"p":[{"a":[{"r":[{"e":[{},[0,0,4]]}],"t":[{"ř":[{},[0,0,3]]}]}],"o":[{"l":[{"k":[{"l":[{},[0,0,0,0,4]]}]}],"č":[{},[0,0,3,4]]}],"r":[{"o":[{},[0,4]],"ý":[{},[0,4]]}],"s":[{"e":[{},[0,4]]}],"u":[{"b":[{},[0,0,3]]}]},[0,2]],"r":[{"e":[{"j":[{},[0,0,0,4]],"s":[{},[0,0,3]]}],"o":[{"k":[{},[0,0,4]],"z":[{"e":[{},[0,0,0,0,3]],"r":[{},[0,0,0,3]]}]}],"u":[{"d":[{"l":[{},[0,0,4]]}]}]},[0,2]],"s":[{"c":[{"h":[{},[0,4]],"i":[{},[0,4]]}],"e":[{"m":[{},[0,0,0,4]],"p":[{"n":[{},[0,0,3]]}]}],"k":[{"e":[{},[0,4]],"l":[{},[0,0,4]],"á":[{},[0,4]]}],"l":[{"e":[{},[0,4]]}],"n":[{"a":[{},[0,4]],"y":[{},[0,4]]}],"p":[{"e":[{},[0,4]],"o":[{},[0,4]]}],"t":[{"á":[{},[0,4]]},[0,0,2]],"ž":[{"i":[{},[0,4]]}]},[0,2]],"t":[{},[0,2]],"u":[{"b":[{"a":[{},[0,4]],"e":[{},[0,4]],"i":[{},[0,4]],"o":[{},[0,4]]}],"d":[{"e":[{},[0,4]],"i":[{},[0,4]],"o":[{},[0,4]],"u":[{},[0,4]],"í":[{},[0,4]]}],"h":[{"n":[{},[0,0,4]]}],"j":[{"m":[{},[0,0,4]]}],"k":[{"o":[{},[0,4]],"u":[{},[0,4]]}],"l":[{"h":[{},[0,0,4]]}],"m":[{"a":[{},[0,4]],"e":[{},[0,4]],"i":[{},[0,4]],"u":[{},[0,4]]}],"n":[{"e":[{},[0,4]],"i":[{},[0,4]]}],"p":[{"a":[{},[0,4]],"e":[{},[0,4]],"i":[{},[0,4]],"n":[{},[0,0,4]],"o":[{},[0,4]],"u":[{},[0,4]],"á":[{},[0,4]],"ě":[{},[0,4]],"í":[{},[0,4]]}],"r":[{"a":[{},[0,4]],"o":[{},[0,4]],"á":[{},[0,4]]}],"s":[{"o":[{},[0,4]],"t":[{},[0,4]],"y":[{},[0,4]],"í":[{},[0,4]]},[0,0,2]],"t":[{},[0,0,2]],"v":[{"i":[{},[0,4]]}],"z":[{"e":[{},[0,4]]}],"č":[{"e":[{},[0,4]],"i":[{},[0,4]],"í":[{},[0,4]]}],"š":[{"e":[{},[0,4]],"i":[{},[0,4]],"k":[{},[0,4]],"t":[{},[0,0,4]],"í":[{},[0,4]]}],"ž":[{"i":[{},[0,4]],"n":[{},[0,0,4]],"o":[{},[0,4]],"í":[{},[0,4]]}]},[0,2]],"v":[{"a":[{"d":[{"l":[{},[0,0,4]]}]}],"p":[{"o":[{},[0,4]]}],"y":[{},[0,0,3]],"z":[{"á":[{},[0,4]]}],"ý":[{},[0,0,1]],"ž":[{"i":[{},[0,4]]}]},[0,2]],"y":[{"o":[{"r":[{},[0,4]]}],"v":[{"e":[{},[0,4]]}]}],"z":[{"a":[{"o":[{"s":[{},[0,0,0,3]]}],"r":[{},[0,0,0,2]],"č":[{},[0,0,0,2]]},[0,0,3]],"d":[{"i":[{},[0,4]],"r":[{},[0,4]]},[0,0,2]],"k":[{"y":[{},[0,4]]}],"m":[{"n":[{},[0,4]]}],"n":[{"o":[{},[0,4]],"u":[{},[0,4]],"ě":[{},[0,4]],"í":[{},[0,4]]}],"p":[{"e":[{},[0,4]],"o":[{},[0,4]]}],"t":[{"ř":[{},[0,4]]}],"v":[{"e":[{},[0,4]],"i":[{},[0,4]]}]},[0,2]],"č":[{"t":[{"e":[{},[0,4]]}]},[0,2]],"é":[{},[0,2]],"í":[{},[0,2]],"ó":[{},[0,2]],"š":[{"e":[{"t":[{},[0,0,3]]}],"k":[{"a":[{},[0,4]],"e":[{},[0,4]],"y":[{},[0,4]]}],"ť":[{"o":[{},[0,4]],"á":[{},[0,4]]}]},[0,2]],"ú":[{"d":[{"ů":[{},[0,4]]}]},[0,2]],"ž":[{},[0,2]]}],"a":[{".":[{},[2]],"a":[{"t":[{},[0,0,3,2]]}],"b":[{"l":[{"o":[{"n":[{},[0,0,3]]}],"ý":[{},[0,0,4]]}],"r":[{"i":[{},[0,0,3]]}],"s":[{"b":[{},[0,0,4]],"t":[{},[0,0,2]]}]}],"c":[{"c":[{"i":[{},[0,0,4]]}]}],"d":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"l":[{"a":[{},[0,0,2]],"i":[{},[0,4]],"á":[{},[0,4]],"é":[{},[0,4]]}],"m":[{"e":[{},[0,0,4]],"u":[{},[0,0,4]]}],"o":[{"s":[{},[0,0,0,4]]},[0,3]],"r":[{"a":[{},[0,3,3]],"i":[{},[0,0,3]],"ž":[{},[0,3]]}],"u":[{"ž":[{},[0,4]]},[0,3]],"v":[{"a":[{},[3,3]],"o":[{},[0,0,3]]}],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]],"ú":[{"z":[{},[0,0,4]],"ř":[{},[0,0,4]]}],"ů":[{},[0,3]],"ý":[{},[0,3]]},[0,2]],"e":[{"v":[{"i":[{},[0,0,4]]}]}],"f":[{"i":[{"a":[{},[0,0,0,2]]}]}],"g":[{"a":[{},[0,3]],"f":[{"a":[{},[0,0,4]]}],"o":[{},[0,3]],"r":[{"o":[{},[0,0,3]]}],"u":[{},[0,3]],"á":[{},[0,3]]},[0,2]],"h":[{"l":[{"i":[{},[0,0,4]]}],"v":[{},[0,0,3]]}],"i":[{"n":[{},[0,3]],"r":[{"e":[{},[0,0,4]]}],"v":[{},[0,3]]},[0,2]],"j":[{"d":[{},[0,2]],"m":[{"e":[{},[0,0,4]]},[0,2]],"o":[{},[0,0,2]]}],"k":[{"e":[{},[0,3]],"i":[{},[0,3]],"l":[{},[0,3]],"n":[{"i":[{},[0,0,4]]}],"o":[{},[0,3]],"r":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"ó":[{},[0,3]],"ů":[{},[0,3]],"ý":[{},[0,3]]},[0,2]],"l":[{"f":[{"b":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,4]]}],"t":[{"z":[{},[0,0,4]]}],"ž":[{"í":[{},[0,0,3]]}]}],"m":[{"b":[{"d":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,4]]}],"n":[{"u":[{},[0,0,4]]}],"o":[{"s":[{},[0,0,0,3]]}],"ž":[{"i":[{},[0,0,4]]}]}],"n":[{"a":[{"e":[{},[0,4]],"m":[{"e":[{},[0,4]]}]}],"d":[{"t":[{},[0,0,4]]}],"e":[{"s":[{"k":[{},[0,0,0,4]]}],"u":[{},[0,0,0,0,4]]}],"s":[{"c":[{},[0,0,4]],"g":[{},[0,0,4]],"l":[{},[0,0,4]],"m":[{},[0,0,4]],"p":[{},[0,0,2]],"v":[{},[0,0,4]]}],"t":[{"č":[{},[0,0,4]]}],"ž":[{"h":[{},[0,0,4]]}]}],"o":[{"e":[{"d":[{},[0,0,4]]}],"h":[{"m":[{},[0,0,4]]}],"s":[{"t":[{"ř":[{},[0,0,4]]}]}],"t":[{"č":[{},[0,0,4]]}]}],"p":[{"r":[{".":[{},[0,0,4]]}],"s":[{"o":[{},[0,4]]}],"t":[{},[0,0,3]],"ř":[{".":[{},[0,4]]}]}],"r":[{"a":[{},[0,3]],"d":[{"w":[{},[0,0,4]]}],"e":[{"r":[{},[0,4]]},[0,3]],"g":[{"l":[{},[0,0,4]]}],"i":[{},[0,3]],"k":[{"h":[{},[0,0,4]]}],"o":[{"x":[{},[0,4]]},[0,3]],"s":[{"t":[{},[0,0,3]]}],"u":[{},[0,3]],"v":[{"a":[{},[0,0,2]]}],"y":[{},[0,3]],"á":[{},[0,3]],"ó":[{},[0,3]],"š":[{"r":[{},[0,0,4]]},[0,0,3,2]],"ů":[{"s":[{},[0,0,0,0,3]]},[0,3]],"ý":[{},[0,3]]},[0,2]],"s":[{"a":[{},[0,3]],"e":[{},[0,3]],"h":[{},[0,3]],"i":[{"n":[{},[0,3]]}],"n":[{"á":[{},[0,0,3]]}],"o":[{},[0,3]],"p":[{"i":[{},[0,0,3]]}],"t":[{"a":[{"t":[{},[0,0,4]]}],"k":[{},[0,4]],"m":[{},[0,0,4]],"r":[{"u":[{".":[{},[0,4]]}]}],"v":[{},[0,0,3]]}],"u":[{},[0,3]],"v":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"í":[{},[0,3]],"ů":[{},[0,3]]},[0,2]],"t":[{"a":[{},[0,3]],"c":[{"h":[{},[0,0,4]]}],"e":[{},[0,3]],"i":[{"o":[{},[0,4]]},[0,3]],"k":[{"l":[{},[0,0,4]]}],"l":[{"o":[{},[0,0,3]]}],"o":[{},[0,3]],"r":[{"e":[{},[0,0,3]],"o":[{"n":[{},[0,0,3]],"v":[{},[0,0,3]]}],"u":[{},[0,4]],"á":[{},[0,0,4]]},[0,3]],"t":[{"h":[{},[0,0,4]]}],"u":[{},[0,3]],"v":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]],"ó":[{},[0,3]],"ř":[{"í":[{".":[{},[0,4]]}]},[0,0,1]],"ů":[{},[0,3]],"ý":[{},[0,3]]},[0,2]],"u":[{"g":[{"s":[{},[0,0,4]]}],"j":[{"m":[{},[0,0,0,4]]},[0,3]],"s":[{"t":[{},[0,0,0,3]]}],"č":[{},[0,3]]},[0,2]],"v":[{"d":[{".":[{},[0,0,4]]},[0,0,3]],"l":[{"o":[{},[0,0,3]],"u":[{},[0,4]],"í":[{},[0,4]]}],"t":[{"i":[{},[0,0,4]]},[0,0,3]]},[2]],"y":[{"o":[{"n":[{},[0,0,4]]}]},[2]],"z":[{"k":[{},[0,0,3]],"l":[{"a":[{},[0,0,3]],"é":[{},[0,0,4]]}],"n":[{"i":[{},[0,0,3]]}],"p":[{},[0,3]]}],"č":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"l":[{},[0,3]],"m":[{"á":[{},[0,0,4]]}],"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]],"ů":[{},[0,3]]},[0,2]],"ň":[{"o":[{},[0,3]],"u":[{},[0,3]]},[0,2]],"ř":[{"e":[{"k":[{},[0,0,0,4]]}],"í":[{},[0,3]]}],"š":[{"p":[{"l":[{},[0,4]],"y":[{},[0,4]]}]}],"ť":[{},[0,2]],"ú":[{"t":[{},[0,0,3]]}]},[0,1]],"b":[{".":[{},[2]],"a":[{".":[{},[3]],"b":[{"r":[{},[0,0,4]]}],"c":[{"h":[{"r":[{},[0,0,4]]}]}],"k":[{"a":[{},[0,0,3]]}],"s":[{"e":[{},[0,0,4]]}]}],"c":[{},[2,1]],"d":[{},[0,1]],"e":[{"e":[{"f":[{},[0,0,4]],"t":[{},[0,0,4]]}],"j":[{"m":[{},[0,0,0,4]]}],"p":[{},[0,0,3]],"u":[{"r":[{},[0,0,0,4]]}],"z":[{"e":[{},[0,0,0,0,3]]},[0,0,2,3]]}],"h":[{},[0,1]],"i":[{"b":[{},[0,0,2,3]],"s":[{"t":[{},[0,0,0,0,4]]},[0,0,0,3]],"t":[{"r":[{},[0,0,4]]}]},[1]],"j":[{},[0,1]],"k":[{},[2]],"l":[{".":[{},[3]],"b":[{"l":[{},[0,0,4]]}],"e":[{"m":[{},[0,2]],"s":[{},[0,2]]}],"k":[{},[3]],"á":[{"n":[{},[0,4]]}],"é":[{"m":[{},[0,2]]}]}],"m":[{},[0,1]],"n":[{},[2]],"o":[{"e":[{"t":[{},[0,0,4]]}],"j":[{"m":[{},[0,0,4]]}],"o":[{"k":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4]]}],"u":[{"s":[{},[0,0,0,3]]}],"š":[{"k":[{},[0,0,4]]}]},[1]],"r":[{"a":[{"l":[{},[0,2]],"n":[{},[0,2]]}],"i":[{},[2]],"o":[{"d":[{"i":[{"t":[{},[0,4]]}]}],"u":[{},[0,4]],"z":[{},[0,0,0,0,4]]}],"u":[{".":[{},[0,3]],"b":[{},[0,3]]},[0,2]],"á":[{"n":[{},[0,2]]}]}],"s":[{"t":[{"r":[{},[0,0,3]]}]},[2,1,2]],"t":[{"á":[{"h":[{},[0,0,0,0,4]]}]},[2,1]],"u":[{"c":[{},[0,0,2]],"e":[{"n":[{},[0,0,4]]}]}],"y":[{".":[{},[3]],"s":[{"m":[{},[0,0,4]]},[0,0,0,3]],"t":[{"č":[{},[0,0,4]]}],"z":[{"n":[{},[0,0,4]]}]}],"z":[{},[0,2]],"á":[{},[1]],"č":[{},[2,1]],"é":[{"r":[{"c":[{},[0,0,4]]}]}],"ě":[{".":[{},[1]],"t":[{"a":[{},[0,0,3]]}]}],"í":[{"n":[{},[3]],"r":[{"c":[{},[0,0,4]]}]},[1]],"ň":[{},[2]],"ř":[{"a":[{},[0,3]],"e":[{".":[{},[0,3]],"s":[{},[0,0,0,4]]}],"í":[{},[0,1]]}],"š":[{},[2,0,2]]}],"c":[{".":[{},[2]],"a":[{"d":[{"l":[{},[0,0,0,4]]}],"e":[{"s":[{},[0,0,4]]}]},[1]],"c":[{},[2]],"e":[{"c":[{"h":[{},[0,0,0,0,4]]}],"d":[{"l":[{},[0,0,0,4]]}],"l":[{"o":[{},[0,0,0,0,3]]}],"n":[{"s":[{},[0,0,4]]}],"o":[{"v":[{},[0,0,4]]}],"p":[{"s":[{},[0,0,4]]}],"r":[{"v":[{},[0,0,0,4]]}],"u":[{},[0,0,2]]},[1]],"h":[{".":[{},[2]],"a":[{"l":[{"g":[{},[4]]}]},[1]],"e":[{".":[{},[4]]},[3]],"l":[{"y":[{},[0,0,4]]},[2]],"m":[{"b":[{},[0,0,4]]}],"n":[{},[2,0,3]],"t":[{"e":[{},[4]]},[2]],"u":[{".":[{},[0,0,4]]},[1]],"y":[{},[1]],"á":[{},[1]],"ř":[{},[2]]}],"i":[{"e":[{"n":[{"c":[{},[0,0,0,0,4]]}]}],"k":[{"l":[{},[0,0,0,4]]}]},[1]],"k":[{"e":[{"t":[{},[0,4]]}],"t":[{"e":[{"r":[{"ý":[{},[0,0,0,0,4]]}]}]}]},[2,0,2]],"l":[{"a":[{},[0,3]],"é":[{},[0,3]]},[2]],"n":[{},[2]],"o":[{"a":[{"t":[{},[0,0,4]]}],"m":[{"m":[{},[0,0,4]]}],"ž":[{"p":[{},[0,0,4]]}]},[1]],"p":[{},[0,2]],"t":[{"i":[{"s":[{},[0,0,0,0,4]]},[0,2]],"l":[{"a":[{},[0,0,4]]}],"n":[{},[0,0,2]],"v":[{},[0,3]],"ě":[{},[0,2]]},[2]],"u":[{"k":[{},[0,0,0,1]]}],"v":[{},[1,2]],"y":[{},[0,0,2]],"á":[{},[1]],"í":[{"p":[{"l":[{},[0,0,4]]}]},[1]],"ň":[{},[2]],"ů":[{},[1]]}],"d":[{".":[{},[2]],"a":[{"d":[{},[0,0,3]],"j":[{"š":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]},[1]],"b":[{"a":[{"t":[{".":[{},[4]]}]},[0,2]],"á":[{},[0,2]]},[0,1]],"c":[{"h":[{"l":[{},[0,0,0,4]],"n":[{},[3,0,0,4]]}]},[2,1]],"d":[{"h":[{"a":[{},[0,0,4]]}]},[0,1]],"e":[{"b":[{"r":[{"e":[{},[0,0,4]]}]}],"h":[{"n":[{},[0,0,3]]}],"j":[{"d":[{},[0,0,3]],"m":[{"o":[{},[0,0,0,4]]}]}],"k":[{"l":[{},[0,0,3]],"v":[{},[0,0,3]]}],"n":[{"a":[{},[0,0,2]]}],"o":[{"z":[{},[0,0,2]]}],"s":[{"l":[{},[0,0,3]],"m":[{},[0,0,4]],"o":[{},[0,0,4]],"p":[{},[0,0,2]],"t":[{"r":[{},[0,0,3]]},[0,0,0,4]]}],"x":[{"t":[{},[0,0,4]]},[0,0,1]],"z":[{"n":[{},[0,0,3]],"o":[{},[0,0,0,3]]},[0,0,2]],"č":[{"t":[{},[0,0,3]]}],"ž":[{"p":[{},[0,0,4]]}]},[1]],"h":[{},[2,1]],"i":[{"g":[{"g":[{},[0,0,4]]}],"n":[{"d":[{},[4]]}],"s":[{"k":[{},[0,0,0,3]],"o":[{},[0,0,4]]}]},[1]],"j":[{"u":[{"s":[{},[0,0,4]]}]},[0,1]],"k":[{"v":[{},[0,3]]},[2]],"l":[{".":[{},[3]],"a":[{"b":[{},[0,4]],"k":[{},[0,4]]},[0,1]],"i":[{},[0,3]],"n":[{},[1]],"o":[{"u":[{".":[{},[0,3]]},[0,2]]}],"u":[{"č":[{},[0,3]]},[0,2]],"á":[{"ž":[{},[0,4]]}],"é":[{},[0,1]],"í":[{},[2,1]],"ů":[{},[0,2]]}],"m":[{"d":[{},[1]],"ý":[{"š":[{},[0,0,0,0,4]]}]},[0,1]],"n":[{},[2]],"o":[{"b":[{"l":[{},[4]],"o":[{"j":[{},[4]]}],"r":[{"a":[{"t":[{},[0,0,0,4]]}]}],"y":[{},[0,0,3]],"ě":[{},[0,0,3]],"ý":[{},[0,0,3]]}],"d":[{"d":[{},[4,0,4]],"j":[{},[4,0,4]],"n":[{},[0,0,0,4]]},[0,0,1]],"h":[{},[0,0,3]],"j":[{"m":[{},[0,0,0,4]]}],"k":[{"n":[{},[4]]}],"l":[{"y":[{},[4]]}],"m":[{"n":[{},[0,0,3]],"o":[{"h":[{},[0,0,0,0,0,4]]}]}],"p":[{"c":[{},[0,0,4]],"n":[{},[0,0,0,4]]},[0,0,3]],"r":[{"v":[{},[0,0,0,2]]}],"s":[{"p":[{},[0,0,0,4]],"t":[{"i":[{"v":[{},[0,0,0,4]]}]}]},[0,0,1]],"t":[{},[0,0,3]],"u":[{"k":[{},[0,0,3]],"č":[{},[0,0,3]]}],"z":[{"n":[{},[0,0,0,4]]},[0,0,3,2]],"č":[{"n":[{},[4,0,4]],"t":[{},[0,0,0,4]]},[0,0,3]],"ž":[{"p":[{},[0,0,4]]}]},[1]],"r":[{"a":[{"n":[{},[4]],"p":[{},[0,4]]}],"e":[{"n":[{},[0,4]]},[0,1]],"o":[{"b":[{"n":[{},[3]]}],"s":[{},[0,3]],"u":[{},[0,3]],"š":[{},[0,3]]}],"s":[{"c":[{},[0,0,4]]}],"u":[{"š":[{},[0,3]]}],"é":[{},[0,3]],"ý":[{"v":[{},[0,4]]},[0,3]]}],"s":[{"k":[{"ů":[{},[0,0,4]]}],"p":[{"o":[{},[0,0,4]]}]},[2,1,2]],"t":[{"l":[{},[0,3]],"ř":[{},[0,3]]},[0,1]],"u":[{"m":[{"ř":[{},[0,0,0,3]]}],"n":[{"a":[{},[0,0,3]]}],"p":[{"n":[{},[0,0,4]]},[0,0,3]],"r":[{},[2]],"s":[{"i":[{},[0,0,3]]}],"í":[{".":[{},[0,0,4]]}]},[1]],"v":[{"a":[{"c":[{},[0,4]]}],"e":[{},[0,3]],"l":[{},[0,3]],"r":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"y":[{"s":[{"u":[{},[0,0,4]]}]},[1]],"z":[{"b":[{},[0,3]],"d":[{},[0,3]],"n":[{},[0,3]]}],"á":[{},[1]],"č":[{},[2,1]],"é":[{},[1]],"ě":[{"j":[{},[3]]},[1]],"í":[{},[1]],"ň":[{},[2]],"ř":[{"a":[{},[0,1]],"e":[{"k":[{},[0,0,0,4]],"p":[{"n":[{},[0,0,0,4]]},[0,4]],"v":[{},[0,4]]}],"í":[{"t":[{},[0,2]]},[0,1]]}],"š":[{"k":[{},[0,3]],"t":[{},[0,3]]},[2,0,2]],"ů":[{".":[{},[3]],"s":[{},[0,0,3]]},[1]],"ý":[{},[1]],"ž":[{},[0,2,2]]}],"e":[{".":[{},[2]],"a":[{"d":[{"r":[{},[0,0,3]]}],"r":[{},[0,2]]},[0,1]],"b":[{"e":[{"r":[{},[0,0,4]],"z":[{},[0,0,0,0,2]]}],"l":[{"i":[{},[0,0,4]]}],"ř":[{},[0,2]]},[0,1]],"c":[{"h":[{".":[{},[0,4]],"l":[{".":[{},[0,3]]}],"m":[{},[0,4]],"o":[{},[0,3]],"r":[{},[0,2]],"v":[{},[0,3]],"ť":[{},[0,4]]}]}],"d":[{"b":[{"e":[{},[0,0,4]]}],"k":[{"v":[{},[0,0,4]]}],"l":[{},[0,0,1]],"m":[{"a":[{},[0,0,2]],"n":[{},[0,3]]}],"v":[{},[0,0,3]],"ř":[{"í":[{},[0,0,4]]}]}],"e":[{"t":[{"h":[{},[0,0,4]]}],"x":[{"i":[{},[0,0,3]]}]},[0,1]],"g":[{"g":[{"i":[{},[0,0,4]]}]}],"h":[{"a":[{},[0,1]],"e":[{},[0,1]],"n":[{"o":[{},[0,0,0,0,4]],"ě":[{},[0,0,4]]}],"o":[{},[0,1]],"r":[{},[0,1]],"u":[{},[0,1]],"y":[{},[0,1]],"á":[{},[0,1]],"ý":[{},[0,1]]}],"i":[{"l":[{"u":[{"s":[{},[0,0,0,0,0,3]]}]}]},[0,1]],"j":[{"a":[{"g":[{},[0,0,3]],"s":[{},[0,3]]}],"e":[{"d":[{},[0,3]],"l":[{"e":[{},[0,0,3]]}],"z":[{},[0,3]]},[0,1]],"i":[{"n":[{},[0,0,3]],"s":[{},[0,3]]}],"m":[{"o":[{},[0,0,3]],"u":[{},[0,3]]},[0,0,1]],"o":[{},[0,0,1]],"u":[{"s":[{"t":[{},[0,0,0,3]]}]},[0,0,1]],"v":[{},[0,0,3]]}],"k":[{"a":[{},[0,3]],"e":[{},[0,3]],"l":[{"y":[{},[0,4]]}],"o":[{},[0,3]],"r":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"ó":[{},[0,3]],"ř":[{},[0,3]],"ů":[{},[0,3]]},[0,2]],"l":[{"a":[{"u":[{},[0,4]]},[0,1]],"d":[{"v":[{},[0,0,4]]}],"e":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"y":[{},[0,1]],"z":[{"e":[{},[0,0,4]]}],"á":[{},[0,1]],"é":[{},[0,1]],"í":[{},[0,1]]}],"m":[{"l":[{"í":[{},[0,4]]},[0,1]],"o":[{"k":[{},[0,0,0,3]]}],"r":[{},[0,1]],"y":[{},[0,1]],"á":[{},[0,3]],"ě":[{},[0,1]],"í":[{},[0,1]],"ř":[{},[0,3]],"ů":[{},[0,3]],"ý":[{},[0,1]],"ž":[{"e":[{},[0,0,3]]}]}],"n":[{"d":[{"v":[{},[0,0,4]]}],"i":[{"t":[{"o":[{"s":[{},[0,0,0,0,0,0,4]]}]}]}],"s":[{"c":[{},[0,0,4]],"i":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,0,3]]}]}],"o":[{"b":[{"y":[{},[0,0,3]]}],"c":[{"h":[{"r":[{},[0,0,0,0,3]]}]}],"d":[{"l":[{},[0,0,0,3]],"u":[{},[0,0,4]]}],"l":[{"e":[{},[0,4]]}],"s":[{"t":[{},[0,0,2]]},[0,0,1]],"t":[{"ř":[{},[0,0,4]]}],"z":[{"b":[{},[0,0,4]],"d":[{},[0,0,4]]},[0,0,3]],"š":[{"e":[{},[0,0,0,0,3]]}]},[0,1]],"p":[{"a":[{"t":[{},[0,0,0,3]]}],"l":[{},[0,2]],"n":[{"i":[{},[0,4]],"o":[{},[0,0,2]],"ý":[{},[0,4]]}],"o":[{"č":[{"t":[{},[0,0,0,0,3]]}]}],"r":[{"o":[{"z":[{"ř":[{},[0,0,0,0,4]]}]}]}],"t":[{"l":[{},[0,0,4]],"m":[{},[0,0,4]],"n":[{},[0,0,4]],"u":[{},[0,4]]}],"y":[{},[0,0,0,3]]}],"r":[{"a":[{".":[{},[0,0,4]]},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"s":[{".":[{},[0,0,4]],"n":[{},[0,0,4]]},[0,0,3]],"u":[{},[0,1]],"y":[{},[0,1]],"á":[{},[0,1]],"é":[{},[0,1]],"ů":[{},[0,1]],"ý":[{},[0,1]]},[2]],"s":[{"a":[{"g":[{},[0,4]]}],"c":[{"e":[{},[0,2]]}],"i":[{"n":[{},[0,4]],"s":[{},[0,0,0,4]]}],"k":[{".":[{},[0,0,4]],"n":[{},[0,4,4]],"u":[{".":[{},[0,0,3]]}],"y":[{},[0,0,3]],"é":[{},[0,0,3]]},[0,2]],"l":[{"i":[{},[0,4,3]],"y":[{},[0,4]]},[0,2]],"m":[{},[0,0,2]],"p":[{".":[{},[0,4]],"e":[{},[0,0,4]]}],"t":[{".":[{},[0,4]],"e":[{},[0,4]],"i":[{"ž":[{},[0,0,3]]}],"o":[{"l":[{},[0,0,4]]}],"r":[{"o":[{"u":[{},[0,4]]}]}],"á":[{"n":[{},[0,0,3]]}]},[0,2]]},[0,1]],"t":[{"k":[{"i":[{},[0,4]],"r":[{},[0,4]]}],"l":[{"i":[{},[0,4]],"y":[{},[0,4]]}],"r":[{"i":[{},[0,0,3]],"o":[{},[0,0,3]],"ů":[{},[0,0,3]]}],"ř":[{},[0,0,1]],"ú":[{"n":[{},[0,0,4]]}]},[0,1]],"u":[{"b":[{},[0,0,3]],"c":[{"t":[{},[0,0,3]]}],"d":[{},[0,0,3]],"k":[{},[0,0,3]],"m":[{".":[{},[0,0,4]]},[0,0,3]],"n":[{},[0,0,3]],"p":[{},[0,0,3]],"r":[{".":[{},[0,0,4]],"a":[{"s":[{},[0,0,4]]},[0,4]],"g":[{},[0,0,4]]},[0,0,3]],"s":[{},[0,0,3,2]],"t":[{".":[{},[0,4,4]],"r":[{"a":[{},[0,0,4]]}],"s":[{},[0,0,4]]},[0,0,3]],"v":[{},[0,0,3]],"z":[{},[0,0,3]],"ž":[{},[0,0,3]]},[0,1]],"v":[{"d":[{},[0,3]],"e":[{"š":[{},[0,0,0,4]]}],"k":[{},[0,3,2]],"s":[{"k":[{},[0,4]]}],"y":[{"j":[{"a":[{"d":[{},[0,0,0,0,0,0,4]]}]}],"p":[{"á":[{"t":[{},[0,0,0,0,0,4]]}]}],"č":[{"k":[{},[0,0,0,4]]}]},[0,0,0,3]],"ě":[{"t":[{"r":[{},[0,0,0,4]]}]}]}],"x":[{"t":[{"a":[{},[0,0,4]]}],"u":[{},[0,3]]}],"y":[{"o":[{"r":[{},[0,0,4]],"v":[{},[0,0,4]]}]}],"z":[{"a":[{"o":[{"s":[{},[0,0,0,0,0,3]]}],"p":[{},[0,0,4]]}],"b":[{"o":[{},[0,0,4]]}],"d":[{"e":[{},[0,0,3]],"o":[{"v":[{},[0,0,3]]}],"u":[{},[0,0,3]],"ě":[{},[0,0,4]]}],"e":[{"d":[{},[0,0,4,0,2]],"j":[{},[0,0,4]],"l":[{},[0,0,4]],"r":[{},[0,0,4]],"s":[{},[0,0,4]],"z":[{},[0,0,4]],"š":[{},[0,0,4]]},[0,3]],"i":[{"s":[{},[0,0,0,0,4]],"t":[{},[0,0,4]]}],"l":[{"e":[{},[0,0,4]]}],"n":[{"á":[{},[0,0,4]],"ě":[{},[0,0,4]]}],"p":[{"y":[{},[0,0,4]]}],"t":[{},[0,0,2]],"á":[{"c":[{},[0,0,4]],"h":[{},[0,0,4]]}],"č":[{"e":[{},[0,0,4]]}],"í":[{},[0,3]],"ř":[{"e":[{},[0,0,4]]},[0,3]]}],"á":[{},[0,1]],"č":[{"k":[{"a":[{"t":[{},[0,0,4]]}]}],"t":[{"e":[{},[0,0,4]],"i":[{},[0,4]],"í":[{},[0,4]]},[0,1]]}],"ň":[{"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]]},[0,2]],"ó":[{"n":[{},[0,3]]}],"ř":[{"e":[{"k":[{},[0,0,0,4]]}],"k":[{"u":[{},[0,0,4]]}],"í":[{},[0,3]]},[0,1]],"š":[{"e":[{},[0,3]],"i":[{},[0,3]],"k":[{"a":[{},[0,4]]}],"l":[{"á":[{},[0,0,4]]},[0,3]],"o":[{},[0,3]],"t":[{"o":[{},[0,0,4]],"í":[{"h":[{},[0,0,0,0,0,4]]}]}],"í":[{},[0,3]]},[0,2]],"ú":[{"m":[{"y":[{},[0,0,0,0,4]]}],"n":[{},[0,0,3]],"p":[{},[0,0,3]],"t":[{},[0,0,3]],"č":[{},[0,0,3]]},[0,0,1]],"ž":[{"í":[{"š":[{},[0,0,0,0,4]]}]}]}],"f":[{".":[{},[2]],"e":[{"i":[{"n":[{},[0,0,4]]}],"n":[{"e":[{},[0,0,0,0,4]]}],"u":[{"e":[{},[0,0,4]]}]}],"i":[{"e":[{"m":[{},[0,0,4]]}],"f":[{"l":[{},[0,0,4]]}]}],"l":[{"í":[{},[0,3]],"ó":[{"r":[{},[0,0,0,4]]}]},[0,2]],"m":[{"n":[{"o":[{},[0,0,4]]}]}],"n":[{},[2]],"r":[{"a":[{"n":[{},[0,4]],"s":[{},[0,4]]}],"e":[{"k":[{},[3]]}],"i":[{},[0,1]]},[2]],"s":[{"t":[{"e":[{},[0,0,4]]}]},[2]],"t":[{},[2]],"u":[{"c":[{"h":[{},[0,0,4]]}]}],"é":[{},[2]],"ú":[{},[0,2]]},[1]],"g":[{".":[{},[2]],"a":[{"u":[{"č":[{},[0,0,4]]}]}],"e":[{"s":[{},[0,0,2]]}],"h":[{"o":[{"u":[{},[0,0,0,0,4]]}]}],"i":[{"c":[{},[3]],"n":[{},[3]],"í":[{"m":[{},[0,0,4]]}]}],"l":[{"o":[{"m":[{},[0,4]]}]}],"m":[{},[2,1]],"n":[{"o":[{"i":[{},[0,4]],"s":[{},[0,4]]}]},[2]],"o":[{"h":[{"m":[{},[0,0,4]]}]},[0,0,1]],"r":[{"a":[{"f":[{},[3]]}]}],"u":[{"e":[{"l":[{},[0,0,4]]}],"i":[{"t":[{},[0,0,4]]}],"m":[{".":[{},[0,0,4]]},[0,0,3]],"s":[{"t":[{},[0,0,0,4]]}],"v":[{},[0,0,3]]}]},[1]],"h":[{".":[{},[2]],"a":[{"a":[{"g":[{},[0,0,4]],"r":[{},[0,0,4]]}],"b":[{"l":[{},[0,0,4]],"r":[{},[0,0,4]]}],"d":[{"l":[{"a":[{},[0,0,4]]},[0,0,3]]}],"k":[{"e":[{},[0,0,4]]}],"s":[{"t":[{},[0,0,0,3]]}],"t":[{"o":[{"s":[{},[0,0,0,0,0,4]]}]}],"y":[{"d":[{},[0,0,4]]}]}],"b":[{},[0,2]],"c":[{},[0,2]],"d":[{},[2]],"e":[{"b":[{"r":[{},[0,0,4]]}],"i":[{"d":[{},[0,0,4]]}],"j":[{"s":[{},[0,0,0,4]]}],"s":[{},[0,0,2]],"u":[{},[0,0,2]],"x":[{},[0,0,3]]}],"i":[{"a":[{"n":[{},[0,0,4]]}],"e":[{"r":[{},[0,0,3]]}],"g":[{"h":[{},[0,0,4]]}],"r":[{"e":[{},[0,0,4]]}]}],"k":[{},[2]],"l":[{"a":[{".":[{},[4]]}],"e":[{"d":[{},[0,4]],"n":[{},[0,3]]}],"i":[{},[2]],"o":[{".":[{},[4,3]],"b":[{},[0,3]],"p":[{},[0,3]],"v":[{},[0,3]]}],"u":[{"j":[{},[0,3]]}],"y":[{},[2,1]],"á":[{".":[{},[4]],"s":[{},[0,4]]}],"í":[{".":[{},[0,3]],"k":[{},[4]]}],"ý":[{},[2]]}],"m":[{},[0,2]],"n":[{"e":[{"d":[{},[0,4]]},[0,3]],"i":[{"v":[{},[0,3]]}],"o":[{"j":[{},[0,4]]}],"ě":[{"d":[{},[3]]}]},[2,2]],"o":[{"d":[{"i":[{"n":[{},[3]]}]}],"s":[{"t":[{"r":[{},[0,0,3]],"ě":[{},[0,0,0,4]]}]}],"v":[{"e":[{},[4]],"n":[{"a":[{},[4]],"y":[{},[4]],"á":[{},[4]],"ě":[{},[4]]}]}]}],"r":[{"a":[{"p":[{},[0,0,0,4]]}]},[0,2]],"t":[{"i":[{"n":[{},[0,4]]}],"ě":[{},[0,2]],"í":[{"t":[{},[0,4]]}]},[2,1]],"u":[{"c":[{"h":[{},[0,0,4]]}],"m":[{"o":[{},[0,0,3]]}],"t":[{"ň":[{},[0,0,4]]}]}],"v":[{},[2,2]],"y":[{"d":[{"o":[{},[0,0,4]]},[0,0,0,1]],"p":[{"s":[{},[0,0,4]]}],"s":[{},[0,0,0,3]],"t":[{"r":[{},[0,0,2,3]]}],"z":[{"d":[{},[0,0,4]]}]}],"č":[{},[0,1]],"ň":[{},[2]],"ř":[{"b":[{"y":[{},[0,0,4]]}]},[0,0,2]],"ý":[{"b":[{"l":[{},[0,0,4]]}]}],"ž":[{},[0,2]]}],"i":[{".":[{},[2]],"a":[{"d":[{},[0,0,3]],"g":[{},[0,0,3,2]],"l":[{".":[{},[0,4]]}],"s":[{"t":[{},[0,0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]},[0,1]],"b":[{"l":[{},[0,0,2]],"r":[{},[0,2,1]]},[0,1]],"c":[{"h":[{"ž":[{},[0,4]]},[0,1]]}],"d":[{"g":[{"e":[{},[0,0,4]]}],"l":[{"o":[{".":[{},[0,0,4]]}],"ý":[{},[0,4]]},[0,0,2]]},[0,1]],"e":[{"m":[{},[0,1]],"n":[{},[0,1]],"t":[{},[0,1]]}],"f":[{"r":[{},[0,0,1]]}],"g":[{"n":[{"e":[{},[0,0,4]]}]}],"h":[{"l":[{".":[{},[0,3]],"i":[{},[0,4]]},[0,2]],"n":[{"a":[{},[0,0,4]]},[0,0,3]]},[0,1]],"i":[{"m":[{},[0,3]]}],"j":[{"e":[{"d":[{},[0,0,0,0,4]]}],"m":[{"e":[{},[0,0,4]],"i":[{},[0,0,4]]}]},[0,1]],"k":[{"l":[{"e":[{},[0,0,3]],"o":[{".":[{},[0,0,3]]}]},[0,2]],"m":[{},[0,0,3]],"r":[{"y":[{},[0,0,4]]}],"v":[{"e":[{},[0,4]]}],"ú":[{"ř":[{},[0,0,4]]}]}],"l":[{"b":[{"a":[{},[0,0,4]]}],"i":[{"č":[{"n":[{},[0,0,0,0,4]]}]}],"n":[{"u":[{},[0,4]]}],"u":[{},[0,0,0,3]]},[0,1]],"m":[{"l":[{"a":[{},[0,4]],"y":[{},[0,4]]}],"u":[{"n":[{},[0,4]]}]},[0,1]],"n":[{"a":[{"d":[{},[0,0,0,3]]},[0,3]],"c":[{"m":[{},[0,0,4]]}],"d":[{"l":[{},[0,0,4]]}],"e":[{},[0,3]],"f":[{"e":[{},[3]]}],"g":[{"h":[{},[0,0,4]],"p":[{},[0,0,4]],"s":[{},[0,0,4]],"t":[{},[0,0,4]]}],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]],"š":[{"p":[{},[0,0,4]]}],"ů":[{},[0,3]],"ý":[{},[0,3]]},[0,2]],"o":[{"s":[{"k":[{},[0,0,4]]}]},[0,1]],"p":[{"s":[{},[0,2]]}],"r":[{"o":[{"s":[{},[0,0,0,4]]}]},[0,1]],"s":[{"a":[{},[0,1]],"c":[{"h":[{},[0,0,4]]},[0,0,3]],"k":[{".":[{},[0,0,4]],"a":[{},[0,0,3]],"e":[{},[0,0,3]],"o":[{".":[{},[0,0,3]]}],"r":[{},[0,0,3]],"u":[{},[0,0,3]],"v":[{},[0,0,3]],"y":[{},[0,0,3]]}],"l":[{"a":[{"v":[{},[0,3]]}],"o":[{},[0,0,3]],"é":[{},[0,0,3]]}],"p":[{"l":[{},[0,0,3]],"o":[{},[0,0,3]]}],"t":[{"a":[{"l":[{},[0,0,4]],"t":[{},[0,0,4]]}],"h":[{},[0,0,4]],"v":[{},[0,0,0,3]],"í":[{},[0,0,3]]},[0,0,1]],"y":[{},[0,1]],"á":[{},[0,3]]}],"t":[{"r":[{"h":[{},[0,0,4]],"p":[{},[0,0,4]]},[0,0,1]],"s":[{"e":[{},[0,0,4]],"u":[{},[0,0,4]]}],"v":[{},[0,2]]},[0,1]],"u":[{"m":[{},[0,1]]}],"v":[{"d":[{},[0,0,3]]}],"x":[{"t":[{"d":[{},[0,0,4]]}]},[0,1]],"z":[{"p":[{},[0,3]],"r":[{},[0,0,1]]}],"á":[{},[0,1]],"č":[{"l":[{},[0,1]],"t":[{"l":[{},[0,0,4]],"o":[{},[0,0,4]]},[0,0,3]]}],"ď":[{},[0,2]],"é":[{"r":[{"e":[{".":[{},[0,0,4]]}]}]},[0,1]],"í":[{"c":[{},[0,1]],"m":[{},[0,1]]}],"ó":[{},[0,1]],"ř":[{"k":[{"l":[{},[0,0,4]]}],"č":[{"e":[{},[0,0,4]]}]},[0,1]],"š":[{"e":[{},[0,3]],"i":[{},[0,3]],"k":[{"r":[{},[0,0,4]],"v":[{},[0,0,4]]},[0,0,3]],"o":[{},[0,3]],"t":[{"o":[{},[0,0,4]]}],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"ž":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]]},[0,2]]}],"j":[{".":[{},[2]],"a":[{"b":[{},[0,0,2,2]],"c":[{"k":[{},[0,0,0,4]],"q":[{},[0,0,4]]}],"d":[{},[0,0,3]],"g":[{},[0,0,3]],"k":[{"t":[{},[0,3]]}]}],"b":[{"y":[{"s":[{"t":[{},[0,0,0,0,0,3]]}]}]},[0,1,2]],"c":[{},[2,1]],"d":[{"o":[{"b":[{},[0,3]],"k":[{},[0,3]],"s":[{},[0,3]]}],"r":[{},[0,3]],"á":[{},[0,3]],"ř":[{"í":[{},[0,0,4]]}],"ů":[{},[0,3]]},[0,2]],"e":[{"c":[{"h":[{},[0,0,0,0,4]]}],"f":[{},[0,3]],"x":[{},[0,3]],"z":[{"d":[{"í":[{},[0,0,0,3]]}]}]}],"g":[{"r":[{"a":[{},[0,0,4]]}]}],"h":[{},[2,1]],"i":[{"c":[{"h":[{},[0,0,4]]}],"h":[{"l":[{},[0,0,0,3]]}],"m":[{"ž":[{},[0,0,4]]}],"n":[{"a":[{},[0,4]]}],"s":[{"k":[{},[0,0,0,3]]}],"t":[{"r":[{"o":[{},[0,0,0,4]]}]}],"z":[{"v":[{},[0,0,2]]}]},[1]],"j":[{},[0,1]],"k":[{"v":[{},[0,3]]},[2]],"l":[{},[2,1]],"m":[{"a":[{},[0,3]],"i":[{},[0,3]],"o":[{"u":[{"d":[{},[0,0,0,0,3]]}]}],"í":[{},[2]]},[0,2]],"n":[{"e":[{},[0,0,0,3]]},[2]],"o":[{"b":[{},[0,1]],"d":[{"ř":[{},[0,0,0,2]]},[0,1]],"h":[{},[0,1]],"p":[{},[0,1]],"r":[{"a":[{},[0,4]]}],"s":[{"v":[{},[0,0,3]]},[0,1]],"v":[{"l":[{},[0,3]]},[0,2]],"z":[{},[0,1,3,2]]}],"p":[{"o":[{"r":[{},[0,0,0,0,4]],"z":[{"v":[{},[0,0,0,4]]}]}],"ř":[{"í":[{"z":[{},[0,0,0,0,0,4]]}]}]},[2]],"r":[{},[2,1]],"s":[{"e":[{"m":[{},[0,4]]}],"i":[{".":[{},[0,4]]}],"k":[{".":[{},[0,4]],"o":[{},[0,0,4]],"á":[{},[0,0,4]],"ů":[{},[0,4,4]]}],"m":[{"e":[{},[0,4,4]]}],"n":[{},[0,3]],"o":[{"u":[{".":[{},[0,4]],"c":[{},[0,4]]}]}],"p":[{"o":[{},[0,0,4]]}],"t":[{"e":[{},[0,4,4]]}]},[2,1,2]],"t":[{"l":[{},[0,3]]},[2,1]],"u":[{"a":[{"n":[{},[0,0,4]]}],"n":[{"a":[{},[0,0,3]]}],"p":[{},[0,0,3]],"s":[{"p":[{},[0,0,3]]},[0,1]],"t":[{".":[{},[0,0,4]]},[0,0,3]],"v":[{},[0,0,3]],"x":[{"t":[{},[0,0,4]]}],"z":[{},[0,0,3]],"ž":[{"i":[{},[0,0,3]]},[0,1]]}],"v":[{"d":[{},[0,3]],"n":[{},[0,3]]},[2,0,2]],"z":[{"b":[{},[0,3]],"d":[{},[0,3]],"k":[{},[0,3]],"n":[{},[0,3]],"p":[{},[0,3]]},[2]],"á":[{"d":[{"r":[{},[0,0,0,2]]}]}],"č":[{},[2,1]],"ď":[{},[2]],"í":[{},[1]],"š":[{"t":[{"i":[{},[0,0,4]]},[0,3]],"ť":[{},[0,3]]}],"ú":[{"n":[{},[0,0,3]],"č":[{},[0,0,3]],"ž":[{},[0,0,3]]},[2,0,1]],"ž":[{},[2]]}],"k":[{".":[{},[2]],"a":[{"b":[{"l":[{},[0,0,4]]}],"c":[{"h":[{},[0,0,4]]}],"d":[{"l":[{},[0,0,3]]}],"j":[{},[3]],"k":[{"a":[{},[0,0,3]]}],"m":[{"i":[{},[3]]}],"n":[{"ě":[{},[3]]}],"p":[{"l":[{},[0,0,2,3]],"r":[{},[0,0,2,3]],"s":[{},[0,0,2]],"v":[{},[0,0,4]],"ř":[{},[0,0,2]]}],"s":[{"t":[{"r":[{},[0,0,0,0,3]]},[0,0,0,3]]}],"t":[{},[3]],"u":[{"č":[{},[0,0,4]]}],"v":[{},[3]],"č":[{},[3]],"ř":[{},[3]],"š":[{"l":[{},[0,0,0,3]],"p":[{},[0,0,4]]}]}],"c":[{},[2,1]],"d":[{},[0,2]],"e":[{"b":[{"l":[{},[0,0,4]]}],"j":[{"o":[{},[0,0,3]]}],"p":[{"r":[{},[0,0,4]],"s":[{},[0,0,4]]}],"t":[{},[3]]},[0,2]],"f":[{},[2]],"k":[{},[2]],"l":[{".":[{},[3]],"a":[{".":[{},[4,3]]}],"e":[{"j":[{},[0,3]]}],"i":[{".":[{},[4,3]],"b":[{},[0,4]],"c":[{},[0,3]],"č":[{"k":[{"a":[{},[4]]}]}]}],"o":[{".":[{},[4]],"s":[{},[0,3]]}],"y":[{},[2,3]],"á":[{".":[{},[0,3]]}],"é":[{},[0,3]],"ó":[{},[0,3]],"ý":[{},[0,3]]},[0,2]],"m":[{"ě":[{},[0,3]]},[2,2]],"n":[{"a":[{"s":[{},[0,0,0,4]]}]},[2]],"o":[{"b":[{"y":[{},[0,0,3]]}],"f":[{},[3]],"j":[{"m":[{},[0,0,4]]}],"p":[{"ř":[{},[0,0,2]]}],"s":[{"k":[{},[0,0,4]]}],"t":[{"v":[{},[0,0,2,3]]}],"u":[{"s":[{"k":[{},[0,0,0,0,3]]}]}],"v":[{},[3]],"z":[{"á":[{},[0,0,3]]}]}],"r":[{"o":[{"a":[{},[4]],"b":[{},[0,3]],"f":[{},[0,3]]}],"s":[{},[0,0,2]],"ú":[{".":[{},[0,0,4]]}]}],"s":[{},[2]],"t":[{"r":[{},[0,0,2]]},[2,1]],"u":[{"c":[{"h":[{},[0,0,0,0,4]]}],"f":[{"ř":[{},[0,0,4]]}],"h":[{"r":[{},[0,0,4]]}],"j":[{},[3]],"s":[{"e":[{},[0,0,3]],"i":[{},[0,0,3]],"u":[{},[0,0,3]]}],"t":[{"h":[{},[0,0,4]]}],"v":[{},[0,0,3]]}],"v":[{"r":[{"ň":[{},[0,4]]}]},[2,2]],"y":[{"n":[{},[3]],"p":[{"r":[{},[0,0,2]],"ř":[{},[0,0,0,3]]}],"z":[{"n":[{},[0,0,4]]}]}],"á":[{"c":[{},[3]],"p":[{"l":[{},[0,0,4]]}],"r":[{},[3]],"ř":[{},[3]]}],"č":[{},[2]],"ň":[{},[0,2]],"ř":[{"e":[{"j":[{},[0,3]]}]},[0,2,2]],"š":[{"t":[{"i":[{},[0,0,4]]}]}],"ů":[{".":[{},[3]]}]},[1]],"l":[{".":[{},[2]],"a":[{".":[{},[1]],"b":[{"r":[{},[0,0,4]],"s":[{},[0,0,0,4]]}],"k":[{"a":[{},[0,0,3]]}],"n":[{"q":[{},[0,0,4]]}],"p":[{"s":[{},[0,0,4]]}],"s":[{"i":[{},[4,0,3]]}],"v":[{"š":[{},[0,0,4]]}],"y":[{".":[{},[0,0,4]]}],"z":[{"m":[{},[0,0,2]]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"n":[{"e":[{},[0,0,4]]}]},[2,1]],"e":[{"a":[{"d":[{},[0,0,4]],"u":[{},[0,0,4]]}],"c":[{"h":[{"t":[{},[0,0,0,0,3]]}]}],"h":[{"n":[{},[0,0,0,3]]}],"i":[{},[0,0,2]],"j":[{"o":[{},[0,0,3]],"š":[{"k":[{},[4]]}]},[1]],"l":[{},[1]],"n":[{"c":[{"h":[{},[4]]}]}],"p":[{"a":[{"d":[{},[0,0,0,0,3]]}],"o":[{"s":[{},[0,0,0,0,4]]}],"r":[{},[0,0,4]],"s":[{},[0,0,4]]}],"s":[{"c":[{},[0,0,4]],"m":[{},[0,0,4]],"v":[{},[0,0,4]]}],"t":[{"l":[{"i":[{},[0,0,0,4]]}],"m":[{},[0,0,0,3]],"r":[{},[0,0,2]],"č":[{},[0,0,4]]}],"u":[{"k":[{},[0,0,4]]}],"v":[{"h":[{},[0,0,4]],"k":[{},[0,0,4]]}],"x":[{"i":[{},[0,0,3]]}],"z":[{"n":[{},[0,0,0,3]]}]}],"f":[{},[2]],"g":[{},[2]],"h":[{"a":[{"n":[{},[3]]}]},[2]],"i":[{"a":[{"z":[{},[0,0,4]]}],"b":[{"l":[{},[0,0,4]],"v":[{},[0,0,4]]}],"d":[{"m":[{},[0,0,4]]}],"n":[{"d":[{},[0,0,0,0,4]]}],"o":[{},[3]],"t":[{"ň":[{},[0,0,4]]}],"v":[{"r":[{},[0,0,4]]}],"ž":[{},[2]]},[1]],"j":[{},[2]],"k":[{"a":[{"t":[{},[0,4]]}],"l":[{},[0,2]],"n":[{"u":[{},[0,0,4]]}]},[2]],"l":[{},[2]],"m":[{},[2,1]],"n":[{"u":[{"l":[{},[0,4]]}]},[2]],"o":[{"b":[{"r":[{},[0,0,3]]}],"i":[{"d":[{},[0,0,4]],"s":[{},[0,0,4]]}],"s":[{"p":[{},[0,0,3]],"t":[{"ř":[{},[0,0,3]]}],"v":[{},[0,0,3]]},[1]],"t":[{"r":[{},[0,0,2]],"ř":[{},[0,0,4]]}],"u":[{".":[{},[0,0,4]]}],"z":[{"d":[{},[0,0,0,4]]},[0,0,3]],"š":[{"k":[{},[0,0,4]]}]}],"p":[{"ě":[{},[0,2]]},[2]],"s":[{"l":[{"a":[{},[0,4]]}],"n":[{},[0,0,3]],"t":[{"n":[{},[0,0,0,4]],"í":[{},[0,4]]}]},[2,1,2]],"t":[{"r":[{"a":[{},[0,0,4]],"u":[{},[0,0,4]],"y":[{},[0,0,4]]}]},[2,1]],"u":[{"i":[{"d":[{},[0,0,4]]}],"j":[{".":[{},[0,0,4]]}],"k":[{".":[{},[0,0,4]]}],"l":[{"k":[{},[0,0,4]]}],"m":[{".":[{},[0,0,4]],"n":[{},[0,0,4]]}],"p":[{"r":[{},[0,0,3]]}],"v":[{"a":[{},[0,0,3]],"l":[{},[0,0,3]],"y":[{},[0,0,3]],"í":[{},[0,0,3]]}]}],"v":[{},[2]],"z":[{},[2]],"á":[{".":[{},[1]],"j":[{"š":[{},[0,0,4]]}],"v":[{"š":[{},[0,0,4]]}]}],"č":[{},[2,1]],"é":[{".":[{},[1]]}],"í":[{"k":[{},[1]],"p":[{"l":[{},[0,0,4]]}],"z":[{"n":[{},[0,0,4]]}],"ř":[{},[1]]}],"ň":[{},[2]],"š":[{"t":[{"ý":[{},[0,4]]},[0,3]]},[2,0,2]],"ů":[{},[1]],"ý":[{"t":[{},[0,0,2]]},[1]],"ž":[{},[2,2]]}],"m":[{".":[{},[2]],"a":[{"j":[{"s":[{},[0,0,0,4]]}],"k":[{"l":[{},[0,0,4]],"r":[{},[0,0,4]]}],"l":[{"d":[{},[4]]}],"s":[{"k":[{},[0,0,0,3]]}],"t":[{"r":[{"a":[{},[0,0,4]]},[0,0,0,3]]}],"v":[{"š":[{},[0,0,4]]}],"z":[{"l":[{},[0,0,0,3]]}]},[1]],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{"l":[{},[0,2]]},[2,1,2]],"e":[{".":[{},[3]],"g":[{"o":[{},[0,0,4]]}],"i":[{"s":[{},[0,0,4]]}],"t":[{"r":[{"e":[{},[0,0,0,3]]}]}],"x":[{},[0,0,3]],"z":[{"i":[{"s":[{},[0,0,0,0,3]]}]}]},[1]],"f":[{},[2]],"h":[{"l":[{"e":[{},[0,0,4]]}]}],"i":[{"d":[{"l":[{},[0,0,0,3]]}],"k":[{"r":[{},[0,0,0,3]]}],"x":[{"t":[{},[0,0,4]]}]},[1]],"k":[{"l":[{"a":[{},[0,0,4]],"i":[{},[0,0,4]]},[3,2]]},[2,0,2]],"l":[{"a":[{".":[{},[4]]}],"e":[{},[2]],"h":[{".":[{},[0,0,4]]},[0,0,3]],"i":[{},[2]],"s":[{"c":[{},[0,0,4]],"k":[{},[0,0,4]]}],"u":[{".":[{},[4]]}]},[0,2]],"n":[{"a":[{"s":[{},[0,0,0,4]]},[0,3]],"o":[{"h":[{},[0,4]],"s":[{},[0,3]],"z":[{},[0,4]],"ž":[{},[3]]}],"á":[{},[0,3]],"é":[{"z":[{},[0,4]]},[0,3]],"ě":[{"j":[{},[0,3]]}],"ý":[{},[0,3]]},[2]],"o":[{"d":[{"r":[{},[0,0,0,3]]}],"h":[{"l":[{},[0,0,2]]}],"k":[{},[0,0,2]],"s":[{".":[{},[0,0,4]]},[0,0,2]],"t":[{"ř":[{},[0,0,0,3]]}],"u":[{"t":[{},[4]]}],"z":[{"a":[{},[0,0,0,0,4]],"ř":[{},[0,0,3]]}],"ú":[{},[0,0,0,3]]},[1]],"p":[{"l":[{"o":[{},[0,4]]}],"o":[{"s":[{},[0,0,0,4]]}],"s":[{"e":[{},[0,0,4]]},[0,2]],"t":[{},[0,0,2]]},[2]],"r":[{"s":[{},[0,0,2]]}],"s":[{"t":[{"l":[{},[0,4]]}]},[2,1,2]],"t":[{},[2,1]],"u":[{"f":[{"l":[{},[0,0,4]]}],"n":[{".":[{},[0,0,4]],"d":[{},[0,0,4]],"n":[{},[0,0,4]],"s":[{},[0,0,4]],"š":[{},[0,0,4]]},[0,0,3]],"š":[{},[2]]},[1]],"v":[{},[2]],"y":[{"s":[{"l":[{"o":[{},[0,0,0,3]]}]}],"š":[{"k":[{},[0,0,4]]}]}],"z":[{},[2]],"á":[{".":[{},[3]],"l":[{"o":[{},[0,0,0,0,3]]}],"s":[{},[0,0,2]]}],"č":[{"e":[{},[0,2]]},[2]],"í":[{"c":[{},[0,0,1]],"r":[{"ň":[{},[0,0,4]]}]}],"š":[{"č":[{"i":[{},[0,0,4]]}],"ť":[{"a":[{"n":[{".":[{},[0,0,4]]}]}]},[0,0,3]]},[2,2]],"ů":[{".":[{},[3]]}],"ý":[{".":[{},[3]]}],"ž":[{},[0,2]]}],"n":[{".":[{},[2]],"a":[{".":[{},[3]],"c":[{"h":[{},[0,0,3]]}],"d":[{"o":[{},[0,0,4]]}],"e":[{"m":[{},[0,0,4]]}],"h":[{".":[{},[0,0,4]]},[0,0,3]],"j":[{"d":[{},[0,0,3]]}],"k":[{"a":[{},[0,0,3]]}],"m":[{"n":[{"e":[{},[0,0,0,4]]}]}],"p":[{},[0,0,3,2]],"s":[{".":[{},[0,0,4]]},[0,0,3,2]],"t":[{"l":[{},[0,0,3]],"ř":[{},[0,0,3]]},[0,0,0,2]],"z":[{"k":[{},[0,0,0,4]],"š":[{},[0,0,4]]},[0,0,3]],"č":[{".":[{},[0,0,4]]}],"š":[{},[0,0,3]],"ž":[{"n":[{},[0,0,0,4]]}]}],"b":[{},[2]],"c":[{"h":[{"c":[{},[0,4]]}]},[2,1]],"d":[{"h":[{"i":[{},[0,0,4]]}],"o":[{"t":[{},[0,0,0,4]]}],"r":[{"e":[{},[0,0,2]],"i":[{},[0,0,4]]}],"ř":[{"í":[{},[0,0,4]]}]},[2,1]],"e":[{"d":[{},[0,0,1]],"g":[{"l":[{},[0,0,4]]}],"h":[{"n":[{},[0,0,3,4]]},[0,0,1]],"j":[{"t":[{},[0,0,0,3]],"u":[{},[0,0,0,3]]},[0,0,2]],"k":[{"l":[{},[0,0,3]],"r":[{"o":[{},[0,0,4]]}],"v":[{},[0,0,3]]}],"m":[{".":[{},[0,0,4]]}],"p":[{},[0,0,3]],"s":[{".":[{},[0,0,4]],"l":[{"e":[{},[0,0,0,4]]}],"s":[{},[0,0,4]],"t":[{"i":[{},[4]]}]},[0,0,3,2]],"t":[{"l":[{},[0,0,3]],"r":[{},[0,0,0,4]]}],"u":[{"d":[{},[0,0,3]]}],"v":[{".":[{},[0,0,4]]},[0,0,3,2]],"z":[{"n":[{},[0,0,0,4]]},[0,0,3]],"š":[{"k":[{},[0,0,3]],"ť":[{},[0,0,3]]}]}],"f":[{"r":[{},[0,3]]},[2]],"g":[{"l":[{"a":[{},[0,0,4]],"e":[{},[0,0,4]],"í":[{},[0,0,4]]},[0,0,1]],"r":[{"o":[{},[0,4]]}],"v":[{"i":[{},[0,0,4]]}]},[2]],"i":[{"k":[{"t":[{},[0,0,0,4]]}],"m":[{"r":[{},[0,0,4]],"ž":[{},[0,0,4]]}],"o":[{},[3]],"s":[{"k":[{},[3]]}],"t":[{"ř":[{},[2]]}]}],"j":[{},[0,1]],"k":[{},[2]],"l":[{},[2,1]],"n":[{},[2]],"o":[{"b":[{"s":[{},[0,0,4]]},[0,0,3,2]],"h":[{"n":[{},[0,0,3]],"s":[{},[0,0,4]]}],"i":[{"r":[{},[0,0,4]]}],"m":[{"ž":[{},[0,0,4]]}],"s":[{"k":[{"y":[{},[0,0,4]]}],"m":[{},[0,0,3]],"t":[{"r":[{},[0,0,3]]}]}],"t":[{"r":[{},[0,0,0,4]]}],"z":[{"d":[{},[0,0,4]]},[0,0,3]],"š":[{"k":[{},[0,0,4]]}],"ž":[{},[2]]}],"s":[{"a":[{"k":[{},[0,0,3]]},[0,2]],"k":[{"o":[{},[0,0,4]]}],"o":[{"c":[{},[0,4]]}],"p":[{"o":[{},[0,0,3]]}],"t":[{"r":[{"a":[{},[0,0,0,4]]}]}]},[2,1,2]],"t":[{"e":[{"r":[{"a":[{},[0,0,0,4,3]]}]}],"l":[{"e":[{"m":[{},[0,0,4]]}]}],"r":[{".":[{},[0,0,4]],"u":[{},[0,0,3]],"á":[{},[0,0,3]]}]},[2,1]],"u":[{"b":[{},[2]],"g":[{"g":[{},[0,0,4]]}]}],"y":[{".":[{},[3]]}],"z":[{},[2]],"á":[{"k":[{},[3]],"s":[{".":[{},[0,0,4]]},[0,0,3,2]]}],"č":[{},[2,1]],"ď":[{},[2]],"í":[{"v":[{},[2]],"ž":[{},[2]]}],"ó":[{},[2]],"š":[{"t":[{},[0,3]],"ť":[{"o":[{},[0,0,4]]}]},[2,0,2]],"ů":[{},[0,0,2]],"ž":[{},[2]]},[1]],"o":[{".":[{},[2]],"a":[{"n":[{"g":[{},[0,0,0,0,4]]}]},[0,1]],"b":[{"a":[{},[0,1]],"e":[{"j":[{},[0,0,0,3]],"s":[{},[0,0,0,3]],"z":[{},[0,0,0,3]]},[0,1]],"l":[{},[0,0,1]],"r":[{"ň":[{},[0,0,4]]},[0,0,1]],"u":[{},[0,1]],"y":[{"s":[{},[0,0,0,0,4]]}],"z":[{},[0,0,3]],"é":[{},[0,3]],"ř":[{"e":[{"z":[{},[0,0,3]]}]}]}],"c":[{"h":[{"l":[{},[0,4]],"r":[{},[0,2]]}],"k":[{"e":[{},[0,0,4]],"o":[{},[0,0,4]]}],"t":[{".":[{},[0,4]],"n":[{},[0,0,0,3]]}],"y":[{},[0,0,0,3]],"ú":[{"n":[{},[0,0,4]]}]},[0,1]],"d":[{"b":[{},[0,0,3]],"e":[{"j":[{"m":[{},[0,0,0,0,4]]}],"p":[{},[0,0,0,3]],"s":[{},[0,0,0,3]]}],"l":[{},[0,0,1]],"o":[{"c":[{},[0,4]],"s":[{},[0,0,0,0,4]],"t":[{"k":[{},[0,0,0,4]]}]}],"r":[{"a":[{"n":[{},[0,0,4]]},[0,0,3]],"ů":[{},[0,0,3]],"ž":[{},[0,3]]}],"v":[{},[0,0,3]],"ř":[{},[0,0,1]]}],"e":[{"g":[{},[0,0,3]],"t":[{"i":[{},[0,0,3]]}]},[0,1,2]],"f":[{"l":[{},[0,2]],"r":[{"e":[{"k":[{},[0,0,0,0,0,4]]}]}]}],"g":[{"n":[{},[0,3]]},[0,0,2]],"h":[{"n":[{"e":[{},[0,0,4]]}]},[0,1]],"i":[{"c":[{"e":[{},[0,0,4]]}],"n":[{"t":[{},[0,4]]}]},[0,1]],"j":[{"a":[{"r":[{},[0,4]]}],"e":[{"d":[{"l":[{},[0,0,0,4]]}]}],"m":[{"i":[{},[0,4]],"o":[{"v":[{},[0,4]]}],"u":[{},[0,4]],"ů":[{},[0,4]]}],"o":[{},[0,0,2]],"u":[{"z":[{},[0,4]]}]},[0,1]],"k":[{"a":[{},[2]],"t":[{"e":[{},[0,0,2]]}]}],"l":[{"g":[{"l":[{},[0,0,4]]}],"t":[{"o":[{},[0,0,4]]}]},[0,1]],"m":[{"k":[{"l":[{},[0,0,4]]}],"n":[{},[0,0,2]]},[0,1]],"n":[{"a":[{"s":[{},[0,0,0,4]]},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"t":[{"r":[{"a":[{},[0,0,0,4]]}]}],"u":[{},[0,3]],"y":[{},[0,3]],"á":[{"ř":[{"k":[{"a":[{},[0,0,0,0,4]]}]}]},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]],"ů":[{},[0,3]],"ý":[{},[0,3]]},[0,2]],"o":[{"h":[{"ř":[{},[0,0,4]]}],"t":[{"e":[{},[0,0,0,0,2]]}]},[0,1]],"p":[{"o":[{"č":[{"t":[{},[0,0,0,0,3]]}]}],"r":[{"o":[{"s":[{},[0,0,0,0,4]]}]}],"s":[{},[0,2]],"t":[{"u":[{},[0,4]]}],"á":[{"t":[{},[0,0,0,4]]}],"ř":[{".":[{},[0,4]],"e":[{"j":[{"m":[{},[0,0,0,0,4]]},[0,0,0,0,0,4]]}]}]}],"r":[{"a":[{"e":[{},[0,4]]},[0,1]],"d":[{"m":[{},[0,0,4]]}],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"s":[{"t":[{},[0,0,3]]}],"u":[{},[0,1]],"v":[{"á":[{},[0,0,4]]}],"y":[{},[0,1]],"á":[{},[0,1]],"é":[{},[0,3]],"ů":[{"s":[{},[0,0,0,0,3]]},[0,1]],"ý":[{},[0,3]]}],"s":[{"a":[{"i":[{},[0,4]]},[0,1]],"e":[{"s":[{},[0,0,0,4]]}],"i":[{"d":[{},[0,0,0,4]]}],"k":[{"e":[{},[0,4,3]],"u":[{},[0,4]],"v":[{},[0,0,0,3]],"á":[{},[0,4]],"ý":[{},[0,4]]},[0,1]],"l":[{"a":[{},[0,0,4]],"i":[{},[0,0,4]],"ý":[{},[0,0,4]]},[0,1]],"m":[{"o":[{},[0,0,3]],"u":[{},[0,0,4]]}],"t":[{".":[{},[0,4]],"g":[{},[0,4]],"m":[{},[0,4]],"o":[{"r":[{},[0,0,4]]}],"r":[{"ů":[{},[0,0,3]]}],"é":[{},[0,4]],"š":[{},[0,4]],"ý":[{},[0,4]]}],"y":[{},[0,1]]}],"t":[{"k":[{"l":[{},[0,0,4]]}],"l":[{"ý":[{},[0,4]]}],"o":[{"s":[{},[0,0,0,3]]}],"r":[{"o":[{},[0,0,3]]}],"v":[{"í":[{},[0,0,3]]}],"í":[{},[0,3]],"ř":[{"i":[{},[0,0,3]]},[0,3]]},[0,1]],"u":[{"b":[{"ě":[{},[0,0,3]]}],"d":[{"ě":[{},[0,0,3]]}],"f":[{"l":[{},[0,0,4]]}],"i":[{"l":[{},[0,0,4]],"s":[{},[0,0,4]]}],"k":[{".":[{},[0,0,4]],"a":[{},[0,0,3]],"l":[{},[0,4]],"r":[{},[0,0,3]],"á":[{},[0,0,3]]}],"m":[{},[0,0,3]],"p":[{"n":[{},[0,0,0,3]],"o":[{},[0,0,0,0,4]]}],"s":[{".":[{},[0,0,4]],"a":[{},[0,0,3]],"e":[{},[0,0,3]],"k":[{},[0,0,4]],"m":[{},[0,0,3]]}],"t":[{"v":[{},[0,0,4]]}],"v":[{"l":[{},[0,0,4]],"n":[{},[0,0,4]]},[0,0,3]],"z":[{"d":[{},[0,0,0,3]]}],"č":[{"k":[{},[0,4]]}],"ž":[{"i":[{},[0,0,3]]}]},[0,2]],"v":[{"i":[{"d":[{"l":[{"a":[{},[0,0,0,4]]}]}]}],"s":[{"k":[{},[0,4]]}],"y":[{"p":[{},[0,0,0,2]]}],"š":[{"t":[{},[0,2]]}]}],"x":[{},[0,1]],"z":[{"a":[{},[0,3]],"b":[{},[0,0,1]],"d":[{".":[{},[0,0,4]],"á":[{},[0,0,3]],"ě":[{},[0,0,3]],"í":[{},[0,0,3]]}],"e":[{"d":[{},[0,0,0,3,2]],"r":[{},[0,0,0,0,4]]},[0,3]],"h":[{},[0,0,1]],"i":[{},[0,3]],"j":[{},[0,0,3]],"k":[{"o":[{},[0,0,4]]},[0,0,3]],"l":[{},[0,0,1]],"m":[{},[0,0,3]],"n":[{".":[{},[0,4]]}],"o":[{},[0,3]],"p":[{"y":[{},[0,0,4]],"ě":[{},[0,0,4]],"í":[{},[0,0,4]]},[0,0,3]],"r":[{"o":[{},[0,0,3]],"u":[{},[0,0,3]],"ů":[{},[0,0,3]]}],"t":[{},[0,0,3]],"u":[{"t":[{},[0,4]]},[0,3]],"v":[{"r":[{},[0,0,3]],"á":[{},[0,0,3]]}],"í":[{},[0,3]],"ů":[{"s":[{},[0,0,0,4]]},[0,3]]},[0,2]],"č":[{"k":[{"a":[{},[0,0,4]]},[0,0,2]]},[0,1]],"ň":[{"a":[{},[0,3]],"o":[{},[0,3]]},[0,2]],"ř":[{"i":[{"s":[{},[0,0,0,2]]}]},[0,1]],"š":[{"k":[{"u":[{},[0,4]],"y":[{},[0,4]]},[0,3]],"l":[{"á":[{},[0,0,4]]},[0,3]],"m":[{"o":[{},[0,0,4]]}],"t":[{"i":[{},[0,0,4]]}],"ť":[{"u":[{},[0,0,4]]}]}],"ž":[{"l":[{},[0,3]],"m":[{"o":[{},[0,0,4]]}]}]}],"p":[{".":[{},[2]],"a":[{"e":[{"d":[{},[0,0,4]],"s":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,4]]}],"s":[{"i":[{},[0,0,3]]}],"t":[{".":[{},[0,0,4]],"r":[{"i":[{},[0,0,0,4]]}]}]}],"c":[{},[2,1]],"e":[{"a":[{"l":[{},[0,0,4]]}],"d":[{"e":[{},[0,0,0,0,4]]}],"i":[{"g":[{},[0,0,4]]}],"n":[{"p":[{},[0,0,4]]}],"r":[{"i":[{},[0,0,0,0,3]]}],"s":[{"t":[{},[0,0,0,3,3]]}],"t":[{"r":[{"a":[{},[0,0,4]]}]}],"č":[{},[3]]}],"i":[{"k":[{"r":[{},[0,0,4]]}],"p":[{"l":[{},[0,0,4]]}]}],"k":[{"l":[{},[0,2]]},[2]],"l":[{".":[{},[3]],"a":[{".":[{},[4,3]]}],"h":[{".":[{},[0,0,4]]},[0,0,3]],"i":[{".":[{},[4,3]]}],"o":[{".":[{},[4]]}]},[0,2]],"n":[{"u":[{},[0,2]]},[2]],"o":[{"b":[{},[0,0,1,2]],"c":[{},[0,0,3,2]],"d":[{"b":[{"ě":[{"h":[{},[0,0,0,0,0,4]]}]}],"n":[{"e":[{"s":[{},[0,0,0,4]]}]}],"r":[{"u":[{},[0,0,3]],"á":[{},[0,0,3]]}]},[3]],"h":[{},[0,0,3]],"l":[{"y":[{},[0,0,0,0,3]]}],"m":[{"p":[{},[0,0,4]]},[0,0,3,2]],"o":[{"l":[{},[0,0,4]]}],"p":[{".":[{},[0,0,4]],"m":[{},[0,0,4]]},[0,0,3]],"s":[{"p":[{},[0,0,0,4]],"t":[{"r":[{},[0,0,0,0,4]]}]},[0,0,1,2]],"t":[{".":[{},[0,0,4]],"n":[{},[0,0,4]]},[0,0,3,2]],"u":[{"k":[{},[0,0,3]],"č":[{},[0,0,3]],"ž":[{},[0,0,3]]}],"v":[{},[3,0,3]],"z":[{"d":[{},[0,0,4]]},[0,0,3,2]],"č":[{"k":[{},[0,0,3]],"t":[{"e":[{},[0,0,0,3]]}]},[0,0,0,2]],"ř":[{"í":[{},[0,0,3]]}],"š":[{"v":[{},[0,0,4]]}]}],"p":[{},[2]],"r":[{"a":[{".":[{},[4]],"s":[{"t":[{},[0,0,0,3]]}]}],"c":[{},[0,0,2]],"o":[{"b":[{},[0,0,0,0,2]],"p":[{},[0,0,0,3]],"t":[{},[0,0,0,3,4]],"z":[{},[0,0,0,3]]},[0,0,0,1]],"s":[{},[0,0,2]],"á":[{"n":[{},[4]]}],"ů":[{},[0,0,0,3]]}],"s":[{"e":[{"s":[{},[0,0,0,4]]}],"k":[{},[2,1]],"u":[{"t":[{},[0,4]]}]}],"t":[{"e":[{"j":[{},[0,4]],"r":[{},[0,4]],"v":[{},[0,4]]}],"r":[{"i":[{},[0,0,4]]}],"u":[{},[0,3]],"á":[{".":[{},[0,4]]}]},[2]],"u":[{"d":[{"l":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,4]]}]}],"y":[{"t":[{"l":[{},[0,0,0,3]]}]}],"á":[{"c":[{},[0,0,2]],"d":[{"l":[{},[0,0,0,3]]}],"n":[{"v":[{},[0,0,4]]}],"s":[{"l":[{},[0,0,4]]}]},[0,0,1]],"č":[{},[2]],"é":[{"r":[{"h":[{},[0,0,4]]}]}],"ř":[{".":[{},[2]],"e":[{"h":[{},[0,0,0,3]],"j":[{},[0,0,0,3]],"t":[{},[0,0,0,3,4]],"z":[{},[0,0,0,3]],"č":[{},[0,0,0,3,2]]}],"i":[{"h":[{},[0,0,0,0,4]]},[0,0,0,3]]}],"š":[{"t":[{"i":[{},[0,0,4]]}]},[2]],"ť":[{},[2]]},[1]],"q":[{"u":[{},[0,0,2]]}],"r":[{".":[{},[2]],"a":[{".":[{},[1]],"b":[{"r":[{},[0,0,4]]}],"e":[{"m":[{},[0,0,4]],"s":[{},[0,0,4]]}],"f":[{"f":[{},[0,0,4]]}],"h":[{"l":[{},[0,0,4]],"m":[{},[0,0,4]]}],"j":[{"g":[{},[0,0,4]],"š":[{},[0,0,4]]}],"k":[{},[2]],"n":[{"h":[{},[0,0,4]]}],"s":[{"i":[{},[0,0,3]],"t":[{"r":[{},[0,0,0,0,4]]}]}],"v":[{"v":[{},[0,0,4]]}],"w":[{"l":[{},[0,0,4]]}],"y":[{".":[{},[0,0,4]],"o":[{},[0,0,4]]}],"ď":[{"m":[{},[0,0,4]]}],"ž":[{"i":[{},[4]]}]}],"b":[{"l":[{},[0,2]]},[0,1]],"c":[{"a":[{},[0,0,0,3]],"h":[{"a":[{},[0,3]],"o":[{},[0,3]]}],"k":[{"i":[{},[0,0,4]]}]},[0,1]],"d":[{"l":[{"a":[{},[0,4]]}],"o":[{"s":[{},[0,0,0,2]]}]},[0,1]],"e":[{"a":[{"d":[{},[0,0,4]],"u":[{},[0,0,4]]}],"d":[{"r":[{},[0,0,0,4]]}],"e":[{"t":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,3]],"v":[{"i":[{},[0,0,3]]}]}],"m":[{"r":[{},[0,0,4]]}],"s":[{"b":[{},[0,0,2]],"l":[{},[0,0,0,3]]}],"t":[{"i":[{"s":[{},[0,0,0,0,0,4]]}],"r":[{},[0,0,0,4]]}],"u":[{"m":[{},[0,0,4]]}]}],"h":[{"a":[{},[0,1]],"l":[{".":[{},[0,3]]}],"n":[{},[0,0,3]],"o":[{},[0,1]],"u":[{},[0,3]],"á":[{},[0,1]]}],"i":[{"b":[{"b":[{},[0,0,4]]}],"c":[{"k":[{"u":[{},[0,0,0,4]]}]},[1]],"d":[{"g":[{},[0,0,4]],"r":[{},[0,0,4]]}],"f":[{"l":[{},[0,0,4]]}],"g":[{"h":[{},[0,0,4]]}],"z":[{"m":[{},[0,0,4]]}]}],"k":[{"l":[{},[0,2]]},[2]],"l":[{},[0,1]],"m":[{"i":[{"o":[{},[0,4]]}]},[2,1]],"n":[{"a":[{"v":[{"š":[{},[0,0,0,4]]}]}],"d":[{"r":[{},[0,0,4]]}]},[2]],"o":[{"a":[{"d":[{},[0,0,4]]}],"b":[{"y":[{},[0,0,3]]}],"d":[{"l":[{},[0,0,0,2]],"r":[{},[0,0,3,4]]}],"f":[{"y":[{},[3]]}],"h":[{".":[{},[0,0,4]]},[0,0,3]],"j":[{"b":[{},[0,0,4]]}],"k":[{"š":[{},[0,0,4]]}],"m":[{"n":[{},[0,0,0,3]],"y":[{"s":[{},[0,0,0,0,4]]}]}],"p":[{"á":[{"t":[{},[0,0,0,0,0,4]]}]}],"s":[{"b":[{},[0,0,2]],"k":[{"v":[{},[0,0,4]],"y":[{},[0,0,4]]}],"v":[{},[0,0,3]]}],"t":[{"i":[{},[0,0,3]],"l":[{},[0,0,3]],"č":[{},[0,0,4]]}],"v":[{"d":[{},[0,0,3]],"ě":[{"t":[{},[0,0,0,0,4]]}],"ý":[{},[3]]}],"z":[{"d":[{},[0,0,0,3]],"n":[{},[0,0,0,3]],"o":[{},[0,0,4]],"v":[{},[0,0,0,3]],"á":[{},[0,0,3]]}],"č":[{"p":[{},[0,0,4]]}]}],"p":[{"a":[{"d":[{},[0,0,0,3]]}]}],"r":[{"h":[{"a":[{},[0,0,4]],"o":[{},[0,0,4]]}]},[2]],"s":[{"t":[{"u":[{},[0,4]],"v":[{"ě":[{},[0,0,3]],"ý":[{},[0,0,3]]}]},[0,2]]},[2,1]],"t":[{"h":[{},[0,2]],"r":[{"á":[{},[0,4]]}],"s":[{"m":[{},[0,0,4]]}],"u":[{},[0,0,0,3]],"v":[{},[0,2,3]],"z":[{"u":[{},[0,0,4]]}]},[2,1]],"u":[{".":[{},[1]],"s":[{"e":[{},[0,0,3]],"i":[{},[0,0,3]],"k":[{},[0,0,0,3]]}],"ž":[{"i":[{},[0,0,3]]}]}],"v":[{"a":[{"n":[{"í":[{},[3]]}]}]}],"x":[{},[0,1]],"y":[{".":[{},[1]],"c":[{"h":[{},[0,0,0,0,3]]}],"d":[{},[0,0,0,2]],"s":[{"k":[{"y":[{},[0,0,0,3]]}],"t":[{},[0,0,0,3]]}],"z":[{"k":[{},[0,0,4]],"n":[{},[0,0,4]]}],"í":[{".":[{},[0,0,4]]}],"š":[{"k":[{},[0,0,4]]}]}],"z":[{"d":[{},[0,0,3]],"l":[{},[0,0,3]]},[2]],"á":[{"d":[{"l":[{},[0,0,0,4]],"ž":[{},[0,0,4]]}],"k":[{},[1]],"r":[{"i":[{},[0,0,3]]}],"ř":[{},[1]]}],"č":[{"i":[{"t":[{"ý":[{".":[{},[4]]}]}]}],"t":[{},[0,0,3]]},[0,1]],"é":[{".":[{},[3]]}],"ó":[{},[2]],"š":[{"n":[{"í":[{},[0,0,4]]}]},[2]],"ů":[{"m":[{".":[{},[0,0,4]]}],"s":[{"t":[{"a":[{},[0,0,0,3]]}]}],"v":[{".":[{},[0,0,4]]}]}],"ý":[{".":[{},[3]],"z":[{"n":[{},[0,0,4]]}]}]}],"s":[{".":[{},[2]],"a":[{"p":[{"f":[{},[0,0,4]],"r":[{},[0,0,4]]}],"s":[{"k":[{},[0,0,0,3]]}]}],"b":[{},[0,2,2]],"c":[{"a":[{},[0,3]],"e":[{".":[{},[0,3]]}],"h":[{"l":[{},[0,0,0,4]],"n":[{},[0,0,0,4]],"o":[{"p":[{},[3]]}]},[0,0,0,2]],"i":[{"e":[{},[0,0,0,4]]},[0,3]],"í":[{},[0,3]]},[0,2]],"d":[{},[0,2]],"e":[{"a":[{"u":[{},[0,0,4]]}],"h":[{},[0,0,3]],"i":[{"g":[{},[0,0,4]],"l":[{},[0,0,4]]}],"j":[{"m":[{},[0,0,0,4]]}],"k":[{"u":[{},[0,0,4]]}],"l":[{"h":[{},[0,0,3]]},[3]],"m":[{},[3]],"r":[{"v":[{"a":[{},[0,0,0,4]]}]}],"s":[{"k":[{},[0,0,0,4]],"s":[{},[0,0,4]],"t":[{"r":[{"a":[{},[0,0,4]],"u":[{},[0,0,4]]}],"ř":[{},[0,0,4]]}]},[0,0,3,2]],"t":[{"k":[{},[0,0,3]],"ř":[{},[0,0,3]]},[0,0,0,2]],"u":[{"r":[{},[0,0,4]]}],"z":[{},[0,0,3]],"č":[{"t":[{},[0,0,3]]}]},[1]],"f":[{"o":[{},[0,3]],"é":[{},[3]],"ú":[{},[0,3]]},[2]],"i":[{"c":[{},[3]],"f":[{"l":[{},[0,0,4]]},[3]],"g":[{"n":[{"o":[{},[0,0,0,4]]}]}],"k":[{},[3]],"s":[{"t":[{"e":[{},[0,0,3]]}]}],"t":[{},[3]]},[1]],"j":[{"u":[{},[0,3]]},[0,2]],"k":[{"a":[{"c":[{},[4]],"k":[{},[0,4]],"m":[{},[4]]}],"o":[{"k":[{},[0,4]],"n":[{},[2]],"s":[{},[0,0,0,0,4]],"t":[{},[4]]}],"r":[{"a":[{},[0,0,4]],"u":[{},[0,0,4]],"y":[{},[0,0,4]]}],"v":[{"e":[{},[4]],"o":[{},[0,0,4]]}],"á":[{"n":[{},[0,3]]}],"ů":[{},[0,3]]},[0,2]],"l":[{".":[{},[3]],"a":[{".":[{},[4,3]],"v":[{},[0,4]]}],"e":[{".":[{},[0,3]],"d":[{},[0,4]],"m":[{},[0,3]],"n":[{},[0,3]],"t":[{},[0,3]]}],"i":[{"b":[{},[0,4]],"č":[{"i":[{},[0,4]]}]}],"n":[{},[3]],"o":[{".":[{},[4,3]]}],"y":[{".":[{},[0,3]]},[0,2]],"í":[{},[0,1]]}],"m":[{"a":[{},[0,2]],"e":[{"k":[{},[0,4]]}],"o":[{},[0,2]]}],"n":[{"a":[{"t":[{},[0,3]]},[0,2]],"e":[{".":[{},[0,3]]},[0,2]],"t":[{"l":[{},[0,0,4]]}],"á":[{".":[{},[0,3]]},[0,2]],"í":[{"d":[{},[0,4]]}]},[2]],"o":[{"b":[{"l":[{},[0,0,0,4]],"r":[{},[0,0,3]]}],"s":[{"k":[{},[0,0,4]]}],"t":[{"v":[{},[0,0,4]]}],"u":[{"h":[{},[0,0,0,3]],"s":[{},[0,0,0,3]],"z":[{},[0,0,0,0,4]]}],"š":[{"k":[{},[0,0,4]]}]},[1]],"p":[{"o":[{"l":[{},[0,4]]}],"r":[{"o":[{"s":[{},[0,0,0,0,4]]}]}]},[0,2]],"r":[{},[1]],"s":[{"s":[{"r":[{},[0,0,4]]}]},[2]],"t":[{".":[{},[2]],"a":[{".":[{},[4]],"j":[{},[0,3]],"n":[{},[0,2]],"t":[{},[0,0,4]]}],"e":[{"c":[{},[4]],"p":[{},[0,4]],"r":[{"o":[{},[0,4]]},[0,0,4]]}],"i":[{"c":[{"h":[{},[0,4]]}],"l":[{},[2]],"n":[{"k":[{},[0,4]]}],"t":[{".":[{},[4]]}],"č":[{},[4]]}],"l":[{"o":[{},[0,0,3]]}],"n":[{},[2]],"o":[{".":[{},[4]],"n":[{"a":[{},[0,4]]}],"u":[{".":[{},[4]]}]}],"r":[{".":[{},[4]],"a":[{"m":[{},[4]]}],"i":[{"k":[{},[0,4]]}],"n":[{},[4]],"á":[{"c":[{},[4]]}]}],"u":[{"p":[{"n":[{"i":[{},[4]]}]}]}],"v":[{"e":[{},[0,0,4]],"í":[{},[3]]},[0,2]],"y":[{".":[{},[4]],"l":[{},[0,4]],"š":[{},[3]]}],"á":[{".":[{},[4]],"ř":[{},[0,3]]},[0,2]],"ě":[{".":[{},[4]],"d":[{},[0,4]],"h":[{},[3]],"r":[{},[0,2]],"ž":[{},[0,2]]}],"í":[{".":[{},[2]]},[0,1]],"ř":[{"e":[{"j":[{},[0,3]]}]}]}],"u":[{"b":[{"a":[{},[0,0,4]],"o":[{},[0,0,4]]}],"m":[{"a":[{},[0,0,0,0,4]]}],"v":[{"e":[{},[0,0,3]]}]},[1]],"v":[{},[0,2]],"y":[{"c":[{"h":[{"r":[{},[0,0,0,0,3]]}]},[0,0,3]],"n":[{"e":[{"s":[{},[0,0,4]]}]}]}],"á":[{"d":[{},[0,0,2]],"h":[{},[3]],"k":[{"l":[{},[0,0,2]]}]}],"č":[{"i":[{},[0,3]]},[2,2]],"é":[{},[1]],"í":[{},[1]],"ň":[{},[2]],"ť":[{"o":[{},[0,3]]},[2]],"ů":[{},[1]],"ž":[{},[0,2]]}],"t":[{".":[{},[2]],"a":[{".":[{},[1]],"b":[{"l":[{},[0,0,2]]}],"c":[{"t":[{"v":[{"o":[{},[0,0,0,4]]}]}]}],"d":[{},[0,2,3]],"j":[{"f":[{},[0,0,4]],"g":[{},[0,0,4]]},[1]],"l":[{"t":[{},[4]]}],"n":[{"d":[{},[4]],"ě":[{},[3]]}],"o":[{},[0,1]],"r":[{"k":[{},[2]]}],"s":[{"t":[{"r":[{},[0,0,3]]},[0,0,0,0,4]]}],"č":[{"k":[{},[0,0,4]]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"e":[{".":[{},[3]],"a":[{"k":[{},[0,0,4]]}],"f":[{"l":[{},[0,0,4]]}],"i":[{"n":[{},[0,0,4]]}],"n":[{"é":[{"m":[{},[4]]}]}],"o":[{"b":[{},[0,0,0,0,4]]}],"p":[{"l":[{},[0,0,0,3]]}],"r":[{"s":[{},[0,0,0,0,4]]}],"s":[{"t":[{"a":[{},[0,0,0,3]]}]}],"t":[{"r":[{},[0,0,4]]}],"u":[{"c":[{},[0,0,4]],"r":[{},[0,0,4]],"t":[{},[0,0,4]]}]},[1]],"f":[{},[2]],"g":[{},[2]],"i":[{"g":[{"r":[{},[0,0,4]]}],"h":[{},[2]],"k":[{"l":[{},[0,0,3]]}],"n":[{"g":[{},[0,0,0,4]]}],"p":[{"l":[{},[0,0,4]]}],"s":[{"l":[{},[0,0,3]],"t":[{"r":[{},[0,0,0,4]]}]}],"t":[{"r":[{},[0,0,4]],"u":[{},[2]]}],"z":[{"r":[{},[0,0,0,4]],"í":[{},[4]]}],"ú":[{},[0,0,0,3]],"ž":[{},[2]]},[1]],"k":[{"a":[{"l":[{},[0,4]],"n":[{},[4,2]],"t":[{},[0,4]]}],"l":[{"a":[{},[0,0,4]],"i":[{},[0,0,4]]},[0,2]],"n":[{"ě":[{},[4]]}],"á":[{},[0,2]]},[2,0,2]],"l":[{".":[{},[3]],"a":[{".":[{},[4]]}],"e":[{"s":[{},[0,0,0,0,3]]},[0,1]],"m":[{},[3]],"o":[{".":[{},[0,3]],"u":[{},[0,4]]}],"u":[{"s":[{},[0,0,0,4]]},[0,0,0,3]],"y":[{},[0,1]],"é":[{},[0,1]]},[2]],"m":[{"a":[{},[0,2]]},[2]],"n":[{"í":[{},[0,3]]},[2]],"o":[{"a":[{"s":[{},[0,0,4]]}],"b":[{"l":[{},[0,0,0,4]]},[0,0,3]],"d":[{"r":[{},[0,0,3]]}],"h":[{"m":[{},[0,0,4]]}],"i":[{"r":[{},[0,0,4]]}],"j":[{},[2]],"l":[{"s":[{},[0,0,0,4]]}],"o":[{"l":[{},[0,0,4]]}],"p":[{".":[{},[4]],"t":[{},[4]],"u":[{},[4]]}],"r":[{"n":[{},[2]]}],"u":[{"p":[{},[2]]}]},[1]],"p":[{},[2]],"r":[{"a":[{"n":[{"t":[{},[0,3]]}]}],"e":[{"a":[{},[0,4]],"f":[{},[0,4]],"t":[{},[0,0,0,4]]}],"i":[{"c":[{".":[{},[4]]}],"p":[{},[0,0,0,0,4]],"t":[{},[0,4]]}],"o":[{"g":[{},[0,4]],"l":[{},[0,3]],"s":[{"k":[{},[0,0,0,4]]}],"u":[{"h":[{},[4]]},[0,4]],"ň":[{".":[{},[4]]}]}],"u":[{"n":[{},[4]],"s":[{},[0,4]],"ž":[{},[4,4]]}],"á":[{"l":[{"n":[{},[0,3]]}],"š":[{},[4]]}],"č":[{},[2]],"ů":[{"m":[{},[0,3]],"v":[{},[0,3]]}],"ý":[{},[2]]}],"s":[{"k":[{"o":[{},[0,0,4]]}],"t":[{},[0,0,2]]},[2,1]],"t":[{"c":[{"h":[{},[0,0,4]]}],"r":[{"i":[{},[0,0,4]]}]},[2,1]],"u":[{".":[{},[1]],"f":[{"f":[{},[0,0,4]]}],"j":[{},[1]],"l":[{"k":[{},[0,0,4]]}],"p":[{},[2]],"r":[{".":[{},[0,0,4]],"y":[{},[0,0,3]]}],"s":[{".":[{},[0,0,4]]}],"ť":[{".":[{},[0,0,4]]}],"ž":[{"i":[{},[0,0,3]]}]}],"v":[{"e":[{},[2]],"i":[{"n":[{"n":[{},[0,4]]}],"š":[{},[0,4]]},[2,3]],"ý":[{"c":[{},[0,4]]}]},[0,2]],"y":[{".":[{},[1]],"g":[{"ř":[{},[0,0,4]]}],"l":[{"a":[{},[0,0,2]]}],"ř":[{"e":[{},[0,0,4]],"h":[{},[0,0,4]],"j":[{},[0,0,4]],"o":[{},[0,0,4]],"r":[{},[0,0,4]],"ú":[{},[0,0,4]]}]}],"á":[{".":[{},[3]],"f":[{"l":[{},[0,0,4]]}]}],"č":[{"i":[{},[0,3]],"í":[{},[2]]},[0,2]],"é":[{"b":[{"l":[{},[0,0,2]]}],"m":[{},[3]]},[1]],"ě":[{"d":[{"l":[{},[0,0,3,4]]}],"h":[{},[2]],"n":[{"n":[{},[2]]}],"p":[{},[2]]},[1]],"í":[{"c":[{".":[{},[4]],"e":[{},[4]]},[1]],"m":[{},[1]],"n":[{},[2]],"r":[{},[2]]}],"ř":[{"e":[{"b":[{},[0,4]],"h":[{"n":[{},[0,0,0,0,3]]}],"l":[{},[0,2]]}],"i":[{"c":[{},[0,2]],"l":[{},[0,3]]}],"t":[{"i":[{},[0,0,4]]}],"u":[{},[0,1]],"á":[{"b":[{},[3]]},[0,2]],"í":[{"s":[{},[0,0,0,4]]}]},[2]],"š":[{"t":[{"i":[{},[0,0,4]]},[0,3]]},[2]],"ů":[{},[1]],"ý":[{".":[{},[1]],"m":[{},[1]],"ř":[{},[1]],"š":[{},[3]]}]}],"u":[{".":[{},[2]],"a":[{"t":[{},[0,2]]}],"b":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"s":[{"t":[{},[0,0,0,4]]}],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{".":[{},[0,3]]}],"ů":[{},[0,3]]},[0,2]],"c":[{"t":[{"í":[{},[0,0,4]]}]}],"d":[{"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"r":[{"u":[{},[0,3]]}],"u":[{},[0,3]],"y":[{},[0,3]],"í":[{},[0,3]]},[2,2]],"e":[{"f":[{"a":[{},[0,0,4]]}]}],"f":[{},[2]],"h":[{"l":[{"á":[{},[0,0,3]]},[0,2]],"n":[{"o":[{},[0,0,3]]}]}],"i":[{"n":[{},[0,2]]}],"j":[{"m":[{},[0,2]]}],"k":[{"a":[{".":[{},[0,3]],"j":[{},[0,0,4]],"l":[{},[0,0,4]],"t":[{},[0,0,4]]}],"e":[{},[0,3]],"l":[{"a":[{},[0,0,3]],"e":[{},[0,0,3]]}],"o":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,3]],"á":[{".":[{},[0,0,4]]}],"ů":[{},[0,3]]},[0,2]],"l":[{"f":[{"a":[{},[0,0,4]]}],"h":[{},[0,0,1]],"p":[{"í":[{},[0,0,4]]}]}],"m":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"p":[{"l":[{},[0,0,4]]}],"r":[{"u":[{},[0,0,4]]}],"u":[{},[0,3]],"á":[{},[0,3]],"ř":[{},[3]]},[0,2]],"n":[{"d":[{"l":[{},[0,0,4]]}],"e":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]],"ů":[{},[0,3]],"ž":[{"r":[{},[0,0,4]]}]},[0,2]],"p":[{"a":[{},[0,3]],"e":[{"r":[{},[0,0,0,2,3]]},[0,3]],"i":[{},[0,3]],"l":[{"n":[{},[0,3]]}],"u":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"ě":[{},[0,3]],"í":[{},[0,3]],"ů":[{},[0,3]]},[0,2]],"r":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[2,3]],"u":[{},[0,3]],"y":[{".":[{},[0,3]]}],"á":[{},[0,3]],"č":[{},[1]],"ů":[{},[0,3]]},[0,2]],"s":[{"k":[{"y":[{},[0,0,3]],"á":[{},[0,0,3]],"é":[{},[0,0,3]],"ý":[{},[0,0,3]]}],"l":[{"o":[{},[0,0,2]]},[0,0,1]],"o":[{},[0,3]],"t":[{"e":[{},[0,4]],"y":[{},[0,4]],"é":[{},[0,4]],"ě":[{},[0,4]],"ř":[{},[0,3]],"š":[{},[0,4]],"ý":[{},[0,4]]}],"u":[{".":[{},[0,3]]}],"y":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]],"ů":[{},[0,3]]},[0,2]],"t":[{"r":[{"o":[{},[0,4]],"á":[{},[0,4]]}]}],"v":[{"i":[{},[0,3]],"u":[{},[0,3]]},[0,2]],"z":[{"e":[{},[0,3]],"i":[{},[0,3]],"l":[{},[0,0,1]],"o":[{},[0,3]],"u":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"č":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"t":[{},[0,0,3]],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"ď":[{},[0,2]],"ň":[{},[0,2]],"š":[{"e":[{},[0,3]],"i":[{},[0,3]],"k":[{"l":[{},[0,0,4]]}],"o":[{},[0,3]],"t":[{"í":[{},[0,0,3]]}],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"ž":[{"e":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]]},[0,2]]},[0,1]],"v":[{".":[{},[2]],"a":[{"d":[{"l":[{},[0,0,3]]}],"j":[{"ť":[{},[0,0,4]]}],"k":[{"l":[{},[0,0,4]]}]}],"b":[{},[2,1]],"c":[{"h":[{},[0,2]]},[2,1]],"d":[{"a":[{"l":[{},[0,4]]}],"i":[{},[0,3]],"ě":[{"k":[{},[0,4]],"č":[{},[0,4]]}]},[2,2]],"e":[{"d":[{"l":[{"e":[{},[0,0,3]]}]}],"j":[{"d":[{},[0,0,3]]}],"n":[{},[3]],"p":[{"s":[{},[0,0,3]],"ř":[{},[0,0,0,3]]},[0,0,2]],"s":[{"l":[{},[0,0,0,3]],"m":[{},[0,0,4]],"p":[{},[0,0,0,4]],"t":[{"a":[{},[0,0,3]]}]}],"t":[{"ř":[{},[0,0,3,4]]}],"z":[{"m":[{},[0,0,2,3]]}]}],"i":[{"c":[{"h":[{},[0,0,4]]}],"d":[{"e":[{},[0,0,0,0,2]],"r":[{},[0,0,4]]}],"e":[{"t":[{},[0,0,4]]}],"k":[{"r":[{},[0,0,4]]}],"t":[{"r":[{},[0,0,2]]}]}],"k":[{"r":[{},[0,2]]},[2]],"l":[{"a":[{".":[{},[2,3]]}],"e":[{".":[{},[4]],"m":[{},[4]]}],"o":[{},[2]]},[0,2]],"m":[{},[2]],"n":[{"a":[{"d":[{},[0,4]]}]},[2]],"o":[{"b":[{},[0,0,3]],"i":[{"c":[{},[0,0,4]]}],"j":[{"a":[{},[0,0,4]],"b":[{},[0,0,4]],"d":[{},[0,0,4]],"j":[{},[0,0,4]],"m":[{},[0,0,4]],"ř":[{},[0,0,4]]}],"s":[{},[0,0,2]],"t":[{"ř":[{},[0,0,4]]}],"u":[{"s":[{},[0,0,0,0,2]]},[0,0,0,3]]}],"p":[{},[0,2]],"r":[{"c":[{},[0,0,2]],"d":[{"l":[{},[0,0,2]]}],"n":[{"y":[{},[4]]}],"o":[{},[0,1]],"s":[{"t":[{"v":[{"ě":[{},[0,0,0,4]]},[0,0,0,0,3]]},[0,0,4]]}]}],"s":[{"k":[{},[0,1]],"t":[{"v":[{},[0,3]]}]},[2,0,2]],"t":[{},[2,2]],"y":[{"c":[{},[0,0,3]],"d":[{"r":[{"a":[{},[0,0,4]]}]},[0,0,3,2]],"p":[{},[0,0,0,2]],"s":[{"n":[{},[0,0,4]],"t":[{},[0,0,0,4]]},[0,0,3,2]],"t":[{},[0,0,3]],"č":[{"k":[{},[0,0,0,4]]},[0,0,3]],"š":[{".":[{},[0,0,4]],"m":[{},[0,0,4]],"š":[{},[0,0,4]]},[0,0,0,2]],"ž":[{"l":[{},[0,0,4]]}]}],"z":[{"n":[{"o":[{},[0,0,4]],"é":[{},[0,0,4]],"ě":[{},[0,0,4]],"í":[{},[0,0,4]]}]},[0,2,2]],"á":[{"r":[{"i":[{},[0,0,3]]}]}],"č":[{"á":[{},[0,3]],"í":[{"r":[{},[0,4]]},[0,3]]},[2,2]],"ě":[{"c":[{"m":[{},[0,0,4]]}],"t":[{"a":[{},[0,0,3,4]]}]}],"í":[{"c":[{"e":[{},[0,0,0,0,3]]}],"h":[{"a":[{"t":[{},[0,0,4]]}]}],"n":[{},[3]]}],"ň":[{},[2]],"ř":[{"í":[{"n":[{},[0,3]]},[2]]}],"š":[{"e":[{"s":[{},[0,0,0,3]]}],"t":[{"í":[{".":[{},[0,3]]}]}]},[0,2,2]],"ý":[{"s":[{},[3]],"t":[{},[0,0,3]],"z":[{},[3,0,3]]}],"ž":[{},[0,2,2]]},[1]],"w":[{"a":[{"f":[{"d":[{},[0,0,4]]}],"r":[{"e":[{},[0,0,4]]},[3]]}],"e":[{},[0,0,2]]}],"x":[{".":[{},[2]],"a":[{"n":[{"d":[{},[0,0,0,0,4]]}]}],"f":[{},[2]],"i":[{"s":[{"k":[{},[0,0,0,0,4]]}]}],"n":[{},[2]],"o":[{"v":[{},[3]]}],"t":[{"r":[{"a":[{},[0,0,4]]}]},[0,1]],"y":[{"s":[{"m":[{},[0,0,4]]}]}]}],"y":[{"a":[{},[0,2]],"b":[{"l":[{},[0,2]],"r":[{"i":[{},[0,0,3]]}]}],"c":[{"h":[{"r":[{},[0,4]]},[0,2]]}],"d":[{"l":[{"á":[{},[0,0,4]]},[0,2,1]],"r":[{},[0,2]],"y":[{".":[{},[0,0,4]]}]}],"e":[{},[0,2]],"g":[{"r":[{},[0,2]]}],"h":[{"n":[{"e":[{},[0,0,4]]},[0,3]]}],"j":[{"m":[{"a":[{},[0,0,4]],"e":[{},[0,0,4]]}]}],"k":[{"l":[{"a":[{},[0,0,3]],"o":[{"p":[{},[0,3]]}],"y":[{},[0,0,4]]},[0,2]]}],"m":[{"a":[{"n":[{"é":[{},[0,0,0,0,0,4]]}]}],"k":[{"l":[{},[0,0,4]]}]}],"n":[{"a":[{"s":[{},[0,0,0,4]]}],"i":[{},[0,3]]}],"p":[{"e":[{"r":[{},[0,0,0,4]]}],"s":[{"i":[{},[0,0,4]]}],"t":[{"á":[{},[0,0,4]]}],"ř":[{},[0,2]]}],"r":[{"v":[{},[0,0,2]]}],"s":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"l":[{"u":[{},[0,0,3]]}],"m":[{},[0,3]],"o":[{},[0,3]],"p":[{},[0,3]],"t":[{"e":[{},[0,0,3]],"r":[{},[0,0,0,4]]},[0,0,2]],"u":[{},[0,3]],"v":[{},[0,3]],"y":[{},[0,3]],"á":[{},[0,3]],"é":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"t":[{"m":[{"e":[{},[0,0,4]]}]}],"u":[{"ž":[{},[0,0,3]]}],"v":[{"s":[{},[0,3]],"ě":[{"t":[{},[0,0,0,4]]}]}],"z":[{"b":[{},[0,3]],"d":[{},[0,3]],"k":[{},[0,3]],"n":[{"ě":[{},[0,0,4]],"í":[{},[0,0,4]]},[0,3]],"p":[{"o":[{},[0,0,4]]},[0,3]]}],"č":[{"k":[{},[0,0,2]]}],"ň":[{},[0,2]],"ř":[{"b":[{},[0,0,3]],"k":[{"n":[{},[0,0,0,4]]}],"č":[{"e":[{},[0,0,4]]}],"í":[{},[0,3]]}],"š":[{"e":[{},[0,3]],"i":[{},[0,3]],"k":[{},[0,3]],"l":[{},[0,0,1]],"o":[{},[0,3]],"p":[{},[0,3]],"u":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"ž":[{"d":[{},[0,3]]},[0,0,2]]},[0,1]],"z":[{".":[{},[2]],"a":[{"b":[{"l":[{},[0,0,0,2]],"s":[{},[0,0,4]]}],"d":[{"k":[{},[0,0,4]],"l":[{},[0,0,3]],"n":[{},[0,0,4]]}],"h":[{},[0,0,3]],"i":[{},[0,0,3]],"j":[{"k":[{},[0,0,4]]},[0,0,3]],"k":[{"t":[{},[0,0,4]]},[0,0,3]],"l":[{"k":[{},[0,0,0,4]]}],"m":[{"n":[{},[0,0,0,4]]}],"p":[{},[0,0,3,2]],"s":[{},[0,0,3,2]],"t":[{"l":[{},[0,0,3]],"r":[{},[0,0,0,4]]},[0,0,0,2]],"u":[{"t":[{},[0,0,4]]}],"z":[{"n":[{},[0,0,0,4]],"š":[{},[0,0,4]]},[0,0,3]],"č":[{".":[{},[0,0,4]]}],"š":[{"k":[{},[0,0,0,4]],"s":[{},[0,0,4]]},[0,0,3]]}],"b":[{"a":[{"n":[{},[0,0,0,0,4]]}],"y":[{"s":[{},[0,0,0,0,4]]},[0,2]]},[2]],"c":[{},[2,1]],"d":[{"i":[{},[0,3]],"n":[{"ě":[{"n":[{"í":[{},[0,0,0,0,4]]}]}]}],"o":[{"b":[{"a":[{},[0,4]],"n":[{"ý":[{},[0,4]]}]}]}],"r":[{"e":[{},[0,0,4]]}],"v":[{"í":[{},[0,0,4]]}]},[2,2]],"e":[{"h":[{},[0,0,3]],"p":[{},[0,0,3,2]],"r":[{"o":[{"t":[{},[4]]}]}],"s":[{"p":[{},[0,0,0,4]]},[0,0,3,2]],"t":[{},[0,0,0,2]],"v":[{"n":[{},[0,0,3]]},[0,0,0,2]],"z":[{".":[{},[0,0,4]]},[0,0,3]]},[0,2]],"f":[{},[2,2]],"h":[{"á":[{},[0,1]]}],"i":[{"n":[{"e":[{},[0,4]]}]}],"j":[{"í":[{},[0,3]]},[0,2]],"k":[{"a":[{".":[{},[0,3]]}],"y":[{},[0,3]],"é":[{},[0,3]],"ů":[{},[0,3]],"ý":[{},[0,3]]},[2,2]],"l":[{".":[{},[3]],"h":[{"o":[{"s":[{},[0,0,0,0,0,4]]}]}],"i":[{"k":[{},[0,0,0,0,3]]}],"y":[{".":[{},[0,3]]}]},[2]],"m":[{"e":[{},[2]],"n":[{},[0,3]],"y":[{},[0,3]],"ě":[{"n":[{},[0,4]]}]},[0,2,2]],"n":[{"a":[{"k":[{},[3]],"l":[{},[0,4]]}],"e":[{".":[{},[0,3]]}],"i":[{"c":[{},[0,3]]}],"o":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,3]],"é":[{},[0,3]],"ě":[{"l":[{},[0,4]]},[0,3]],"í":[{"t":[{},[0,4]],"v":[{},[0,4]]},[0,3]],"ý":[{},[0,3]]},[2,2]],"o":[{"t":[{"r":[{},[0,0,4]]}],"š":[{"k":[{},[0,0,4]]}]}],"p":[{"t":[{},[0,3]],"á":[{"t":[{},[0,4]]}]},[2,2]],"r":[{"a":[{"k":[{},[3]]}]}],"s":[{},[2,1,2]],"t":[{"r":[{"o":[{"s":[{},[0,0,0,0,0,3]]}],"á":[{},[0,4]]}],"ř":[{},[0,3]]},[2]],"u":[{".":[{},[3]],"m":[{"o":[{},[0,0,3]],"ě":[{},[0,0,3]],"í":[{},[0,0,3]]}],"š":[{},[0,0,3]]}],"v":[{"a":[{"d":[{},[0,0,0,4]],"ř":[{},[0,3]]}],"i":[{"k":[{},[0,0,0,0,4]]},[0,3]],"n":[{"ě":[{},[0,0,4]]}],"o":[{"d":[{},[0,3]],"j":[{},[0,3]],"n":[{},[0,4]]}],"r":[{"o":[{},[0,0,4]]}],"á":[{"n":[{},[0,4]]}],"ě":[{"s":[{},[0,4]]}],"í":[{"j":[{},[0,3]]}]},[0,2]],"y":[{".":[{},[3]]}],"z":[{},[2]],"á":[{"h":[{},[0,0,0,2]],"k":[{"l":[{".":[{},[0,0,4]]}]}],"p":[{},[3]],"s":[{},[0,0,3,2]],"z":[{},[0,0,3]],"š":[{},[0,0,0,2]]},[0,0,1]],"č":[{"l":[{},[0,3]]},[2]],"ň":[{},[2]],"ř":[{"e":[{"j":[{},[0,0,0,0,3]],"z":[{},[0,3]],"š":[{},[0,3]]}]},[0,2]],"š":[{"k":[{"a":[{},[0,0,4]]},[0,3]],"t":[{},[0,3]]},[2,0,2]],"ú":[{"č":[{},[0,0,3]],"ž":[{},[0,0,3]]},[2,2,1]],"ů":[{"s":[{},[0,0,3]]}]},[1]],"á":[{"b":[{"l":[{},[0,2]],"r":[{"y":[{},[0,0,4]]}],"ř":[{".":[{},[0,4]]}]},[0,1]],"c":[{"h":[{"o":[{},[0,3]]}],"t":[{"i":[{},[0,0,3,0,3]]}]}],"d":[{"l":[{},[0,2]],"o":[{"s":[{"t":[{"i":[{},[0,0,0,0,4]]}]},[0,0,0,4]]}],"ř":[{},[0,0,1]]},[0,1]],"h":[{"a":[{},[0,1]],"e":[{},[0,3]],"l":[{".":[{},[0,3]]},[0,0,1]],"n":[{},[0,0,3]],"o":[{},[0,1]],"r":[{},[0,1]],"á":[{},[0,1]]}],"j":[{"m":[{"u":[{},[0,4]],"ů":[{},[0,0,4]]}]},[0,1]],"k":[{"l":[{"i":[{},[0,4]]}],"n":[{"i":[{},[0,0,4]]}]}],"l":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"y":[{},[0,1]],"é":[{},[0,3]],"í":[{},[0,1]]}],"m":[{"y":[{},[0,3]],"é":[{},[0,3]],"ě":[{},[0,1]],"í":[{},[0,3]],"ý":[{},[0,3]]}],"n":[{"e":[{"v":[{},[0,0,0,4]]}]}],"r":[{"a":[{},[0,1]],"e":[{},[0,1]],"m":[{},[0,0,2]],"o":[{},[0,1]],"u":[{},[0,1]],"ů":[{},[0,3]]}],"s":[{"c":[{},[0,2]],"k":[{".":[{},[0,0,4]],"l":[{},[0,0,4]],"n":[{},[0,0,4]]},[0,2,3]],"l":[{"a":[{},[0,2]],"y":[{},[0,0,4]]}],"m":[{},[0,2]],"p":[{"o":[{},[0,0,4]]}],"t":[{},[0,2]]},[0,1]],"t":[{"k":[{},[0,0,3]],"r":[{},[0,0,1]],"u":[{},[0,1]],"y":[{},[0,1]],"í":[{},[0,1]],"ý":[{},[0,3]]}],"v":[{"s":[{"i":[{},[0,0,4]],"í":[{},[0,0,4]]}]}],"z":[{"k":[{},[0,0,3]],"n":[{"i":[{"c":[{},[0,0,0,0,4]]},[0,0,3]]}],"v":[{"i":[{},[0,0,4]]}]}],"ň":[{},[0,2]],"ř":[{"k":[{"e":[{},[0,0,4]],"ů":[{},[0,0,4]]}]},[0,1]],"š":[{"e":[{},[0,3]],"í":[{},[0,3]]},[0,2]]}],"č":[{".":[{},[2]],"a":[{"b":[{"r":[{},[0,0,4]]}]},[1]],"b":[{},[2]],"c":[{},[2,1]],"e":[{".":[{},[3]],"c":[{},[0,0,1]],"s":[{"k":[{},[0,0,0,3]]}]},[1]],"i":[{},[1]],"k":[{"a":[{".":[{},[0,3]]}],"o":[{},[0,3]],"u":[{},[0,3]],"y":[{},[0,3]]},[2]],"m":[{},[2,1]],"n":[{"e":[{},[0,2]]},[2]],"o":[{},[1]],"p":[{},[0,2]],"s":[{"k":[{},[0,1]],"l":[{"a":[{},[0,0,4]]}],"s":[{"r":[{},[0,0,4]]}]},[2]],"t":[{"e":[{"n":[{"é":[{".":[{},[0,4]]}],"ý":[{},[0,4]]}]}],"l":[{"a":[{},[0,0,4]]}],"o":[{"v":[{"ý":[{".":[{},[0,4]]}]}]}],"v":[{},[3]],"ě":[{"n":[{},[4]]}],"í":[{},[0,3]]},[2,2]],"u":[{},[1]],"á":[{},[1]],"í":[{"s":[{"l":[{},[0,0,0,3]]}]},[1]],"ů":[{},[1]]}],"ď":[{".":[{},[2]],"a":[{},[1]],"o":[{},[1]],"s":[{"t":[{"e":[{},[0,0,4]]}]}],"t":[{},[2,1]],"u":[{"j":[{},[3]]}]}],"é":[{"d":[{"i":[{},[0,3]],"o":[{},[0,3]]},[0,2]],"f":[{"o":[{},[0,3]],"r":[{},[0,0,1]]},[0,2]],"k":[{"l":[{},[0,2]]}],"l":[{},[0,2]],"m":[{"a":[{},[0,3]],"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"ů":[{},[0,3]]},[0,2]],"r":[{"e":[{".":[{},[4]]}]}],"s":[{},[0,2]],"t":[{"a":[{},[0,3]],"o":[{},[0,3]],"á":[{},[0,3]]},[0,2]],"š":[{},[0,2]],"ž":[{},[0,2]]},[0,1]],"ě":[{"c":[{},[0,1]],"d":[{"r":[{},[0,0,3]]}],"h":[{"a":[{},[0,3]],"e":[{},[0,3]],"l":[{".":[{},[0,3]],"o":[{},[0,0,3]]}],"n":[{},[0,0,3]],"o":[{},[0,1]],"u":[{},[0,3]],"ů":[{},[0,3]]}],"j":[{"a":[{},[0,3]],"e":[{},[0,1]],"o":[{},[0,1]],"ů":[{},[0,3]]}],"k":[{"l":[{"é":[{},[0,4]]}],"t":[{},[0,3,2]]}],"l":[{},[0,1]],"r":[{"a":[{"d":[{},[0,0,0,3]]},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]],"s":[{"t":[{},[0,0,0,4]]},[0,0,3]],"u":[{},[0,1]],"y":[{},[0,1]],"ů":[{},[0,1]]}],"s":[{"k":[{},[0,0,3]],"n":[{},[0,0,3]]}],"t":[{"a":[{"c":[{},[0,0,4]]},[0,0,1,3]],"l":[{},[0,0,1]],"r":[{"a":[{"j":[{},[0,4]]},[0,0,3]]},[0,1]],"v":[{},[0,0,3]],"í":[{},[0,1]],"ř":[{"í":[{},[0,0,3]]}]}],"v":[{"a":[{},[0,3]],"e":[{},[0,3]],"l":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]],"č":[{},[0,0,3]]},[0,2]],"z":[{"e":[{},[0,3]],"i":[{},[0,3]],"n":[{},[0,0,3]],"o":[{},[0,3]],"í":[{},[0,3]]},[0,2]],"ř":[{},[0,1]],"š":[{"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]],"í":[{},[0,3]],"ť":[{"s":[{},[0,0,4]]},[0,0,3]]},[0,2]],"ť":[{"o":[{},[0,3]]},[0,2]],"ž":[{"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"u":[{},[0,3]],"í":[{},[0,3]]},[0,2]]}],"í":[{"b":[{"ř":[{},[0,0,3]]},[0,1]],"c":[{"h":[{"o":[{},[0,3]],"t":[{},[0,0,0,4]]}]}],"d":[{"l":[{},[0,0,1]]}],"h":[{"l":[{},[0,2]],"n":[{},[0,0,3]]},[0,1]],"j":[{"e":[{"d":[{},[0,0,0,0,4]]}],"m":[{"ů":[{},[0,0,4]]}]},[0,1]],"k":[{"r":[{},[0,2]]}],"l":[{},[0,1]],"m":[{"á":[{},[0,1]],"é":[{},[0,3]],"ě":[{},[0,1]]}],"r":[{},[0,1]],"s":[{"a":[{},[0,1]],"k":[{"l":[{},[0,0,4]],"n":[{},[0,0,4]]},[0,2,3]],"l":[{".":[{},[0,0,4]],"e":[{},[0,0,3]],"n":[{},[0,0,4]]}],"á":[{"h":[{},[0,0,0,0,2]]}]}],"t":[{"k":[{},[0,0,3]],"ř":[{"e":[{},[0,3,3]]}]},[0,1]],"z":[{"d":[{"a":[{},[0,0,3]],"e":[{},[0,0,3]]}],"k":[{},[0,0,3]],"n":[{"a":[{},[0,3]],"i":[{},[0,3,3]],"ě":[{"n":[{},[0,3]]}]}]}],"ň":[{},[0,2]],"ř":[{},[0,1]],"š":[{"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"í":[{},[0,3]]},[0,2]]}],"ň":[{".":[{},[2]],"a":[{"d":[{},[0,0,3]]},[2]],"k":[{},[2]],"m":[{},[2]],"o":[{"v":[{},[3]]}],"s":[{},[0,1]],"t":[{},[2,1]]},[1]],"ó":[{"z":[{"a":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]],"y":[{},[0,3]]},[0,2]]},[0,1]],"ř":[{".":[{},[2]],"a":[{"p":[{"l":[{},[0,0,4]]}],"ď":[{"m":[{},[0,0,4]]}]}],"b":[{},[2,2]],"c":[{},[2]],"d":[{},[2]],"e":[{"c":[{"h":[{},[0,0,3]]}],"d":[{"o":[{"b":[{},[0,0,4]]}]}],"h":[{},[0,0,1]],"j":[{"d":[{},[0,0,3]]}],"k":[{"l":[{},[0,0,3]],"v":[{},[0,0,3]],"ř":[{"í":[{},[0,0,4]]}]}],"o":[{"r":[{},[0,0,0,4]]}],"p":[{".":[{},[0,0,4]],"k":[{},[0,0,4]],"č":[{},[0,0,4]]},[0,0,3,2]],"r":[{"v":[{},[0,0,0,4]]}],"s":[{"k":[{"a":[{},[0,0,3]],"o":[{},[0,0,3]]}],"p":[{"o":[{},[0,0,0,3]]},[0,0,2]],"r":[{},[0,0,4]],"t":[{"a":[{},[0,0,3]],"u":[{},[0,0,3]],"á":[{},[0,0,3]],"ř":[{},[0,0,3]]}]},[2]],"t":[{"l":[{},[0,0,3]],"ř":[{},[0,0,0,4]]}],"z":[{"d":[{},[0,0,3]],"k":[{},[0,0,3]],"l":[{},[4]]}],"č":[{"t":[{},[0,0,3]]}]}],"i":[{"a":[{},[0,0,0,3]],"h":[{".":[{},[0,0,4]],"n":[{},[0,0,4]]},[0,0,3]],"j":[{"ď":[{},[0,0,4]]}],"l":[{".":[{},[0,0,4]],"b":[{},[0,0,4]],"n":[{},[0,0,0,2]]}],"n":[{"e":[{},[4]]}],"s":[{},[0,0,0,2]],"t":[{".":[{},[3,0,4]]}],"v":[{".":[{},[0,0,4]],"k":[{},[0,0,4]],"n":[{},[0,0,4]]}],"z":[{},[0,0,3]],"č":[{"t":[{},[0,0,0,4]]}],"ř":[{},[0,0,3]],"š":[{".":[{},[0,0,4]]}]},[0,0,1]],"k":[{"l":[{"a":[{},[0,0,4]],"i":[{},[0,0,4]],"y":[{},[0,0,4]]},[0,2]],"n":[{"o":[{},[0,0,4]]}]},[2]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2]],"o":[{"u":[{},[2]]},[1]],"p":[{},[2,2]],"s":[{"t":[{"o":[{},[0,0,4]]}]},[2,1]],"t":[{},[2,1]],"v":[{},[0,2]],"z":[{},[2]],"á":[{"p":[{"l":[{},[0,0,4]]}],"s":[{"l":[{},[0,0,2]]}]}],"č":[{},[2,1]],"í":[{"d":[{},[2]],"k":[{"ř":[{},[0,0,4]]}],"s":[{},[0,0,1]]}],"š":[{"t":[{"i":[{},[0,0,4]]},[0,3]]},[2]]}],"š":[{".":[{},[2]],"a":[{"b":[{},[0,0,0,3]],"v":[{"l":[{},[0,0,4]]}]}],"c":[{},[2,1]],"e":[{"j":[{"d":[{},[0,0,0,4]]}],"p":[{"t":[{},[0,0,0,3]]}]}],"i":[{"m":[{"r":[{},[0,0,4]]}]}],"k":[{"a":[{},[0,3]],"e":[{},[0,3]],"l":[{"i":[{},[0,3,3]]}],"o":[{"u":[{},[4,3]],"v":[{},[4]]}],"r":[{"o":[{},[0,0,4]]},[3]],"u":[{".":[{},[0,3]]}],"y":[{},[0,3]]},[2,2]],"l":[{"a":[{},[0,2]],"i":[{"v":[{},[0,3]]},[0,2]],"o":[{},[0,2]],"á":[{},[0,0,0,2]],"é":[{},[0,2]],"ý":[{},[0,2]]},[2]],"m":[{"i":[{"d":[{},[0,0,0,4]]}]},[2,1]],"n":[{},[2]],"p":[{},[0,2]],"s":[{},[2,1]],"t":[{"i":[{"p":[{},[0,4]]}],"k":[{"a":[{},[0,0,4]],"l":[{},[0,0,4]]}],"ě":[{"k":[{},[0,4]],"s":[{},[0,2]],"v":[{},[0,4]]}],"í":[{"p":[{},[0,4]]}]},[2]],"v":[{},[0,2]],"í":[{"d":[{},[0,0,3]]}],"ň":[{},[0,2]],"š":[{"í":[{},[0,3]]}],"ť":[{"o":[{},[0,3]],"u":[{},[0,3]],"á":[{},[0,3]]},[2,2]]},[1]],"ť":[{".":[{},[2]],"a":[{"l":[{},[3]]}],"k":[{},[2]],"m":[{},[2]],"t":[{},[2]],"á":[{"č":[{"k":[{},[0,0,0,4]]}]}]},[1]],"ú":[{"c":[{},[0,2,2]],"d":[{},[0,2]],"j":[{"m":[{"a":[{},[0,0,4]]}]}],"k":[{},[0,2]],"l":[{},[0,2]],"n":[{},[0,2]],"p":[{},[0,2]],"t":[{"k":[{"o":[{},[0,0,4]]}]},[0,2]],"v":[{},[0,2]],"z":[{"k":[{},[0,0,3]]},[0,2]],"č":[{"e":[{},[3]]},[0,2]],"ř":[{"e":[{"z":[{},[0,0,0,4]]}]}],"š":[{"t":[{"i":[{},[0,0,4]]}]}],"ž":[{},[0,2]]},[1]],"ů":[{"b":[{},[0,1]],"c":[{},[0,1]],"h":[{"l":[{},[0,1]]}],"j":[{"d":[{},[0,3]],"m":[{"o":[{"v":[{"ý":[{},[0,4]]}]}]}]}],"l":[{"e":[{},[0,1]]}],"m":[{"y":[{},[0,1]],"ě":[{},[0,1]]}],"r":[{"a":[{},[0,1]],"v":[{"a":[{},[0,0,4]],"y":[{},[0,0,4]]}]}],"s":[{"t":[{"e":[{},[0,0,3]],"á":[{"n":[{},[0,0,3]]}]},[0,2]]},[0,1,2]],"t":[{"k":[{"l":[{},[0,3]]}]},[0,0,2]],"v":[{"a":[{},[0,3]],"o":[{},[0,3]],"ě":[{},[0,3]]},[0,2]],"z":[{"o":[{},[0,3]]},[0,2]],"ž":[{"e":[{},[0,3]],"i":[{},[0,3]],"o":[{},[0,3]]},[0,2]]}],"ý":[{"b":[{},[0,1]],"c":[{"h":[{"o":[{},[0,3]]}]}],"d":[{"l":[{"a":[{},[0,0,4]]}]},[0,1]],"h":[{},[0,1]],"j":[{},[0,1]],"l":[{},[0,1]],"m":[{"l":[{},[0,1]],"ě":[{},[0,1]]}],"n":[{"o":[{},[0,3]]},[0,2]],"p":[{"o":[{"č":[{},[0,0,0,3,4]]}]}],"r":[{},[0,1]],"s":[{"k":[{},[0,2]]},[0,1,2]],"t":[{"k":[{"u":[{},[0,0,4]],"y":[{},[0,0,4]]}]},[0,1]],"u":[{},[0,1]],"v":[{"l":[{"i":[{},[0,4]]}]}],"z":[{"k":[{},[0,3]],"n":[{},[0,3]],"v":[{"u":[{},[0,4]]}]}],"č":[{"n":[{"ě":[{},[0,0,4]]}]}],"ř":[{},[0,1]],"š":[{"l":[{},[0,0,3]]}]}],"ž":[{".":[{},[2]],"a":[{"d":[{},[0,0,3]],"t":[{"v":[{},[0,0,4]]}],"č":[{},[3]]}],"b":[{},[2,1]],"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"b":[{},[0,0,2,3]],"h":[{"n":[{},[0,0,0,3]]}],"m":[{"l":[{},[0,0,4]]}],"z":[{"g":[{},[0,0,4]]}]}],"i":[{"d":[{"l":[{},[0,0,4]]}],"j":[{"m":[{},[0,0,4]]}],"l":[{},[3]],"v":[{"l":[{},[0,0,2]]}]}],"k":[{"n":[{"i":[{},[0,0,4]]}]},[2]],"l":[{"i":[{"c":[{},[0,4]]}],"o":[{},[3]]},[2]],"m":[{},[2,1]],"n":[{},[2]],"o":[{"n":[{},[0,0,0,2]]}],"s":[{},[2,1,2]],"t":[{},[2,1]],"v":[{},[0,2]],"á":[{"b":[{"r":[{},[0,0,4]]}],"n":[{"r":[{},[0,0,4]]}]}],"ď":[{},[2]],"í":[{"z":[{"n":[{},[0,0,4]]}]}],"ň":[{},[2]],"š":[{"t":[{"i":[{},[0,0,4]],"ě":[{},[0,0,4]]}]},[2]]},[1]]}';
  var hyphenation = [
    "koe-fi-ci-ent",
    "koe-fi-ci-en-ty",
    "pro-jek-ční",
    "úhlo-příč-ka",
    "úhlo-příč-ky",
    ""
  ];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
