"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    findUserById: function() {
        return findUserById;
    },
    getRandomBase64String: function() {
        return getRandomBase64String;
    },
    getRandomU32: function() {
        return getRandomU32;
    },
    getToken: function() {
        return getToken;
    },
    isInternalClient: function() {
        return isInternalClient;
    },
    stripUser: function() {
        return stripUser;
    },
    verifyToken: function() {
        return verifyToken;
    }
});
const _jsonwebtoken = require("jsonwebtoken");
const _crypto = require("crypto");
const _util = require("util");
const _constants = require("@tamanu/constants");
const sign = (0, _util.promisify)(_jsonwebtoken.sign);
const verify = (0, _util.promisify)(_jsonwebtoken.verify);
const MAX_U32_VALUE = 2 ** 32 - 1;
const stripUser = (user)=>{
    const userData = {
        ...user
    };
    delete userData.password;
    return userData;
};
const getToken = async (data, secret, options)=>sign(data, secret, options);
const getRandomBase64String = async (length, encoding = 'base64')=>{
    return new Promise((resolve, reject)=>{
        (0, _crypto.randomBytes)(length, (err, buf)=>{
            if (err) reject(err);
            resolve(buf.toString(encoding));
        });
    });
};
const getRandomU32 = ()=>{
    return (0, _crypto.randomInt)(0, MAX_U32_VALUE);
};
const verifyToken = async (token, secret, options)=>verify(token, secret, options);
const findUserById = async (models, id)=>{
    const user = await models.User.findByPk(id);
    if (!user) {
        return null;
    }
    return user.get({
        plain: true
    });
};
const isInternalClient = (client)=>Object.values(_constants.SERVER_TYPES).includes(client);

//# sourceMappingURL=utils.js.map