"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createApp", {
    enumerable: true,
    get: function() {
        return createApp;
    }
});
const _createApi = require("./createApi");
const _createWebsocket = require("./createWebsocket");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function createApp(ctx) {
    const api = await (0, _createApi.createApi)(ctx);
    if (_config.default['socket.io'].enabled) {
        await (0, _createWebsocket.createWebsocket)(api.httpServer, ctx);
    }
    return {
        express: api.express,
        server: api.httpServer
    };
}

//# sourceMappingURL=createApp.js.map