"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "publicRoutes", {
    enumerable: true,
    get: function() {
        return publicRoutes;
    }
});
const _express = require("express");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _userMiddleware = require("../../auth/userMiddleware");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const publicRoutes = (0, _express.Router)();
// handles its own authentication using a separate secret + token issuance workflow, see default.json5
publicRoutes.use((0, _userMiddleware.userMiddleware)({
    secret: _config.default.integrations.omniLab.secret
}));
publicRoutes.get('/', (req, res)=>{
    res.status(200).send({
        implemented: false
    });
});

//# sourceMappingURL=index.js.map