"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getLocalisation", {
    enumerable: true,
    get: function() {
        return getLocalisation;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _lodash = require("lodash");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const fieldSchema = _yup.object({
    shortLabel: _yup.string().when('hidden', {
        is: false,
        then: _yup.string().required()
    }),
    longLabel: _yup.string().when('hidden', {
        is: false,
        then: _yup.string().required()
    }),
    hidden: _yup.boolean().required(),
    required: _yup.boolean(),
    defaultValue: _yup.mixed(),
    requiredPatientData: _yup.boolean(),
    pattern: _yup.string()
}).default({}) // necessary to stop yup throwing hard-to-debug errors
.required().noUnknown();
const unhideableFieldSchema = _yup.object({
    shortLabel: _yup.string().required(),
    longLabel: _yup.string().required(),
    required: _yup.boolean(),
    defaultValue: _yup.mixed(),
    requiredPatientData: _yup.boolean(),
    pattern: _yup.string()
}).required().noUnknown();
const mobilePatientModuleSchema = _yup.object({
    sortPriority: _yup.number().required(),
    hidden: _yup.boolean()
}).required().noUnknown();
const patientTabSchema = _yup.object({
    sortPriority: _yup.number().required(),
    hidden: _yup.boolean()
}).required().noUnknown();
const unhideablePatientTabSchema = _yup.object({
    sortPriority: _yup.number().required(),
    hidden: _yup.boolean().oneOf([
        false
    ], 'unhideable tabs must not be hidden').required()
}).required();
const UNHIDEABLE_FIELDS = [
    'markedForSync',
    'displayId',
    'firstName',
    'lastName',
    'dateOfBirth',
    'dateOfDeath',
    'age',
    'ageRange',
    'dateOfBirthFrom',
    'dateOfBirthTo',
    'dateOfBirthExact',
    'emergencyContactName',
    'emergencyContactNumber',
    'locationId',
    'locationGroupId',
    'clinician',
    'diagnosis',
    'userDisplayId',
    'date',
    'registeredBy',
    'status',
    'conditions',
    'programRegistry',
    'circumstanceIds',
    'reminderContactName',
    'reminderContactRelationship',
    'weightUnit'
];
const HIDEABLE_FIELDS = [
    'countryName',
    'culturalName',
    'sex',
    'email',
    'villageName',
    'villageId',
    'bloodType',
    'title',
    'placeOfBirth',
    'countryOfBirthId',
    'maritalStatus',
    'primaryContactNumber',
    'secondaryContactNumber',
    'socialMedia',
    'settlementId',
    'streetVillage',
    'cityTown',
    'subdivisionId',
    'divisionId',
    'countryId',
    'medicalAreaId',
    'nursingZoneId',
    'nationalityId',
    'ethnicityId',
    'occupationId',
    'educationalLevel',
    'middleName',
    'birthCertificate',
    'insurerId',
    'insurerPolicyNumber',
    'drivingLicense',
    'passport',
    'religionId',
    'patientBillingTypeId',
    'motherId',
    'fatherId',
    'birthWeight',
    'birthLength',
    'birthDeliveryType',
    'gestationalAgeEstimate',
    'apgarScoreOneMinute',
    'apgarScoreFiveMinutes',
    'apgarScoreTenMinutes',
    'timeOfBirth',
    'attendantAtBirth',
    'nameOfAttendantAtBirth',
    'birthFacilityId',
    'birthType',
    'registeredBirthPlace',
    'referralSourceId',
    'arrivalModeId',
    'prescriber',
    'prescriberId',
    'facility',
    'dischargeDisposition',
    'notGivenReasonId',
    'healthCenterId'
];
const MOBILE_PATIENT_MODULES = [
    'diagnosisAndTreatment',
    'vitals',
    'programs',
    'referral',
    'vaccine',
    'tests'
];
const UNHIDEABLE_PATIENT_TABS = [
    'history',
    'details'
];
const HIDEABLE_PATIENT_TABS = [
    'results',
    'referrals',
    'programs',
    'documents',
    'vaccines',
    'medication',
    'invoices'
];
const ageDurationSchema = _yup.object({
    years: _yup.number(),
    months: _yup.number(),
    days: _yup.number()
}).noUnknown();
const templatesSchema = _yup.object({
    plannedMoveTimeoutHours: _yup.number().required(),
    letterhead: _yup.object({
        title: _yup.string(),
        subTitle: _yup.string()
    }).default({}).required().noUnknown(),
    signerRenewalEmail: _yup.object().shape({
        subject: _yup.string().trim().min(1).required(),
        body: _yup.string().trim().min(1).required()
    }).required().noUnknown(),
    vaccineCertificateEmail: _yup.object().shape({
        subject: _yup.string().trim().min(1).required(),
        body: _yup.string().trim().min(1).required()
    }).required().noUnknown(),
    covidVaccineCertificateEmail: _yup.object().shape({
        subject: _yup.string().trim().min(1).required(),
        body: _yup.string().trim().min(1).required()
    }).required().noUnknown(),
    covidTestCertificateEmail: _yup.object().shape({
        subject: _yup.string().trim().min(1).required(),
        body: _yup.string().trim().min(1).required()
    }).required().noUnknown(),
    covidClearanceCertificateEmail: _yup.object().shape({
        subject: _yup.string().trim().min(1).required(),
        body: _yup.string().trim().min(1).required()
    }).required().noUnknown(),
    vaccineCertificate: _yup.object({
        emailAddress: _yup.string().trim(),
        contactNumber: _yup.string().trim(),
        healthFacility: _yup.string().trim().min(1).required()
    }).required().noUnknown(),
    covidTestCertificate: _yup.object({
        laboratoryName: _yup.string().trim().required(),
        clearanceCertRemark: _yup.string().trim().required()
    }).required().noUnknown()
}).required().noUnknown();
const fieldsSchema = _yup.object({
    ...UNHIDEABLE_FIELDS.reduce((fields, field)=>({
            ...fields,
            [field]: unhideableFieldSchema
        }), {}),
    ...HIDEABLE_FIELDS.reduce((fields, field)=>({
            ...fields,
            [field]: fieldSchema
        }), {})
}).required().noUnknown();
const mobilePatientModulesSchema = _yup.object({
    programRegistries: _yup.object({
        hidden: _yup.boolean()
    }),
    ...MOBILE_PATIENT_MODULES.reduce((modules, module)=>({
            ...modules,
            [module]: mobilePatientModuleSchema
        }), {})
});
const patientTabsSchema = _yup.object({
    ...UNHIDEABLE_PATIENT_TABS.reduce((tabs, tab)=>({
            ...tabs,
            [tab]: unhideablePatientTabSchema
        }), {}),
    ...HIDEABLE_PATIENT_TABS.reduce((tabs, tab)=>({
            ...tabs,
            [tab]: patientTabSchema
        }), {})
});
const SIDEBAR_ITEMS = {
    patients: [
        'patientsAll',
        'patientsInpatients',
        'patientsEmergency',
        'patientsOutpatients'
    ],
    scheduling: [
        'schedulingAppointments',
        'schedulingCalendar',
        'schedulingNew'
    ],
    medication: [
        'medicationAll'
    ],
    imaging: [
        'imagingActive',
        'imagingCompleted'
    ],
    labs: [
        'labsAll',
        'labsPublished'
    ],
    immunisations: [
        'immunisationsAll'
    ],
    programRegistry: [],
    facilityAdmin: [
        'reports',
        'bedManagement'
    ]
};
const sidebarItemSchema = _yup.object({
    sortPriority: _yup.number().required(),
    hidden: _yup.boolean()
}).required().noUnknown();
// patients and patientsAll are intentionally not configurable
const sidebarSchema = _yup.object((0, _lodash.mapValues)(SIDEBAR_ITEMS, (children, topItem)=>{
    const childSchema = _yup.object(children.reduce((obj, childItem)=>childItem === 'patientsAll' ? obj : {
            ...obj,
            [childItem]: sidebarItemSchema
        }, {})).required().noUnknown();
    return topItem === 'patients' ? childSchema : sidebarItemSchema.concat(childSchema);
})).required().noUnknown();
const imagingTypeSchema = _yup.object({
    label: _yup.string().required()
}).noUnknown();
const imagingTypesSchema = _yup.object({
    ...Object.values(_constants.IMAGING_TYPES).reduce((fields, field)=>({
            ...fields,
            [field]: imagingTypeSchema
        }), {})
}).required();
const layoutsSchema = _yup.object({
    patientDetails: _yup.string().required().oneOf(Object.values(_constants.PATIENT_DETAIL_LAYOUTS)),
    mobilePatientModules: mobilePatientModulesSchema,
    patientTabs: patientTabsSchema,
    sidebar: sidebarSchema
});
const validCssAbsoluteLength = _yup.string().required()// eslint-disable-next-line no-template-curly-in-string
.test('is-valid-css-absolute-length', '${path} is not a valid CSS absolute length', (value)=>{
    if (value === '0') {
        return true;
    }
    // Make sure unit is a valid CSS absolute unit
    const unitCharLength = value.slice(-1) === 'Q' ? 1 : 2;
    const unit = value.slice(-unitCharLength);
    if ([
        'cm',
        'mm',
        'Q',
        'in',
        'pc',
        'pt',
        'px'
    ].includes(unit) === false) {
        return false;
    }
    // Make sure the rest of the string is actually a valid CSS number
    // only integers or floats with no extra characters.
    const numberString = value.slice(0, -unitCharLength);
    return /(^\d+$)|(^\d+\.\d+$)/.test(numberString);
});
const printMeasuresSchema = _yup.object({
    labRequestPrintLabel: _yup.object({
        width: _yup.number().required().positive()
    }),
    stickerLabelPage: _yup.object({
        pageWidth: validCssAbsoluteLength,
        pageHeight: validCssAbsoluteLength,
        pageMarginTop: validCssAbsoluteLength,
        pageMarginLeft: validCssAbsoluteLength,
        columnTotal: _yup.number().required(),
        columnWidth: validCssAbsoluteLength,
        columnGap: validCssAbsoluteLength,
        rowTotal: _yup.number().required(),
        rowHeight: validCssAbsoluteLength,
        rowGap: validCssAbsoluteLength
    }),
    idCardPage: _yup.object({
        cardMarginTop: validCssAbsoluteLength,
        cardMarginLeft: validCssAbsoluteLength
    })
}).required().noUnknown();
const rootLocalisationSchema = _yup.object({
    units: _yup.object({
        temperature: _yup.string().oneOf([
            'celsius',
            'fahrenheit'
        ])
    }),
    country: {
        name: _yup.string().min(1).required(),
        'alpha-2': _yup.string().uppercase().length(2).required(),
        'alpha-3': _yup.string().uppercase().length(3).required()
    },
    fields: fieldsSchema,
    templates: templatesSchema,
    timeZone: _yup.string().nullable(),
    imagingTypes: imagingTypesSchema,
    imagingPriorities: _yup.array(_yup.object({
        value: _yup.string().required(),
        label: _yup.string().required()
    })),
    imagingCancellationReasons: _yup.array(_yup.object({
        value: _yup.string().required().max(31),
        label: _yup.string().required(),
        hidden: _yup.boolean()
    })).test({
        name: 'imagingCancellationReasons',
        test (conf, ctx) {
            const values = conf.map((x)=>x.value);
            if (!values.includes('duplicate')) {
                return ctx.createError({
                    message: 'imagingCancellationReasons must include an option with value = duplicate'
                });
            }
            if (!values.includes('entered-in-error')) {
                return ctx.createError({
                    message: 'imagingCancellationReasons must include an option with value = entered-in-error'
                });
            }
            return true;
        }
    }),
    labsCancellationReasons: _yup.array(_yup.object({
        value: _yup.string().required().max(31),
        label: _yup.string().required()
    })).test({
        name: 'labsCancellationReasons',
        test (conf, ctx) {
            const values = conf.map((x)=>x.value);
            if (!values.includes('duplicate')) {
                return ctx.createError({
                    message: 'labsCancellationReasons must include an option with value = duplicate'
                });
            }
            if (!values.includes('entered-in-error')) {
                return ctx.createError({
                    message: 'labsCancellationReasons must include an option with value = entered-in-error'
                });
            }
            return true;
        }
    }),
    triageCategories: _yup.array(_yup.object({
        level: _yup.number().required(),
        label: _yup.string().required(),
        color: _yup.string().required()
    })).min(3).max(5),
    layouts: layoutsSchema,
    previewUvciFormat: _yup.string().required().oneOf([
        'tamanu',
        'eudcc',
        'icao'
    ]),
    features: _yup.object({
        enableVaccineConsent: _yup.boolean().required(),
        filterDischargeDispositions: _yup.boolean().required(),
        editPatientDetailsOnMobile: _yup.boolean().required(),
        quickPatientGenerator: _yup.boolean().required(),
        enableInvoicing: _yup.boolean().required(),
        hideOtherSex: _yup.boolean().required(),
        registerNewPatient: _yup.boolean().required(),
        enablePatientDeaths: _yup.boolean().required(),
        mergePopulatedPADRecords: _yup.boolean().required(),
        enableNoteBackdating: _yup.boolean().required(),
        enableCovidClearanceCertificate: _yup.boolean().required(),
        editPatientDisplayId: _yup.boolean().required(),
        enablePatientInsurer: _yup.boolean().required(),
        patientPlannedMove: _yup.boolean().required(),
        idleTimeout: _yup.object().shape({
            enabled: _yup.boolean().required(),
            timeoutDuration: _yup.number().required(),
            warningPromptDuration: _yup.number().required(),
            refreshInterval: _yup.number().required()
        }).required(),
        fhirNewZealandEthnicity: _yup.boolean().required(),
        onlyAllowLabPanels: _yup.boolean().required(),
        displayProcedureCodesInDischargeSummary: _yup.boolean().required(),
        displayIcd10CodesInDischargeSummary: _yup.boolean().required(),
        tableAutoRefresh: _yup.object().shape({
            enabled: _yup.boolean().required(),
            interval: _yup.number().required()
        }),
        mandatoryVitalEditReason: _yup.boolean().required(),
        enableVitalEdit: _yup.boolean().required()
    }).required().noUnknown(),
    printMeasures: printMeasuresSchema,
    disabledReports: _yup.array(_yup.string().required()).defined(),
    supportDeskUrl: _yup.string().required(),
    ageDisplayFormat: _yup.array(_yup.object({
        as: _yup.string().required(),
        range: _yup.object({
            min: _yup.object({
                duration: ageDurationSchema,
                exclusive: _yup.boolean()
            }),
            max: _yup.object({
                duration: ageDurationSchema,
                exclusive: _yup.boolean()
            })
        }).required().test({
            name: 'ageDisplayFormat',
            test (range, ctx) {
                if (!range.min && !range.max) {
                    return ctx.createError({
                        message: `range in ageDisplayFormat must include either min or max, or both, got ${JSON.stringify(range)}`
                    });
                }
                return true;
            }
        })
    })).required(),
    vitalEditReasons: _yup.array(_yup.object({
        value: _yup.string().required(),
        label: _yup.string().required()
    }))
}).required().noUnknown();
// TODO: once localisation is persisted in the db, dynamically reload this
const unvalidatedLocalisation = (0, _lodash.defaultsDeep)(_config.default.localisation.data);
const localisationPromise = rootLocalisationSchema.validate(unvalidatedLocalisation, {
    strict: true,
    abortEarly: false
}).then((l)=>{
    _logging.log.info('Localisation validated successfully.');
    return l;
}).catch((e)=>{
    const errors = e.inner.map((inner)=>`\n  - ${inner.message}`);
    _logging.log.error(`Error(s) validating localisation (check localisation.data in your config):${errors}`);
    if (!_config.default.localisation.allowInvalid) {
        process.exit(1);
    }
});
const getLocalisation = async ()=>{
    if (_config.default.localisation.allowInvalid) {
        return unvalidatedLocalisation;
    }
    const localisation = await localisationPromise;
    return localisation;
};

//# sourceMappingURL=localisation.js.map