"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    findOrCreateDefinition: function() {
        return findOrCreateDefinition;
    },
    getLatestVersion: function() {
        return getLatestVersion;
    },
    verifyQuery: function() {
        return verifyQuery;
    }
});
const _logging = require("@tamanu/shared/services/logging");
const _sequelize = require("sequelize");
const _getReportQueryReplacements = require("@tamanu/shared/utils/reports/getReportQueryReplacements");
async function findOrCreateDefinition(name, store) {
    const { ReportDefinition } = store.models;
    const [definition, created] = await ReportDefinition.findOrCreate({
        where: {
            name
        }
    });
    if (created) {
        _logging.log.info(`Created new report definition ${definition.name}`);
    }
    return definition;
}
function getLatestVersion(versions, status) {
    return versions.sort((a, b)=>b.versionNumber - a.versionNumber).find((v)=>!status || v.status === status);
}
async function verifyQuery(query, paramDefinitions = [], store, verbose) {
    try {
        const replacements = await (0, _getReportQueryReplacements.getReportQueryReplacements)(store, paramDefinitions);
        // use EXPLAIN instead of PREPARE because we don't want to stuff around deallocating the statement
        const results = await store.sequelize.query(`EXPLAIN ${query}`, {
            type: _sequelize.QueryTypes.SELECT,
            replacements
        });
        if (verbose) {
            const formattedResults = results.reduce((a1, x)=>`${a1}\n${Object.entries(x).reduce((a2, [k, v])=>`${a2}\x1b[1m${k}:\x1b[0m ${v}`, '')}`, 'Explain output:');
            _logging.log.info(formattedResults);
        }
    } catch (err) {
        throw new Error(`Invalid query: ${err.message}`);
    }
}

//# sourceMappingURL=utils.js.map