"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceDataICD10ToDiagnosis", {
    enumerable: true,
    get: function() {
        return ReferenceDataICD10ToDiagnosis;
    }
});
const _dataMigrations = require("@tamanu/shared/dataMigrations");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let ReferenceDataICD10ToDiagnosis = class ReferenceDataICD10ToDiagnosis extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return `
      with updated as (
      update reference_data
      set type = 'diagnosis'
      where id in (
          select id
          from reference_data
          where type = 'icd10'
          and id > $fromId
          order by id
          limit $limit
      )
      returning id
      )
      select
        max(id::text) as "maxId",
        count(id) as "count"
      from updated;
    `;
    }
    constructor(...args){
        super(...args);
        _define_property(this, "lastMaxId", '');
    }
};
_define_property(ReferenceDataICD10ToDiagnosis, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(ReferenceDataICD10ToDiagnosis, "defaultDelayMs", 50);

//# sourceMappingURL=ReferenceDataICD10ToDiagnosis.js.map