"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePatientPayment", {
    enumerable: true,
    get: function() {
        return InvoicePatientPayment;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("./buildEncounterLinkedSyncFilter");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let InvoicePatientPayment = class InvoicePatientPayment extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            methodId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            }
        }, {
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            ...options
        });
    }
    /**
   *
   * @param {import('./')} models
   */ static initRelations(models) {
        this.belongsTo(models.InvoicePayment, {
            foreignKey: 'invoicePaymentId',
            as: 'detail'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'methodId',
            as: 'method',
            constraints: false
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoice_payments',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoice_payments',
                'invoices',
                'encounters'
            ])
        };
    }
    /**
   *
   * @param {import('./')} models
   */ static getListReferenceAssociations(models) {
        return [
            {
                model: models.ReferenceData,
                as: 'method'
            }
        ];
    }
};

//# sourceMappingURL=InvoicePatientPayment.js.map