"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientFieldDefinition", {
    enumerable: true,
    get: function() {
        return PatientFieldDefinition;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const FIELD_TYPE_ERR_MSG = `fieldType must be one of ${JSON.stringify(_constants.PATIENT_FIELD_DEFINITION_TYPE_VALUES)}`;
const VISIBILITY_STATUS_ERR_MSG = `state must be one of ${JSON.stringify(_constants.VISIBILITY_STATUSES)}`;
let PatientFieldDefinition = class PatientFieldDefinition extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false
            },
            fieldType: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false,
                validate: {
                    isIn: {
                        args: [
                            _constants.PATIENT_FIELD_DEFINITION_TYPE_VALUES
                        ],
                        msg: FIELD_TYPE_ERR_MSG
                    }
                }
            },
            options: _sequelize.Sequelize.ARRAY(_sequelize.Sequelize.STRING),
            visibilityStatus: {
                type: _sequelize.Sequelize.STRING,
                allowNull: false,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT,
                validate: {
                    isIn: {
                        args: [
                            _constants.VISIBILITY_STATUS_VALUES
                        ],
                        msg: VISIBILITY_STATUS_ERR_MSG
                    }
                }
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.PatientFieldDefinitionCategory, {
            foreignKey: 'categoryId',
            as: 'category'
        });
        this.hasMany(models.PatientFieldValue, {
            foreignKey: 'definitionId',
            as: 'values'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=PatientFieldDefinition.js.map