"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SurveyScreenComponent", {
    enumerable: true,
    get: function() {
        return SurveyScreenComponent;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _parseornull = require("../utils/parse-or-null");
const _logging = require("../services/logging");
const _Model = require("./Model");
let SurveyScreenComponent = class SurveyScreenComponent extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            screenIndex: _sequelize.Sequelize.INTEGER,
            componentIndex: _sequelize.Sequelize.INTEGER,
            text: _sequelize.Sequelize.STRING,
            visibilityCriteria: _sequelize.Sequelize.STRING,
            validationCriteria: _sequelize.Sequelize.TEXT,
            detail: _sequelize.Sequelize.STRING,
            config: _sequelize.Sequelize.STRING,
            options: _sequelize.Sequelize.TEXT,
            calculation: _sequelize.Sequelize.STRING,
            visibilityStatus: _sequelize.Sequelize.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static getListReferenceAssociations(includeAllVitals) {
        return {
            model: this.sequelize.models.ProgramDataElement,
            as: 'dataElement',
            paranoid: !includeAllVitals
        };
    }
    static initRelations(models) {
        this.belongsTo(models.Survey, {
            foreignKey: 'surveyId'
        });
        this.belongsTo(models.ProgramDataElement, {
            foreignKey: 'dataElementId',
            as: 'dataElement'
        });
    }
    static async getComponentsForSurveys(surveyIds, options = {}) {
        const { includeAllVitals } = options;
        const where = {
            surveyId: {
                [_sequelize.Op.in]: surveyIds
            }
        };
        const components = await this.findAll({
            where,
            include: this.getListReferenceAssociations(includeAllVitals),
            order: [
                [
                    'screen_index',
                    'ASC'
                ],
                [
                    'component_index',
                    'ASC'
                ]
            ],
            paranoid: !includeAllVitals
        });
        return components.map((c)=>c.forResponse());
    }
    static getComponentsForSurvey(surveyId, options = {}) {
        return this.getComponentsForSurveys([
            surveyId
        ], options);
    }
    getOptions() {
        try {
            const optionString = this.options || this.dataElement?.defaultOptions || '';
            if (!optionString) {
                return [];
            }
            const optionArray = JSON.parse(optionString);
            return Object.entries(optionArray).map(([label, value])=>({
                    label,
                    value
                }));
        } catch (e) {
            _logging.log.error(e);
            return [];
        }
    }
    forResponse() {
        const { options, ...values } = this.dataValues;
        return {
            ...values,
            options: (0, _parseornull.parseOrNull)(options)
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=SurveyScreenComponent.js.map