"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getPatientAdditionalData", {
    enumerable: true,
    get: function() {
        return getPatientAdditionalData;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _getPatientSurveyResponseAnswer = require("./getPatientSurveyResponseAnswer");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function getPatientAdditionalData(models, patientId, fieldName) {
    const { PatientAdditionalData } = models;
    const patientAdditionalData = await PatientAdditionalData.findOne({
        where: {
            patientId
        },
        include: PatientAdditionalData.getFullReferenceAssociations()
    });
    const value = patientAdditionalData?.dataValues[fieldName];
    if (value) {
        return value;
    }
    const questionId = _config.default?.questionCodeIds[fieldName];
    return (0, _getPatientSurveyResponseAnswer.getPatientSurveyResponseAnswer)(models, patientId, questionId);
}

//# sourceMappingURL=getPatientAdditionalData.js.map