import { Sequelize } from 'sequelize';
import { SYNC_DIRECTIONS, VACCINE_CATEGORIES, VISIBILITY_STATUSES } from '@tamanu/constants';
import { Model } from './Model';

export class ScheduledVaccine extends Model {
  static init({ primaryKey, ...options }) {
    super.init(
      {
        id: primaryKey,
        category: Sequelize.STRING,
        label: Sequelize.STRING,
        doseLabel: Sequelize.STRING,
        weeksFromBirthDue: Sequelize.INTEGER,
        weeksFromLastVaccinationDue: Sequelize.INTEGER,
        index: Sequelize.INTEGER,
        hideFromCertificate: {
          type: Sequelize.BOOLEAN,
          defaultValue: false,
        },
        visibilityStatus: {
          type: Sequelize.TEXT,
          defaultValue: VISIBILITY_STATUSES.CURRENT,
        },
        sortIndex: {
          type: Sequelize.INTEGER,
          defaultValue: 0,
        },
      },
      {
        ...options,
        syncDirection: SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
      },
    );
  }

  static getListReferenceAssociations() {
    return ['vaccine'];
  }

  static async getOtherCategoryScheduledVaccine() {
    // Should only contain 1 scheduled vaccine with Other category per environment
    return this.findOne({ where: { category: VACCINE_CATEGORIES.OTHER } });
  }

  static initRelations(models) {
    // vaccine is of type drug
    this.belongsTo(models.ReferenceData, {
      foreignKey: 'vaccineId',
      as: 'vaccine',
    });
  }

  static buildSyncFilter() {
    return null; // syncs everywhere
  }

  static buildSyncLookupQueryDetails() {
    return null; // syncs everywhere
  }
}
