"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamodbServiceExtension = void 0;
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const api_1 = require("@opentelemetry/api");
const semantic_conventions_1 = require("@opentelemetry/semantic-conventions");
class DynamodbServiceExtension {
    requestPreSpanHook(normalizedRequest) {
        var _a;
        const spanKind = api_1.SpanKind.CLIENT;
        let spanName;
        const isIncoming = false;
        const operation = normalizedRequest.commandName;
        const spanAttributes = {
            [semantic_conventions_1.SemanticAttributes.DB_SYSTEM]: semantic_conventions_1.DbSystemValues.DYNAMODB,
            [semantic_conventions_1.SemanticAttributes.DB_NAME]: (_a = normalizedRequest.commandInput) === null || _a === void 0 ? void 0 : _a.TableName,
            [semantic_conventions_1.SemanticAttributes.DB_OPERATION]: operation,
            [semantic_conventions_1.SemanticAttributes.DB_STATEMENT]: JSON.stringify(normalizedRequest.commandInput),
        };
        if (operation === 'BatchGetItem') {
            spanAttributes[semantic_conventions_1.SemanticAttributes.AWS_DYNAMODB_TABLE_NAMES] = Object.keys(normalizedRequest.commandInput.RequestItems);
        }
        return {
            isIncoming,
            spanAttributes,
            spanKind,
            spanName,
        };
    }
    responseHook(response, span, tracer, config) {
        var _a;
        const operation = response.request.commandName;
        if (operation === 'BatchGetItem') {
            if (Array.isArray((_a = response.data) === null || _a === void 0 ? void 0 : _a.ConsumedCapacity)) {
                span.setAttribute(semantic_conventions_1.SemanticAttributes.AWS_DYNAMODB_CONSUMED_CAPACITY, response.data.ConsumedCapacity.map((x) => JSON.stringify(x)));
            }
        }
    }
}
exports.DynamodbServiceExtension = DynamodbServiceExtension;
//# sourceMappingURL=dynamodb.js.map