(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsBn = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"অ":[{},[0,1]],"আ":[{},[0,1]],"ই":[{},[0,1]],"ঈ":[{},[0,1]],"উ":[{},[0,1]],"ঊ":[{},[0,1]],"ঋ":[{},[0,1]],"ৠ":[{},[0,1]],"ঌ":[{},[0,1]],"ৡ":[{},[0,1]],"এ":[{},[0,1]],"ঐ":[{},[0,1]],"ও":[{},[0,1]],"ঔ":[{},[0,1]],"া":[{},[0,1]],"ি":[{},[0,1]],"ী":[{},[0,1]],"ু":[{},[0,1]],"ূ":[{},[0,1]],"ৃ":[{},[0,1]],"ৄ":[{},[0,1]],"ৢ":[{},[0,1]],"ৣ":[{},[0,1]],"ে":[{},[0,1]],"ৈ":[{},[0,1]],"ো":[{},[0,1]],"ৌ":[{},[0,1]],"়":[{},[2,2]],"ৗ":[{},[0,1]],"ক":[{},[1]],"খ":[{},[1]],"গ":[{},[1]],"ঘ":[{},[1]],"ঙ":[{},[1]],"চ":[{},[1]],"ছ":[{},[1]],"জ":[{},[1]],"ঝ":[{},[1]],"ঞ":[{},[1]],"ট":[{},[1]],"ঠ":[{},[1]],"ড":[{},[1]],"ড়":[{},[1]],"ঢ":[{},[1]],"ঢ়":[{},[1]],"ণ":[{},[1]],"ত":[{},[1]],"থ":[{},[1]],"দ":[{},[1]],"ধ":[{},[1]],"ন":[{},[1]],"প":[{},[1]],"ফ":[{},[1]],"ব":[{},[1]],"ভ":[{},[1]],"ম":[{},[1]],"য":[{},[1]],"য়":[{},[1]],"র":[{},[1]],"ল":[{},[1]],"শ":[{},[1]],"ষ":[{},[1]],"স":[{},[1]],"হ":[{},[1]],"ৎ":[{},[0,1]],"ঃ":[{},[2,1]],"ং":[{},[2,1]],"ঁ":[{},[2,1]],"ঽ":[{},[2,1]],"্":[{},[2,2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
