(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsTa = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"அ":[{},[1,1]],"ஆ":[{},[1,1]],"இ":[{},[1,1]],"ஈ":[{},[1,1]],"உ":[{},[1,1]],"ஊ":[{},[1,1]],"எ":[{},[1,1]],"ஏ":[{},[1,1]],"ஐ":[{},[1,1]],"ஒ":[{},[1,1]],"ஓ":[{},[1,1]],"ஔ":[{},[1,1]],"ா":[{},[0,1]],"ி":[{},[0,1]],"ீ":[{},[0,1]],"ு":[{},[0,1]],"ூ":[{},[0,1]],"ெ":[{},[0,1]],"ே":[{},[0,1]],"ை":[{},[0,1]],"ொ":[{},[0,1]],"ோ":[{},[0,1]],"ௌ":[{},[0,1]],"க":[{"்":[{},[2,0,1]]},[1]],"ங":[{"்":[{},[2,0,1]]},[1]],"ச":[{"்":[{},[2,0,1]]},[1]],"ஜ":[{},[1]],"ஞ":[{"்":[{},[2,0,1]]},[1]],"ட":[{"்":[{},[2,0,1]]},[1]],"ண":[{"்":[{},[2,0,1]]},[1]],"த":[{"்":[{},[2,0,1]]},[1]],"ந":[{"்":[{},[2,0,1]]},[1]],"ப":[{"்":[{},[2,0,1]]},[1]],"ம":[{"்":[{},[2,0,1]]},[1]],"ய":[{"்":[{},[2,0,1]]},[1]],"ர":[{"்":[{},[2,0,1]]},[1]],"ற":[{"்":[{},[2,0,1]]},[1]],"ல":[{"்":[{},[2,0,1]]},[1]],"ள":[{"்":[{},[2,0,1]]},[1]],"ழ":[{"்":[{},[2,0,1]]},[1]],"வ":[{"்":[{},[2,0,1]]},[1]],"ஷ":[{"்":[{},[2,0,1]]},[1]],"ஸ":[{"்":[{},[2,0,1]]},[1]],"ஹ":[{"்":[{},[2,0,1]]},[1]],"ன":[{"்":[{},[2,0,1]]}],"ஂ":[{},[2,1]],"ஃ":[{},[2,1]],"ௗ":[{},[2,1]],"்":[{},[2,1]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
