"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "addFacilityMiddleware", {
    enumerable: true,
    get: function() {
        return addFacilityMiddleware;
    }
});
const _bodyparser = /*#__PURE__*/ _interop_require_default(require("body-parser"));
const _compression = /*#__PURE__*/ _interop_require_default(require("compression"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const _serverInfo = require("./serverInfo");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const addFacilityMiddleware = async (express)=>{
    let errorMiddleware = null;
    if (_config.default.errors?.enabled) {
        if (_config.default.errors?.type === 'bugsnag') {
            const Bugsnag = await Promise.resolve().then(()=>/*#__PURE__*/ _interop_require_wildcard(require("@bugsnag/js")));
            const middleware = Bugsnag.getPlugin('express');
            express.use(middleware.requestHandler);
            errorMiddleware = middleware.errorHandler;
        }
    }
    express.use((0, _compression.default)());
    express.use(_bodyparser.default.json({
        limit: '50mb'
    }));
    express.use(_bodyparser.default.urlencoded({
        extended: true
    }));
    express.use((_req, res, next)=>{
        res.setHeader('X-Tamanu-Server', _constants.SERVER_TYPES.FACILITY);
        res.setHeader('X-Version', _serverInfo.version);
        next();
    });
    // trust the x-forwarded-for header from addresses in `config.proxy.trusted`
    express.set('trust proxy', _config.default.proxy.trusted);
    express.use((0, _logging.getLoggingMiddleware)());
    return {
        errorMiddleware
    };
};

//# sourceMappingURL=addFacilityMiddleware.js.map