"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "checkConfig", {
    enumerable: true,
    get: function() {
        return checkConfig;
    }
});
const _logging = require("@tamanu/shared/services/logging");
async function checkConfig(config, context) {
    // check surveys
    const { department, location } = config.survey.defaultCodes;
    const ensureExists = async (modelName, code)=>{
        const found = await context.models[modelName].findOne({
            where: {
                code
            }
        });
        if (!found) {
            _logging.log.error(`Default survey ${modelName} with code ${code} could not be found`);
        }
    };
    await ensureExists('Department', department);
    await ensureExists('Location', location);
}

//# sourceMappingURL=checkConfig.js.map