"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createPatientLetter", {
    enumerable: true,
    get: function() {
        return createPatientLetter;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _fs = /*#__PURE__*/ _interop_require_wildcard(require("fs"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _errors = require("@tamanu/shared/errors");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/shared/utils/dateTime");
const _makePatientLetter = require("../utils/makePatientLetter");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const createPatientLetter = (modelName, idField)=>(0, _expressasynchandler.default)(async (req, res)=>{
        req.checkPermission('create', 'DocumentMetadata');
        const { models, params } = req;
        const { patientLetterData, clinicianId, name } = req.body;
        const documentCreatedAt = (0, _dateTime.getCurrentDateTimeString)();
        // Make sure the specified encounter/patient exists
        const specifiedObject = await models[modelName].findByPk(params.id);
        if (!specifiedObject) {
            throw new _errors.NotFoundError();
        }
        const clinician = await models.User.findByPk(clinicianId);
        if (!clinician) {
            throw new _errors.NotFoundError('Clinician not found');
        }
        // Create attachment
        const { filePath, mimeType } = await (0, _makePatientLetter.makePatientLetter)(req, {
            id: specifiedObject.id,
            clinician,
            documentCreatedAt,
            title: patientLetterData.title,
            body: patientLetterData.body,
            patient: patientLetterData.patient,
            facilityId: _config.default.serverFacilityId
        });
        const { size } = _fs.default.statSync(filePath);
        const fileData = await _fs.promises.readFile(filePath, {
            encoding: 'base64'
        });
        _fs.default.unlink(filePath, ()=>null);
        const { id: attachmentId } = await models.Attachment.create(models.Attachment.sanitizeForDatabase({
            type: mimeType,
            size,
            data: fileData
        }));
        const documentMetadataObject = await models.DocumentMetadata.create({
            name,
            source: _constants.DOCUMENT_SOURCES.PATIENT_LETTER,
            type: mimeType,
            documentOwner: clinician.displayName,
            attachmentId,
            documentCreatedAt,
            documentUploadedAt: documentCreatedAt,
            [idField]: params.id
        });
        res.send(documentMetadataObject);
    });

//# sourceMappingURL=createPatientLetter.js.map