"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getLabRequestList", {
    enumerable: true,
    get: function() {
        return getLabRequestList;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _importable = require("@tamanu/constants/importable");
const _notes = require("@tamanu/constants/notes");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getLabRequestList = (foreignKey = '', options = {})=>(0, _expressasynchandler.default)(async (req, res)=>{
        const { models, query } = req;
        const { includeNotes = false, status } = query;
        const newOptions = {
            ...options
        };
        // allow filter by status for encounter lab requests
        if (status) {
            newOptions.additionalFilters = {
                ...options.additionalFilters,
                status
            };
        }
        const { data: labRequests, count } = await (0, _crudHelpers.getResourceList)(req, 'LabRequest', foreignKey, newOptions);
        /**
     * Have to select associated note pages of lab request separately here.
     * This is because Sequelize has a bug that association scope field is not snake cased when underscored = true,
     * causing any models having Note as associations (ie: Patient, LabRequest,...)
     * not able to include Note as association when querying.
     *
     * eg: LabRequest model has association:
     * this.hasMany(models.Note, {
     *   foreignKey: 'recordId',
     *   as: 'notes',
     *   constraints: false,
     *   scope: {
     *      recordType: this.name,
     *   },
     * });
     *
     * In sequelize raw sql, it selects columns note.recordType instead of note.record_type,
     * which does not exist.
     *
     * More details: https://github.com/sequelize/sequelize-typescript/issues/740
     *  */ if (!includeNotes) {
            res.send({
                count,
                data: labRequests
            });
            return;
        }
        for (const labRequest of labRequests){
            const notes = await models.Note.findAll({
                where: {
                    recordId: labRequest.id,
                    recordType: _notes.NOTE_RECORD_TYPES.LAB_REQUEST,
                    visibilityStatus: _importable.VISIBILITY_STATUSES.CURRENT
                }
            });
            labRequest.notes = notes;
        }
        res.send({
            count,
            data: labRequests
        });
    });

//# sourceMappingURL=getLabRequestList.js.map