"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "apiv1", {
    enumerable: true,
    get: function() {
        return apiv1;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _middleware = require("@tamanu/shared/permissions/middleware");
const _settings = require("@tamanu/settings");
const _auth = require("../../middleware/auth");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _lodash = require("lodash");
const _allergy = require("./allergy");
const _appointments = require("./appointments");
const _asset = require("./asset");
const _attachment = require("./attachment");
const _certificateNotification = require("./certificateNotification");
const _changePassword = require("./changePassword");
const _department = require("./department");
const _diagnosis = require("./diagnosis");
const _encounter = require("./encounter");
const _familyHistory = require("./familyHistory");
const _imaging = require("./imaging");
const _invoice = require("./invoice");
const _labs = require("./labs");
const _labRequestLog = require("./labRequestLog");
const _location = require("./location");
const _locationGroup = require("./locationGroup");
const _medication = require("./medication");
const _note = require("./note");
const _ongoingCondition = require("./ongoingCondition");
const _patient = require("./patient");
const _patientFacility = require("./patientFacility");
const _template = require("./template");
const _procedure = require("./procedure");
const _program = require("./program");
const _programRegistry = require("./programRegistry");
const _referenceData = require("./referenceData");
const _referral = require("./referral");
const _reportRequest = require("./reportRequest");
const _reports = require("./reports");
const _resetPassword = require("./resetPassword");
const _scheduledVaccine = require("./scheduledVaccine");
const _suggestions = require("./suggestions");
const _survey = require("./survey");
const _surveyResponse = require("./surveyResponse");
const _surveyResponseAnswer = require("./surveyResponseAnswer");
const _sync = require("./sync");
const _syncHealth = require("./syncHealth");
const _triage = require("./triage");
const _user = require("./user");
const _vitals = require("./vitals");
const _translation = require("./translation");
const _vaccinationSettings = require("./vaccinationSettings");
const _upcomingVaccinations = require("./upcomingVaccinations");
const _telegramRoutes = require("./telegram/telegramRoutes");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const apiv1 = _express.default.Router();
const patientDataRoutes = _express.default.Router();
const referenceDataRoutes = _express.default.Router();
const syncRoutes = _express.default.Router();
// auth endpoints (added pre auth check)
apiv1.post('/login', _auth.loginHandler);
apiv1.use('/resetPassword', _resetPassword.resetPassword);
apiv1.use('/changePassword', _changePassword.changePassword);
apiv1.get('/public/ping', (0, _expressasynchandler.default)((req, res)=>{
    req.flagPermissionChecked();
    return res.send({
        ok: 'ok'
    });
}));
apiv1.get('/public/translation/languageOptions', async (req, res)=>{
    req.flagPermissionChecked();
    const { TranslatedString } = req.models;
    const response = await TranslatedString.getPossibleLanguages();
    res.send(response);
});
apiv1.get('/public/translation/:language', (0, _expressasynchandler.default)(async (req, res)=>{
    // Everyone can access translations
    req.flagPermissionChecked();
    const { models: { TranslatedString }, params: { language } } = req;
    const translatedStringRecords = await TranslatedString.findAll({
        where: {
            language
        },
        attributes: [
            'stringId',
            'text'
        ]
    });
    res.send((0, _lodash.mapValues)((0, _lodash.keyBy)(translatedStringRecords, 'stringId'), 'text'));
}));
apiv1.use(_auth.authMiddleware);
apiv1.use(_middleware.constructPermission);
apiv1.delete('/admin/settings/cache', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('manage', 'all');
    _settings.settingsCache.reset();
    res.status(204).send();
}));
apiv1.post('/refresh', _auth.refreshHandler);
apiv1.use(patientDataRoutes); // see below for specifics
apiv1.use(referenceDataRoutes); // see below for specifics
apiv1.use(syncRoutes); // see below for specifics
apiv1.use('/telegram', _telegramRoutes.telegramRoutes);
// patient data endpoints
patientDataRoutes.use('/allergy', _allergy.allergy);
patientDataRoutes.use('/appointments', _appointments.appointments);
patientDataRoutes.use('/diagnosis', _diagnosis.diagnosis);
patientDataRoutes.use('/encounter', _encounter.encounter);
patientDataRoutes.use('/familyHistory', _familyHistory.familyHistory);
patientDataRoutes.use('/imagingRequest', _imaging.imagingRequest);
patientDataRoutes.use('/invoices', _invoice.invoices);
patientDataRoutes.use('/labRequest', _labs.labRequest);
patientDataRoutes.use('/labTest', _labs.labTest);
patientDataRoutes.use('/labTestType', _labs.labTestType);
patientDataRoutes.use('/labTestPanel', _labs.labTestPanel);
patientDataRoutes.use('/medication', _medication.medication);
patientDataRoutes.use('/notes', _note.notes);
patientDataRoutes.use('/ongoingCondition', _ongoingCondition.ongoingCondition);
patientDataRoutes.use('/patient', _patient.patient);
patientDataRoutes.use('/patientCarePlan', _patient.patientCarePlan);
patientDataRoutes.use('/patientIssue', _patient.patientIssue);
patientDataRoutes.use('/procedure', _procedure.procedure);
patientDataRoutes.use('/referral', _referral.referral);
patientDataRoutes.use('/surveyResponse', _surveyResponse.surveyResponse);
patientDataRoutes.use('/surveyResponseAnswer', _surveyResponseAnswer.surveyResponseAnswer);
patientDataRoutes.use('/triage', _triage.triage);
patientDataRoutes.use('/vitals', _vitals.vitals);
// reference data endpoints
referenceDataRoutes.use('/asset', _asset.asset);
referenceDataRoutes.use('/attachment', _attachment.attachment);
referenceDataRoutes.use('/certificateNotification', _certificateNotification.certificateNotification);
referenceDataRoutes.use('/department', _department.department);
referenceDataRoutes.use('/labRequestLog', _labRequestLog.labRequestLog);
referenceDataRoutes.use('/location', _location.location);
referenceDataRoutes.use('/locationGroup', _locationGroup.locationGroup);
referenceDataRoutes.use('/patientFieldDefinition', _patient.patientFieldDefinition);
referenceDataRoutes.use('/template', _template.template);
referenceDataRoutes.use('/program', _program.program);
referenceDataRoutes.use('/programRegistry', _programRegistry.programRegistry);
referenceDataRoutes.use('/referenceData', _referenceData.referenceData);
referenceDataRoutes.use('/reportRequest', _reportRequest.reportRequest);
referenceDataRoutes.use('/reports', _reports.reports);
referenceDataRoutes.use('/scheduledVaccine', _scheduledVaccine.scheduledVaccine);
referenceDataRoutes.use('/suggestions', _suggestions.suggestions);
referenceDataRoutes.use('/survey', _survey.survey);
referenceDataRoutes.use('/user', _user.user);
referenceDataRoutes.use('/vaccinationSettings', _vaccinationSettings.vaccinationSettings);
referenceDataRoutes.use('/upcomingVaccinations', _upcomingVaccinations.upcomingVaccinations);
referenceDataRoutes.use('/translation', _translation.translation);
// sync endpoints
syncRoutes.use('/sync', _sync.sync);
syncRoutes.use('/syncHealth', _syncHealth.syncHealth);
syncRoutes.use('/patientFacility', _patientFacility.patientFacility);

//# sourceMappingURL=index.js.map