"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "location", {
    enumerable: true,
    get: function() {
        return location;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const location = _express.default.Router();
location.get('/:id', (0, _crudHelpers.simpleGet)('Location'));
location.put('/:id', (0, _crudHelpers.simplePut)('Location'));
location.post('/$', (0, _crudHelpers.simplePost)('Location'));
location.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Location');
    if (!_config.default.serverFacilityId) {
        res.send([]);
        return;
    }
    const locations = await req.models.Location.findAll({
        where: {
            facilityId: _config.default.serverFacilityId
        }
    });
    res.send(locations);
}));

//# sourceMappingURL=location.js.map