"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientBirthData", {
    enumerable: true,
    get: function() {
        return patientBirthData;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientBirthData = _express.default.Router();
patientBirthData.get('/:id/birthData', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('read', 'Patient');
    const birthDataRecord = await models.PatientBirthData.findOne({
        where: {
            patientId: params.id
        }
    });
    const recordData = birthDataRecord ? birthDataRecord.toJSON() : {};
    res.send({
        ...recordData
    });
}));

//# sourceMappingURL=patientBirthData.js.map