"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "vaccinationSettings", {
    enumerable: true,
    get: function() {
        return vaccinationSettings;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const vaccinationSettings = _express.default.Router();
vaccinationSettings.get('/:key', (0, _expressasynchandler.default)(async (req, res)=>{
    req.flagPermissionChecked();
    const { settings, params: { key } } = req;
    if (!key.startsWith('vaccinations.')) {
        throw new Error('Invalid vaccinations key');
    }
    const defaults = await settings.get(key);
    res.send({
        data: defaults || null
    });
}));

//# sourceMappingURL=vaccinationSettings.js.map