"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "syncCommand", {
    enumerable: true,
    get: function() {
        return syncCommand;
    }
});
const _commander = require("commander");
const _sleepAsync = require("@tamanu/shared/utils/sleepAsync");
const _logging = require("@tamanu/shared/services/logging");
const _initDeviceId = require("../sync/initDeviceId");
const _sync = require("../sync");
const _ApplicationContext = require("../ApplicationContext");
async function sync({ delay: delaySecondsStr }) {
    const delaySeconds = parseInt(delaySecondsStr, 10);
    if (!Number.isFinite(delaySeconds) || delaySeconds < 0) {
        throw new Error('invalid option for delay');
    }
    const context = await new _ApplicationContext.ApplicationContext().init({
        appType: 'cmd:sync'
    });
    await (0, _initDeviceId.initDeviceId)(context);
    context.centralServer = new _sync.CentralServerConnection(context);
    context.centralServer.connect(); // preemptively connect central server to speed up sync
    context.syncManager = new _sync.FacilitySyncManager(context);
    // eslint-disable-next-line no-constant-condition
    while(true){
        _logging.log.info('Sync subcommand: beginning sync');
        const { ran, enabled, queued } = await context.syncManager.triggerSync({
            type: 'subcommand',
            urgent: true
        });
        if (!enabled) {
            throw new Error('sync is not enabled, check config');
        }
        if (ran) {
            _logging.log.info('Sync subcommand: ran successfully');
            break;
        }
        if (queued) {
            _logging.log.info('Sync subcommand: sync queued, retrying', {
                delaySeconds
            });
            await (0, _sleepAsync.sleepAsync)(delaySeconds * 1000);
            continue;
        }
        // sync is enabled, did not run, and was not queued - error!
        throw new Error('sync is in an unknown state');
    }
}
const syncCommand = new _commander.Command('sync').description('Sync with central server').option('-d, --delay <delay>', 'Delay in seconds between retries if queued', '15').action(sync);

//# sourceMappingURL=sync.js.map