"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "RefreshUpcomingVaccinations", {
    enumerable: true,
    get: function() {
        return RefreshUpcomingVaccinations;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _case = require("case");
const _tasks = require("@tamanu/shared/tasks");
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const _dateTime = require("@tamanu/shared/utils/dateTime");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const buildRefreshMaterializedViewTask = (viewName)=>{
    let RefreshMaterializedView = class RefreshMaterializedView extends _tasks.ScheduledTask {
        getName() {
            return `Refresh${(0, _case.pascal)(this.viewName)}`;
        }
        async run() {
            await this.sequelize.transaction(async ()=>{
                // Set timezone to country timezone this is because sequelize timezone is defaulted to UTC currently
                await this.sequelize.query(`SET TIME ZONE '${_config.default.countryTimeZone}'`);
                await this.sequelize.query(`REFRESH MATERIALIZED VIEW CONCURRENTLY materialized_${(0, _case.snake)(this.viewName)}`, {
                    timezone: _config.default.countryTimeZone
                });
                await this.sequelize.query(`SET TIME ZONE '${this.sequelize.options.timezone}'`); // Revert to sequelize timezone
                await this.sequelize.query(`NOTIFY ${_constants.NOTIFY_CHANNELS.DATA_UPDATED}, '${this.viewName}'`);
            });
            await this.models.LocalSystemFact.set(`${_constants.MATERIALIZED_VIEW_LAST_REFRESHED_AT_KEY_NAMESPACE}:${this.viewName}`, (0, _dateTime.getCurrentISO8601DateString)());
        }
        constructor(context){
            const { schedule, jitterTime, enabled } = _config.default.schedules.refreshMaterializedView[viewName];
            super(schedule, _logging.log, jitterTime, enabled);
            _define_property(this, "viewName", viewName);
            this.sequelize = context.sequelize;
            this.models = context.models;
            this.runImmediately();
        }
    };
    return RefreshMaterializedView;
};
const RefreshUpcomingVaccinations = buildRefreshMaterializedViewTask(_constants.MATERIALIZED_VIEWS.UPCOMING_VACCINATIONS);

//# sourceMappingURL=RefreshMaterializedView.js.map