"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "IPSRequest", {
    enumerable: true,
    get: function() {
        return IPSRequest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let IPSRequest = class IPSRequest extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            createdBy: _sequelize.Sequelize.STRING,
            email: _sequelize.Sequelize.STRING,
            status: _sequelize.Sequelize.STRING,
            error: _sequelize.Sequelize.TEXT
        }, {
            ...options,
            tableName: 'ips_requests',
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'createdBy',
            as: 'createdByUser'
        });
    }
};

//# sourceMappingURL=IPSRequest.js.map