"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientFamilyHistory", {
    enumerable: true,
    get: function() {
        return PatientFamilyHistory;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("./buildPatientSyncFilterViaPatientId");
const _dateTimeTypes = require("./dateTimeTypes");
const _dateTime = require("../utils/dateTime");
const _onSaveMarkPatientForSync = require("./onSaveMarkPatientForSync");
const _buildPatientLinkedLookupFilter = require("./buildPatientLinkedLookupFilter");
let PatientFamilyHistory = class PatientFamilyHistory extends _Model.Model {
    static init({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: _sequelize.Sequelize.STRING,
            recordedDate: (0, _dateTimeTypes.dateTimeType)('recordedDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            }),
            relationship: _sequelize.Sequelize.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
        (0, _onSaveMarkPatientForSync.onSaveMarkPatientForSync)(this);
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'practitionerId',
            as: 'practitioner'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'diagnosisId',
            as: 'diagnosis'
        });
    }
    static getListReferenceAssociations() {
        return [
            'diagnosis'
        ];
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static buildPatientSyncFilter = _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId;
};

//# sourceMappingURL=PatientFamilyHistory.js.map