"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getAvailableReports", {
    enumerable: true,
    get: function() {
        return getAvailableReports;
    }
});
const _constants = require("@tamanu/constants");
const _reportDefinitions = require("../reportDefinitions");
const _canRunStaticReport = require("./canRunStaticReport");
const getStaticReports = (ability)=>{
    const permittedReports = [];
    for (const reportDef of _reportDefinitions.REPORT_DEFINITIONS){
        if ((0, _canRunStaticReport.canRunStaticReport)(ability, reportDef.id)) {
            permittedReports.push(reportDef);
        }
    }
    return permittedReports.map((r)=>({
            ...r,
            legacyReport: true
        }));
};
const getDbReports = async (ability, models)=>{
    const { ReportDefinition, ReportDefinitionVersion } = models;
    const reportDefinitions = await ReportDefinition.findAll({
        include: [
            {
                model: ReportDefinitionVersion,
                as: 'versions',
                where: {
                    status: _constants.REPORT_STATUSES.PUBLISHED
                }
            }
        ],
        order: [
            [
                'versions',
                'version_number',
                'DESC'
            ]
        ]
    });
    const permittedReportDefinitions = reportDefinitions.filter((rd)=>ability.can('run', rd));
    return permittedReportDefinitions.map((r)=>{
        // Get the latest report definition version by getting the first record from the ordered list
        const version = r.versions[0];
        return {
            id: version.id,
            name: r.name,
            dataSourceOptions: version.queryOptions.dataSources,
            filterDateRangeAsStrings: true,
            dateRangeLabel: version.queryOptions.dateRangeLabel || _constants.REPORT_DATE_RANGE_LABELS[version.queryOptions.defaultDateRange],
            parameters: version.getParameters(),
            version: version.versionNumber,
            notes: version.notes
        };
    });
};
const getDisabledReportIds = async (models, userId)=>{
    const { UserLocalisationCache } = models;
    const localisation = await UserLocalisationCache.getLocalisation({
        where: {
            userId
        },
        order: [
            [
                'createdAt',
                'DESC'
            ]
        ]
    });
    return localisation?.disabledReports || [];
};
const getAvailableReports = async (ability, models, userId)=>{
    const permittedReports = [
        ...getStaticReports(ability, models),
        ...await getDbReports(ability, models)
    ];
    const disabledReportIds = await getDisabledReportIds(models, userId);
    const enabledReports = permittedReports.filter(({ id })=>!disabledReportIds.includes(id));
    return enabledReports;
};

//# sourceMappingURL=getAvailableReports.js.map