"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "localTransport", {
    enumerable: true,
    get: function() {
        return localTransport;
    }
});
const _winston = /*#__PURE__*/ _interop_require_default(require("winston"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _color = require("./color");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
// defensive destructure to allow for testing shared directly
const { consoleLevel } = _config.default?.log || {};
// additional parameters to log.info etc will be serialised and logged using this formatter
const additionalDataFormatter = (obj = {})=>{
    if (typeof obj !== 'object') {
        return `${obj}`;
    }
    return Object.entries(obj).map(([key, value])=>`${key}=${value}`).join(' ');
};
// formatter for all logging:
// 2022-03-25T06:52:30.003Z info: My console message! additionalItem=additionalValue
const logFormat = _winston.default.format.printf(({ level, message, childLabel, timestamp, ...rest })=>{
    const restString = additionalDataFormatter(rest);
    if (restString === '') {
        return `${_color.COLORS.grey(timestamp)} ${level}: ${childLabel ? `${childLabel} - ` : ''}${message}`;
    }
    return `${_color.COLORS.grey(timestamp)} ${level}: ${message} ${_color.COLORS.grey(restString)}`;
});
const localTransport = new _winston.default.transports.Console({
    format: _winston.default.format.combine(_winston.default.format.colorize(), _winston.default.format.timestamp(), logFormat),
    level: consoleLevel || 'info',
    silent: !consoleLevel
});

//# sourceMappingURL=console.js.map