"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "asNewRole", {
    enumerable: true,
    get: function() {
        return asNewRole;
    }
});
const _fake = require("./fake");
const asNewRole = async (baseApp, models, permissions = [], roleOverrides = {})=>{
    const { Role, Permission } = models;
    const role = await Role.create((0, _fake.fake)(Role), roleOverrides);
    const app = await baseApp.asRole(role.id);
    app.role = role;
    await Permission.bulkCreate(permissions.map(([verb, noun, objectId])=>({
            roleId: role.id,
            userId: app.user.id,
            verb,
            noun,
            objectId
        })));
    return app;
};

//# sourceMappingURL=roles.js.map