"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientDetailsWithBarcode", {
    enumerable: true,
    get: function() {
        return PatientDetailsWithBarcode;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _DataSection = require("./DataSection");
const _renderer = require("@react-pdf/renderer");
const _Typography = require("../Typography");
const _Layout = require("../Layout");
const _patientAccessors = require("../../patientAccessors");
const _PrintableBarcode = require("./PrintableBarcode");
const _renderDataItems = require("./renderDataItems");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const PatientDetailsWithBarcode = ({ patient, getLocalisation })=>{
    const PATIENT_FIELDS = {
        leftCol: [
            {
                key: 'firstName',
                label: 'First name'
            },
            {
                key: 'lastName',
                label: 'Last name'
            },
            {
                key: 'dateOfBirth',
                label: 'DOB',
                accessor: _patientAccessors.getDOBWithAge
            },
            {
                key: 'sex',
                label: 'Sex',
                accessor: _patientAccessors.getSex
            },
            {
                key: 'villageName',
                label: 'Village',
                accessor: _patientAccessors.getVillageName
            }
        ],
        rightCol: [
            ...patient.patientWeight !== undefined ? [
                {
                    key: 'patientWeight',
                    label: 'Patient weight',
                    accessor: (data)=>(0, _patientAccessors.getPatientWeight)(data, getLocalisation)
                }
            ] : [],
            {
                key: 'displayId',
                label: 'Patient ID'
            }
        ]
    };
    return /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: "Patient details"
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_FIELDS.leftCol, patient, getLocalisation)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_FIELDS.rightCol, patient, getLocalisation), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            flexDirection: 'row'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        style: {
            marginTop: 9
        },
        fontSize: 9,
        bold: true
    }, "Patient ID barcode:"), /*#__PURE__*/ _react.default.createElement(_PrintableBarcode.PrintableBarcode, {
        id: patient.displayId
    }))));
};

//# sourceMappingURL=PatientDetailsWithBarcode.js.map