"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFlexibleChecksumsPlugin = void 0;
const flexibleChecksumsMiddleware_1 = require("./flexibleChecksumsMiddleware");
const flexibleChecksumsResponseMiddleware_1 = require("./flexibleChecksumsResponseMiddleware");
const getFlexibleChecksumsPlugin = (config, middlewareConfig) => ({
    applyToStack: (clientStack) => {
        clientStack.add((0, flexibleChecksumsMiddleware_1.flexibleChecksumsMiddleware)(config, middlewareConfig), flexibleChecksumsMiddleware_1.flexibleChecksumsMiddlewareOptions);
        clientStack.addRelativeTo((0, flexibleChecksumsResponseMiddleware_1.flexibleChecksumsResponseMiddleware)(config, middlewareConfig), flexibleChecksumsResponseMiddleware_1.flexibleChecksumsResponseMiddlewareOptions);
    },
});
exports.getFlexibleChecksumsPlugin = getFlexibleChecksumsPlugin;
