"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isChecksumWithPartNumber = void 0;
const isChecksumWithPartNumber = (checksum) => {
    const lastHyphenIndex = checksum.lastIndexOf("-");
    if (lastHyphenIndex !== -1) {
        const numberPart = checksum.slice(lastHyphenIndex + 1);
        if (!numberPart.startsWith("0")) {
            const number = parseInt(numberPart, 10);
            if (!isNaN(number) && number >= 1 && number <= 10000) {
                return true;
            }
        }
    }
    return false;
};
exports.isChecksumWithPartNumber = isChecksumWithPartNumber;
