"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRegionRedirectMiddlewarePlugin = exports.regionRedirectMiddlewareOptions = exports.regionRedirectMiddleware = void 0;
const region_redirect_endpoint_middleware_1 = require("./region-redirect-endpoint-middleware");
function regionRedirectMiddleware(clientConfig) {
    return (next, context) => async (args) => {
        var _a;
        try {
            return await next(args);
        }
        catch (err) {
            if (clientConfig.followRegionRedirects &&
                err.$metadata.httpStatusCode === 301) {
                try {
                    const actualRegion = err.$response.headers["x-amz-bucket-region"];
                    (_a = context.logger) === null || _a === void 0 ? void 0 : _a.debug(`Redirecting from ${await clientConfig.region()} to ${actualRegion}`);
                    context.__s3RegionRedirect = actualRegion;
                }
                catch (e) {
                    throw new Error("Region redirect failed: " + e);
                }
                return next(args);
            }
            else {
                throw err;
            }
        }
    };
}
exports.regionRedirectMiddleware = regionRedirectMiddleware;
exports.regionRedirectMiddlewareOptions = {
    step: "initialize",
    tags: ["REGION_REDIRECT", "S3"],
    name: "regionRedirectMiddleware",
    override: true,
};
const getRegionRedirectMiddlewarePlugin = (clientConfig) => ({
    applyToStack: (clientStack) => {
        clientStack.add(regionRedirectMiddleware(clientConfig), exports.regionRedirectMiddlewareOptions);
        clientStack.addRelativeTo((0, region_redirect_endpoint_middleware_1.regionRedirectEndpointMiddleware)(clientConfig), region_redirect_endpoint_middleware_1.regionRedirectEndpointMiddlewareOptions);
    },
});
exports.getRegionRedirectMiddlewarePlugin = getRegionRedirectMiddlewarePlugin;
