import * as api from '@opentelemetry/api';
import { ReadableSpan, TimedEvent } from '@opentelemetry/sdk-trace-base';
import * as zipkinTypes from './types';
import { Resource } from '@opentelemetry/resources';
export declare const defaultStatusCodeTagName = "otel.status_code";
export declare const defaultStatusErrorTagName = "error";
/**
 * Translate OpenTelemetry ReadableSpan to ZipkinSpan format
 * @param span Span to be translated
 */
export declare function toZipkinSpan(span: ReadableSpan, serviceName: string, statusCodeTagName: string, statusErrorTagName: string): zipkinTypes.Span;
/** Converts OpenTelemetry SpanAttributes and SpanStatus to Zipkin Tags format. */
export declare function _toZipkinTags(attributes: api.SpanAttributes, status: api.SpanStatus, statusCodeTagName: string, statusErrorTagName: string, resource: Resource): zipkinTypes.Tags;
/**
 * Converts OpenTelemetry Events to Zipkin Annotations format.
 */
export declare function _toZipkinAnnotations(events: TimedEvent[]): zipkinTypes.Annotation[];
//# sourceMappingURL=transform.d.ts.map