/// <reference types="node" />
import type * as grpcTypes from 'grpc';
import * as events from 'events';
export declare type SendUnaryDataCallback = (error: grpcTypes.ServiceError | null, value?: any, trailer?: grpcTypes.Metadata, flags?: grpcTypes.writeFlags) => void;
interface GrpcStatus {
    code: number;
    details: string;
    metadata: grpcTypes.Metadata;
}
export declare type ServerCall = typeof grpcTypes.ServerUnaryCall | typeof grpcTypes.ServerReadableStream | typeof grpcTypes.ServerWritableStream | typeof grpcTypes.ServerDuplexStream;
export declare type ServerCallWithMeta = ServerCall & {
    metadata: grpcTypes.Metadata;
    status: GrpcStatus;
    request?: unknown;
} & events.EventEmitter;
export declare type GrpcClientFunc = typeof Function & {
    path: string;
    requestStream: boolean;
    responseStream: boolean;
};
export declare type GrpcInternalClientTypes = {
    makeClientConstructor: typeof grpcTypes.makeGenericClientConstructor;
};
export {};
//# sourceMappingURL=types.d.ts.map