import { ServiceClientType } from './types';
import { OTLPProtoExporterNodeBase } from './OTLPProtoExporterNodeBase';
import { CompressionAlgorithm, OTLPExporterError } from '@opentelemetry/otlp-exporter-base';
import type * as protobuf from 'protobufjs';
export interface ExportRequestType<T, R = T & {
    toJSON: () => unknown;
}> {
    create(properties?: T): R;
    encode(message: T, writer?: protobuf.Writer): protobuf.Writer;
    decode(reader: (protobuf.Reader | Uint8Array), length?: number): R;
}
export declare function getExportRequestProto<ServiceRequest>(clientType: ServiceClientType): ExportRequestType<ServiceRequest>;
export declare function send<ExportItem, ServiceRequest>(collector: OTLPProtoExporterNodeBase<ExportItem, ServiceRequest>, objects: ExportItem[], compression: CompressionAlgorithm, onSuccess: () => void, onError: (error: OTLPExporterError) => void): void;
//# sourceMappingURL=util.d.ts.map