(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsMl = factory();
  }
})(this, function () {
  var patterns =
    '{"‍":[{},[2,2]],"‌":[{},[1,1]],"അ":[{},[1,1]],"ആ":[{},[1,1]],"ഇ":[{},[1,1]],"ഈ":[{},[1,1]],"ഉ":[{},[1,1]],"ഊ":[{},[1,1]],"ഋ":[{},[1,1]],"ൠ":[{},[1,1]],"ഌ":[{},[1,1]],"ൡ":[{},[1,1]],"എ":[{},[1,1]],"ഏ":[{},[1,1]],"ഐ":[{},[1,1]],"ഒ":[{},[1,1]],"ഓ":[{},[1,1]],"ഔ":[{},[1,1]],"ാ":[{},[0,1]],"ി":[{},[0,1]],"ീ":[{},[0,1]],"ു":[{},[0,1]],"ൂ":[{},[0,1]],"ൃ":[{},[0,1]],"െ":[{},[0,1]],"േ":[{},[0,1]],"ൈ":[{},[0,1]],"ൊ":[{},[0,1]],"ോ":[{},[0,1]],"ൌ":[{},[0,1]],"ൗ":[{},[0,1]],"ക":[{"്":[{"‍":[{},[2]]},[0,0,2]]},[1]],"ഖ":[{},[1]],"ഗ":[{},[1]],"ഘ":[{},[1]],"ങ":[{},[1]],"ച":[{},[1]],"ഛ":[{},[1]],"ജ":[{},[1]],"ഝ":[{},[1]],"ഞ":[{},[1]],"ട":[{},[1]],"ഠ":[{},[1]],"ഡ":[{},[1]],"ഢ":[{},[1]],"ണ":[{"്":[{"‍":[{},[2]]},[0,0,2]]},[1]],"ത":[{},[1]],"ഥ":[{},[1]],"ദ":[{},[1]],"ധ":[{},[1]],"ന":[{"്":[{"‍":[{},[2]]},[0,0,2]]},[1]],"പ":[{},[1]],"ഫ":[{},[1]],"ബ":[{},[1]],"ഭ":[{},[1]],"മ":[{},[1]],"യ":[{},[1]],"ര":[{"്":[{"‍":[{},[2]]},[0,0,2]]},[1]],"റ":[{},[1]],"ല":[{"്":[{"‍":[{},[2]]},[0,0,2]]},[1]],"ള":[{"്":[{"‍":[{},[2]]},[0,0,2]]},[1]],"ഴ":[{},[1]],"വ":[{},[1]],"ശ":[{},[1]],"ഷ":[{},[1]],"സ":[{},[1]],"ഹ":[{},[1]],"ഃ":[{},[2,1]],"ം":[{},[2,1]],"്":[{},[2,2]],"ൺ":[{},[2]],"ൻ":[{},[2]],"ർ":[{},[2]],"ൽ":[{},[2]],"ൾ":[{},[2]],"ൿ":[{},[2]]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
