(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsSl = factory();
  }
})(this, function () {
  var patterns =
    '{".":[{"a":[{"v":[{"r":[{},[0,0,5]]}]}],"d":[{"i":[{"s":[{"p":[{"o":[{},[0,0,6]]}]}]}]}],"e":[{"k":[{"s":[{},[0,0,3]],"v":[{},[0,0,5]]}]}],"i":[{"s":[{},[0,0,1]],"z":[{},[0,0,1]]}],"o":[{"b":[{"i":[{"d":[{},[0,0,0,4]],"t":[{},[0,0,5]]}]}],"d":[{},[0,0,1]]}],"p":[{"o":[{"d":[{"n":[{},[0,0,4,5]]}],"v":[{"s":[{},[0,0,4,5]]}]}],"r":[{"e":[{"d":[{"n":[{},[0,0,0,6,7]]}]}]}]}],"s":[{"e":[{"k":[{"s":[{},[0,0,4,5]]}]}],"i":[{"s":[{},[0,0,4]]}],"t":[{},[0,0,4]]}],"v":[{"o":[{"z":[{"l":[{},[0,0,0,5]],"n":[{},[0,0,0,5]]}]}]}],"z":[{"l":[{"i":[{"z":[{},[0,0,0,0,6]]}]}]}],"č":[{},[0,8]],"š":[{},[0,8]],"ž":[{},[0,8]]}],"a":[{"a":[{},[0,1]],"b":[{"b":[{"a":[{},[0,0,5]]}],"r":[{"o":[{"d":[{},[0,0,6]]}]}]},[0,1]],"c":[{"c":[{"i":[{},[0,0,5]]}]},[0,1]],"č":[{},[0,1]],"d":[{"l":[{},[0,0,2]],"o":[{"b":[{"l":[{},[0,6]]}]}],"r":[{"l":[{".":[{},[0,0,6]],"a":[{},[0,0,6]]}],"o":[{"b":[{},[0,0,6]]}]}],"u":[{"r":[{},[0,0,5]]}]},[0,1]],"e":[{},[0,1,1]],"f":[{"g":[{"a":[{},[0,0,5]]}],"t":[{},[0,0,1]]},[0,1]],"g":[{},[0,1]],"h":[{"m":[{"i":[{},[0,0,5]],"o":[{},[0,0,5]]},[0,4]]},[0,1]],"i":[{"n":[{},[0,0,2,1]]},[0,1]],"j":[{"e":[{"k":[{},[0,4,5]]}],"f":[{"i":[{},[0,0,5]],"o":[{},[0,0,5]]},[0,4]],"h":[{"a":[{},[0,0,5]],"e":[{},[0,0,5]]}],"i":[{"m":[{"o":[{},[0,0,6]]},[0,0,5]]}],"o":[{"s":[{},[0,0,3]]}],"s":[{"t":[{"b":[{},[0,0,6]]}]}],"u":[{".":[{},[0,5]],"č":[{},[0,0,3]],"g":[{},[0,0,3]]}],"ž":[{"n":[{},[0,0,5]]}]},[0,1]],"k":[{"s":[{"t":[{},[0,4]]},[0,0,4]]},[0,1]],"l":[{},[0,1]],"m":[{"z":[{},[0,4]]},[0,1]],"n":[{"d":[{"g":[{"a":[{},[0,0,6]]}],"h":[{"i":[{},[0,0,6]]}]}],"m":[{"i":[{},[0,0,5]]},[0,4]],"z":[{"i":[{},[0,0,5]]}]},[0,1]],"o":[{"b":[{},[0,0,2,1]]},[0,1]],"p":[{"h":[{},[0,4]]},[0,1]],"r":[{"a":[{},[0,1]],"d":[{"w":[{"a":[{},[0,0,6]]}]}],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]],"x":[{"a":[{},[0,0,5]],"o":[{},[0,0,5]],"u":[{},[0,0,5]]}]}],"s":[{"š":[{"č":[{},[0,0,5]]},[0,4]]},[0,1]],"š":[{},[0,1]],"t":[{"f":[{},[0,4]],"i":[{},[0,0,4]]},[0,1]],"u":[{"f":[{},[0,4]],"k":[{},[0,2]],"l":[{},[0,4]]},[0,1,1]],"v":[{"š":[{"i":[{},[0,0,5]]}],"ž":[{"a":[{},[0,0,5]]},[0,4]]},[0,1]],"y":[{"t":[{"o":[{},[0,0,5]]}]}],"z":[{"e":[{},[0,1]],"f":[{"o":[{},[0,0,5]]}],"i":[{"g":[{},[0,4]]}],"l":[{"a":[{},[0,0,3]],"e":[{},[0,0,3]],"i":[{"l":[{},[0,0,4]],"t":[{},[0,0,4]],"v":[{},[0,0,4]]}]}],"o":[{"b":[{},[0,4]],"č":[{},[0,4,3]],"r":[{"a":[{},[0,0,5]],"o":[{},[0,0,5]]}]}],"r":[{"a":[{},[0,4]],"e":[{"d":[{},[0,0,4]]}]}],"v":[{"p":[{},[0,0,5]]}]}],"ž":[{"m":[{"i":[{},[0,0,5]]}]},[0,1]]}],"b":[{"a":[{"b":[{"b":[{"a":[{},[0,0,6]]}]}],"n":[{"č":[{},[0,0,0,3,4]]}],"u":[{},[0,0,4]]}],"c":[{},[2,1]],"č":[{},[2,1]],"d":[{},[2,1]],"e":[{"v":[{},[0,0,4]]},[0,0,1]],"h":[{},[0,1]],"i":[{},[0,0,1]],"j":[{"a":[{".":[{},[0,4]]},[0,1]],"e":[{"l":[{},[0,5]],"m":[{},[0,3]],"t":[{},[0,5]]}]}],"k":[{},[2,1]],"l":[{"e":[{"p":[{},[0,3]],"t":[{"a":[{},[0,5]]}]}],"i":[{"l":[{},[0,5]],"t":[{},[0,5]],"v":[{},[0,5]]}]}],"m":[{"i":[{},[4]]},[0,1]],"n":[{},[2,1]],"o":[{"c":[{"h":[{"m":[{},[0,0,6]]}]}],"r":[{"d":[{},[0,5]]}],"v":[{"p":[{},[0,0,5]]}]},[0,0,1]],"r":[{"a":[{"b":[{},[0,3]],"s":[{},[0,5]],"š":[{},[0,3]]}],"e":[{"z":[{"g":[{},[0,0,0,4]],"i":[{},[0,0,0,4]],"r":[{},[0,0,0,4]]},[0,3]],"ž":[{"e":[{},[0,5]]}]}],"o":[{"b":[{},[0,3]]}],"ž":[{"d":[{"a":[{},[0,0,6]]}]}]}],"s":[{},[2,1]],"š":[{},[2,1]],"t":[{},[2,1]],"u":[{"k":[{"i":[{},[0,0,5]],"u":[{},[0,0,5]],"v":[{},[0,0,5]]}],"r":[{"y":[{},[0,0,5]]}]}],"v":[{},[2,1]],"z":[{},[0,1]],"ž":[{},[0,1]]}],"c":[{"c":[{},[2]],"h":[{".":[{},[2]],"m":[{"a":[{},[0,0,5]]}]}],"k":[{"a":[{},[0,1]],"o":[{".":[{},[0,5]],"v":[{},[0,0,0,0,3]]},[0,0,1,2]],"s":[{},[0,0,1]],"w":[{"e":[{},[0,0,5]]}]},[2]],"n":[{},[2,1]],"t":[{},[2,1]]}],"č":[{"b":[{},[2,1]],"g":[{},[2,1]],"i":[{},[0,0,1]],"j":[{},[1]],"k":[{},[2,1]],"l":[{"e":[{"t":[{},[4,3]]}]},[1]],"m":[{"e":[{"s":[{},[0,5]]}]}],"n":[{},[2,1]],"o":[{"p":[{},[4]]}],"p":[{},[2,1]],"s":[{},[2,1]],"u":[{"p":[{},[4]]}],".":[{},[8]]}],"d":[{"b":[{},[2,1]],"c":[{},[2,1]],"č":[{},[2,1]],"d":[{"v":[{"o":[{"j":[{},[0,0,6]]}]}]},[2,1]],"e":[{"l":[{"e":[{"m":[{},[6,5]]}]}],"m":[{"i":[{"n":[{},[0,0,4]]}],"n":[{},[0,0,4]]}],"z":[{"i":[{},[0,0,4,3]]}]},[0,2]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"c":[{"k":[{},[0,0,5]]}],"n":[{"d":[{},[4]],"o":[{},[0,4,5]]}],"s":[{"k":[{"r":[{},[0,0,4]]}],"p":[{"r":[{},[0,0,6]]}]},[0,0,0,1]]}],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{"e":[{"t":[{},[5]]}],"i":[{"t":[{},[0,5]],"v":[{},[0,5]]},[0,2]],"o":[{},[0,1]]}],"m":[{},[2,3]],"n":[{"a":[{"c":[{},[4,3]],"č":[{},[4,5]],"p":[{},[4,5]],"r":[{},[4,3]],"s":[{},[4]]}],"e":[{"b":[{},[4,5]]}],"i":[{"v":[{},[0,5]],"z":[{},[4,5]]}],"j":[{"a":[{"č":[{},[4,5]]}]}],"o":[{"ž":[{},[4,3]]}]}],"o":[{"b":[{"č":[{},[4]],"d":[{},[4,5]]}],"f":[{},[2,3,2]],"r":[{"d":[{},[0,0,5]]}],"v":[{"č":[{},[0,0,5]],"z":[{},[0,0,5,4]]}]},[0,2]],"p":[{},[2,1]],"r":[{"a":[{"z":[{},[0,5]]}],"e":[{"p":[{"n":[{},[0,0,0,6]]},[0,3]],"v":[{},[0,4]]}]}],"s":[{},[2,1]],"š":[{},[2,1]],"t":[{"e":[{"k":[{"s":[{},[0,0,0,0,0,6]]}]}]},[2,1]],"u":[{"r":[{"o":[{},[0,0,5]]},[0,4]],"u":[{"m":[{},[0,0,5]]}]}],"v":[{"i":[{},[4,3]]},[2,1]],"z":[{},[2,1,2]]}],"e":[{"a":[{},[0,1]],"b":[{"j":[{},[0,0,4]],"l":[{"i":[{"z":[{},[0,0,6]]}]}]},[0,1]],"c":[{},[0,1]],"č":[{"d":[{"e":[{},[0,0,5]],"i":[{},[0,0,5]],"o":[{},[0,0,5]]},[0,4]],"l":[{"e":[{},[0,0,3]]}],"o":[{"p":[{},[0,0,5]]}],"t":[{"i":[{},[0,0,5]],"o":[{},[0,0,5]],"r":[{},[0,0,5]]},[0,4]],"u":[{"p":[{},[0,0,5]]}],"v":[{"r":[{"s":[{},[0,0,6]]}]},[0,2,1]]},[0,1]],"d":[{"f":[{},[0,4]],"i":[{"g":[{},[0,0,5]]}],"l":[{},[0,0,2]],"o":[{"b":[{"e":[{},[0,0,6]],"r":[{},[0,0,6]],"s":[{},[0,4]]},[0,0,5]],"č":[{},[0,4,3]]}],"v":[{"č":[{},[0,0,5]]}],"z":[{"b":[{},[0,0,5]]}]},[0,1]],"e":[{"p":[{},[0,4]]},[0,1]],"f":[{"f":[{"e":[{},[0,0,5]]},[0,4]],"t":[{"a":[{},[0,0,5]]}]},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{"p":[{"z":[{"i":[{},[0,0,6]]}]}],"z":[{"e":[{},[0,0,0,5]]},[0,0,2]]},[0,1]],"j":[{},[0,1]],"k":[{"m":[{"a":[{"l":[{},[0,0,6]]}]}],"t":[{"r":[{"e":[{},[0,0,6]]}]}]},[0,1]],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{"b":[{"j":[{},[0,0,0,4]],"r":[{},[0,0,0,4]]}],"d":[{"l":[{},[0,0,4]]}],"z":[{"n":[{},[0,0,4,5]]}]},[0,1,1]],"p":[{"n":[{"i":[{"k":[{},[0,0,5]]}]}]},[0,1]],"r":[{"a":[{"z":[{"l":[{},[0,0,0,6,5]],"r":[{},[0,0,0,5,4]],"v":[{},[0,0,0,5,4]]}]},[0,1]],"e":[{},[0,1]],"f":[{},[0,4]],"i":[{},[0,1]],"o":[{},[0,1]],"r":[{},[0,4]],"u":[{},[0,1]]}],"s":[{"d":[{"a":[{},[0,0,5]]}],"t":[{"a":[{},[0,5]],"i":[{".":[{},[0,5]],"h":[{},[0,5]],"l":[{},[0,5]]}]}]},[0,1]],"š":[{"p":[{"o":[{},[0,0,5]]},[0,4]]},[0,1]],"t":[{"h":[{},[4]],"i":[{"n":[{"š":[{},[0,4]]}]}]},[0,1]],"u":[{},[0,1,1]],"v":[{"e":[{"t":[{"l":[{},[0,0,0,6,5]]}]}],"h":[{"a":[{},[0,0,5]]}],"p":[{"r":[{"e":[{},[0,0,6]]}]}],"s":[{"t":[{"e":[{},[0,0,6]],"v":[{},[0,0,5]]}]}]},[0,1]],"w":[{"i":[{"n":[{"d":[{},[0,0,6]]}]}],"l":[{"e":[{},[0,0,5]]}],"t":[{"o":[{},[0,0,5]]},[0,4]]},[2]],"y":[{"w":[{},[0,4]]}],"z":[{"d":[{"j":[{},[0,0,5]],"r":[{},[0,3,4]]}],"g":[{"l":[{},[0,0,5]]},[0,0,2]],"i":[{"j":[{"o":[{},[0,0,6]]},[0,5]],"m":[{"n":[{},[0,0,5]]}],"s":[{"t":[{},[0,0,6]]},[0,5]],"z":[{},[0,0,5]]}],"l":[{"o":[{"m":[{},[0,0,6]]}]},[0,0,4]],"m":[{"a":[{"n":[{},[0,0,6]]}],"o":[{},[0,0,4]]}],"o":[{"b":[{},[0,4]],"r":[{},[0,4,5]]}],"r":[{"e":[{},[0,0,4]]}],"t":[{},[0,4]],"u":[{"m":[{},[0,4,5,4,5]]}],"ž":[{},[0,4]]},[0,1]],"ž":[{},[0,1]]}],"f":[{"a":[{},[1]],"e":[{"l":[{"j":[{"t":[{},[0,0,6]]}]}]},[0,0,1]],"f":[{"m":[{"a":[{},[0,0,5]]}]}],"i":[{"z":[{"l":[{"j":[{},[0,0,6]]}]}]}],"n":[{},[2,1]],"o":[{"u":[{"r":[{"i":[{},[0,0,6]]}]}]}],"r":[{"e":[{"u":[{},[0,0,0,4]]}]}],"s":[{},[2,1]],"t":[{"v":[{"e":[{},[0,0,5]]}]},[2]],"u":[{},[0,0,1]]}],"g":[{"d":[{},[2,1]],"e":[{"i":[{"g":[{"e":[{},[0,0,6]]}]}],"l":[{"č":[{},[0,0,0,5,4]]}],"n":[{"j":[{"č":[{},[0,0,6]]}]}]}],"i":[{"t":[{"p":[{"r":[{},[0,0,6]]}]}]}],"o":[{"v":[{"z":[{},[0,0,5]]}]},[0,0,1]],"t":[{},[2,1]],"u":[{},[0,0,1]]}],"h":[{"a":[{"u":[{},[0,0,4]]}],"č":[{},[2,1]],"e":[{"i":[{},[0,0,4]]}],"k":[{},[2,1]],"l":[{".":[{},[4]],"o":[{},[0,4]]}],"n":[{},[2,1]],"r":[{"e":[{"n":[{},[0,5]]}]}],"š":[{},[2,1]],"t":[{},[2,1]],"u":[{"f":[{"f":[{"m":[{},[0,0,6]]}]}]},[1]]}],"i":[{"a":[{},[0,1]],"b":[{},[0,1]],"c":[{"s":[{},[0,4]]},[0,1]],"č":[{"a":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"r":[{"a":[{},[0,0,5]]}],"u":[{},[0,1]],"v":[{"r":[{},[0,0,5]]}]}],"d":[{"o":[{"r":[{},[4]]}]},[0,1]],"e":[{},[0,1,1]],"f":[{},[0,1]],"g":[{"h":[{},[4]]},[0,1]],"h":[{},[0,1]],"i":[{"n":[{},[0,0,2,1]]},[0,1]],"j":[{},[0,1]],"k":[{"č":[{"a":[{},[0,0,5]]},[0,4]]},[0,1]],"l":[{"č":[{"k":[{},[0,0,5,4]]}],"e":[{},[4]],"o":[{},[4]]},[0,1]],"m":[{"h":[{"i":[{},[0,0,5]]},[0,4]]},[0,1]],"n":[{"d":[{},[1]],"e":[{},[2]],"o":[{"s":[{},[3,4,3]]}],"p":[{},[1]],"s":[{"e":[{},[3]]}],"š":[{"k":[{},[4]]},[1]],"t":[{"r":[{},[3]]}]},[0,1]],"o":[{},[0,1,1]],"p":[{},[0,1]],"r":[{"e":[{},[4]]},[0,1]],"s":[{"a":[{},[0,0,4]],"e":[{"r":[{"t":[{},[0,0,6]]}]}],"i":[{"s":[{},[0,0,0,0,4]]}],"k":[{"v":[{},[0,4]]}],"s":[{},[2]]},[0,1]],"š":[{},[0,1]],"t":[{"p":[{"r":[{},[0,0,5]]}]},[0,1]],"u":[{},[0,1]],"v":[{"j":[{"o":[{},[0,0,5]]}]},[0,1]],"x":[{},[0,1]],"z":[{"l":[{"a":[{},[0,0,4]],"i":[{"z":[{},[0,0,0,0,4]]}]},[0,0,1]],"m":[{"e":[{},[0,0,5]],"o":[{},[0,0,5]]}],"o":[{"d":[{"e":[{},[0,0,6]]}]}],"p":[{"o":[{},[0,0,5]]}],"r":[{},[0,2]],"u":[{"r":[{"e":[{},[0,0,6]]}]},[0,0,1]]},[0,1]],"ž":[{},[0,1]]}],"j":[{"a":[{"k":[{"t":[{},[0,5]]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"č":[{},[2,1]],"d":[{},[2,1]],"e":[{"k":[{"s":[{},[0,0,4,0,4]]}]}],"g":[{},[2,1]],"h":[{"i":[{},[0,1]]},[2]],"i":[{"m":[{"e":[{},[4]]}],"n":[{"t":[{},[4,5]]}]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"b":[{},[4]],"d":[{"l":[{},[0,0,0,4]]},[2,1]],"s":[{},[2]],"ž":[{},[4]]}],"p":[{},[2,1]],"r":[{"a":[{"z":[{},[0,0,0,0,4]]},[0,0,0,1]]},[2,1]],"s":[{"i":[{"s":[{"t":[{},[0,0,0,0,6]]}]}]},[2,1]],"š":[{},[2,1]],"t":[{},[2,1]],"u":[{"č":[{},[2]],"d":[{"m":[{},[0,0,5]]}],"s":[{},[2]],"ž":[{},[0,0,2,1]]},[0,0,1]],"v":[{},[2,1]],"z":[{"v":[{"e":[{"s":[{},[0,0,6]]}]}]},[2,1]]}],"k":[{"c":[{},[2,1]],"d":[{},[2,1]],"e":[{"t":[{"i":[{},[0,0,5]]}]}],"i":[{},[0,0,1]],"m":[{},[2,1]],"n":[{},[1]],"o":[{"k":[{"d":[{},[0,0,5]]},[0,0,0,4]],"v":[{"š":[{"e":[{},[0,0,6]]}]}],"z":[{"l":[{"o":[{},[0,0,0,6]]}]}]},[0,0,1]],"r":[{"e":[{},[1]]}],"s":[{".":[{},[2]],"a":[{"t":[{},[0,5]]}],"c":[{},[0,0,1]],"p":[{"o":[{},[0,0,4]]},[0,0,1]],"t":[{".":[{},[4]],"a":[{"z":[{},[0,0,6]]}],"e":[{},[0,0,5]]},[0,0,1]]}],"t":[{"r":[{"a":[{},[4]]},[3]]},[2,1]],"u":[{"r":[{"o":[{},[0,0,5]]}]}],"v":[{"i":[{"p":[{},[0,5]]}]}]}],"l":[{"a":[{"i":[{"r":[{},[0,0,4]]}],"v":[{"z":[{".":[{},[0,0,6]]}]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"č":[{},[2,1]],"d":[{},[2,1]],"e":[{"e":[{},[0,0,4]],"i":[{"p":[{"z":[{},[0,0,6]]}]}],"m":[{"e":[{},[0,0,5]]}]},[0,0,1]],"f":[{},[2,1]],"g":[{"č":[{"a":[{},[0,0,5]]}]},[2,1]],"h":[{},[2,1]],"i":[{"d":[{"ž":[{".":[{},[0,0,6]]}]}],"z":[{"d":[{},[4,5]]},[1]]},[0,2,1]],"j":[{".":[{},[2]],"c":[{},[4]],"č":[{},[2]],"k":[{},[2]],"n":[{},[2]],"s":[{},[2]],"š":[{},[2]],"u":[{"d":[{"j":[{},[0,0,0,5,6]]}]}]}],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"č":[{},[1]]},[0,0,1]],"p":[{},[2,1]],"s":[{},[2,1]],"š":[{},[2,1]],"t":[{},[2,1]],"u":[{"k":[{"i":[{},[0,0,5]],"u":[{},[0,0,5]]}]}],"v":[{},[2,1]],"z":[{},[2,1]],"ž":[{},[2,1]]}],"m":[{"b":[{},[2,1]],"c":[{},[2,1]],"č":[{},[2,1]],"d":[{},[2,1]],"e":[{"d":[{"n":[{},[0,0,4,5]],"o":[{"s":[{},[0,0,6]]}],"r":[{},[0,0,4]]}]}],"f":[{},[2,1]],"i":[{"n":[{"d":[{},[4]],"p":[{},[4]],"š":[{},[4]]}],"t":[{"h":[{".":[{},[0,0,6]]}]}]}],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{"i":[{"v":[{},[0,5]]}]}],"o":[{"š":[{"t":[{".":[{},[0,0,6]]}]}],"v":[{"š":[{".":[{},[0,0,6]]}]}]}],"p":[{},[2,1]],"s":[{},[2,1]],"š":[{},[2,1]],"t":[{},[2,1]],"u":[{"r":[{"n":[{},[0,5]]}]}],"v":[{},[2,1]],"y":[{"h":[{"i":[{},[0,0,5]]}]}],"ž":[{},[2,1]]}],"n":[{"a":[{"č":[{"e":[{"l":[{},[5]]}]}],"d":[{"n":[{"j":[{},[0,0,4,5]]}],"r":[{"a":[{},[0,0,6]],"e":[{},[0,0,4]]},[0,0,0,5]],"u":[{"r":[{},[0,0,6]]}]}],"j":[{"a":[{"k":[{},[0,0,6]]}],"e":[{"n":[{},[0,0,4,5]]}],"o":[{"č":[{},[0,0,6]]},[0,0,0,3]],"u":[{},[0,0,4,3]]},[1]],"s":[{},[1]],"v":[{"z":[{"e":[{},[0,0,0,0,0,6]]},[0,0,4,3]]}],"z":[{"o":[{"r":[{},[0,0,0,6]]}]},[1]]},[0,0,1]],"b":[{},[2,1]],"c":[{},[2,1]],"č":[{"a":[{},[0,1]],"e":[{},[0,1]],"i":[{},[0,1]],"u":[{},[0,1]]},[2]],"d":[{"g":[{"a":[{},[0,0,5]]}],"h":[{"i":[{},[0,0,5]]}],"m":[{},[0,4]]},[2,3,2]],"e":[{"d":[{},[0,0,3,2]],"h":[{},[1]],"z":[{"m":[{},[0,0,3]],"v":[{},[0,0,0,4]]}]},[0,0,1]],"f":[{},[2,1]],"g":[{"h":[{"a":[{},[0,0,5]]},[0,4]],"v":[{"i":[{},[0,0,5]]},[0,4]]},[2,1]],"h":[{},[2,1]],"j":[{".":[{},[2]],"c":[{},[2]],"e":[{"v":[{"s":[{},[0,0,0,4,5]]}]}],"k":[{},[2]],"s":[{},[2]],"š":[{},[2]],"v":[{},[4]]}],"k":[{},[2,1]],"l":[{},[2,1]],"n":[{},[2,1]],"o":[{"r":[{"d":[{},[0,0,5]]}],"s":[{"t":[{},[0,4]]}]}],"p":[{},[2,1]],"s":[{"i":[{"s":[{},[0,0,0,0,4]]}]},[2,1]],"š":[{},[2,1]],"t":[{"e":[{"k":[{"s":[{},[0,0,0,0,0,4]]}]}],"g":[{"a":[{},[0,0,5]],"e":[{},[0,0,5]]},[0,4]],"v":[{"i":[{},[0,0,5]]},[0,4]]},[2,1]],"u":[{},[0,0,1]],"v":[{},[2,1]],"y":[{"q":[{"u":[{},[0,0,5]]}]}],"z":[{"i":[{},[0,0,4]]},[2,1]],"ž":[{},[2,1]]}],"o":[{"a":[{"s":[{},[0,4]]},[0,1]],"b":[{"g":[{"l":[{},[0,0,5]]}],"i":[{"d":[{"e":[{},[0,0,5]]}]}],"j":[{"o":[{},[0,0,5]]}],"l":[{"a":[{},[5]]}],"r":[{"o":[{},[5]]}],"z":[{},[0,4]]},[0,1]],"c":[{"k":[{"e":[{},[0,0,5]],"i":[{},[0,0,5]]}],"r":[{},[0,4]]},[0,1]],"č":[{},[0,1]],"d":[{"d":[{"v":[{},[0,0,5]]}],"n":[{"a":[{"l":[{},[0,0,5]]}]}],"r":[{"e":[{"p":[{},[0,6]]}]}],"z":[{"d":[{},[0,0,5]]}],"ž":[{},[0,2,1]]},[0,1]],"e":[{"l":[{"e":[{},[0,0,0,0,4]]}]},[0,1]],"f":[{},[0,1]],"g":[{"l":[{},[4]]},[0,1]],"h":[{},[0,1]],"i":[{"z":[{},[0,0,0,2]]},[0,1]],"j":[{},[0,1]],"k":[{"b":[{"a":[{},[0,0,5]],"e":[{},[0,0,5]]},[0,4]],"t":[{},[0,4]]},[0,1]],"l":[{"a":[{"v":[{"t":[{},[0,6,5]]}]}],"g":[{"č":[{"a":[{},[0,0,6]]}]}],"r":[{"e":[{},[0,0,5]]},[0,4]]},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"o":[{"d":[{"l":[{},[0,0,0,4]]}],"l":[{},[0,2]],"m":[{},[0,4]]},[0,1]],"p":[{"m":[{"e":[{},[0,0,5]]},[0,4]],"y":[{},[4]]},[0,1]],"r":[{"a":[{},[0,1]],"d":[{"e":[{"č":[{},[0,0,4]]}]}],"e":[{},[0,1]],"i":[{},[0,1]],"o":[{},[0,1]],"u":[{},[0,1]]}],"s":[{"e":[{"b":[{},[5]],"m":[{},[0,0,0,4,5]]}]},[0,1]],"š":[{},[0,1]],"t":[{},[0,1]],"u":[{"k":[{"i":[{},[0,0,5]],"u":[{},[0,0,5]]}]},[0,1]],"v":[{"s":[{"e":[{"m":[{},[0,0,5]]}]}],"š":[{"k":[{},[0,0,5]]}],"z":[{"a":[{},[0,5]],"d":[{},[0,0,3]]},[0,2,1]]},[0,1]],"y":[{},[0,1]],"z":[{"b":[{},[0,0,4]],"d":[{"j":[{},[0,0,0,5]]}],"g":[{},[0,0,4]],"l":[{"o":[{"ž":[{},[0,0,6]]},[0,0,5]]}],"n":[{"i":[{"c":[{},[0,0,5]],"š":[{},[0,0,5]]}]},[0,0,2]],"o":[{},[0,0,2]],"r":[{},[0,0,2]],"v":[{},[0,0,2]]},[0,1]],"ž":[{"m":[{"i":[{},[0,0,5]]}]},[0,1]]}],"p":[{"c":[{},[2,1]],"č":[{"k":[{"a":[{},[0,0,5]]}]},[2,3,2]],"e":[{"č":[{},[1]],"k":[{"t":[{},[0,0,4]]}],"t":[{"l":[{"e":[{},[0,0,4]]},[0,0,0,3]]}],"v":[{"s":[{},[0,0,4,5]],"t":[{},[0,0,0,5,4]]}]},[0,0,1]],"h":[{"s":[{"o":[{},[0,0,5]]},[4]]}],"i":[{"z":[{"o":[{},[0,0,5]]}]}],"k":[{},[2,1]],"l":[{"o":[{"z":[{},[4]]}]}],"o":[{"d":[{"f":[{"a":[{},[0,0,6]]}],"l":[{},[0,0,4,3]],"n":[{"a":[{},[0,0,4]]}],"o":[{"č":[{},[0,0,4,5]]}]}],"l":[{"o":[{"b":[{},[0,0,6]]}]}],"s":[{"t":[{"d":[{},[0,0,6]]}]}]},[0,0,1]],"r":[{"e":[{"z":[{},[0,0,0,0,4]]}]}],"s":[{},[2,1]],"š":[{},[2,1]],"t":[{},[2,1]],"z":[{"i":[{"g":[{".":[{},[0,0,6]]}]}]}]}],"q":[{"u":[{},[0,0,2]]}],"r":[{"a":[{"č":[{"u":[{},[3]]}],"e":[{},[2]],"j":[{"ž":[{"n":[{},[0,0,6]]}]}],"v":[{"z":[{"a":[{},[0,0,6]]},[0,0,0,5]]}],"z":[{"i":[{"d":[{},[0,0,4,5]]}],"l":[{},[3]],"o":[{"r":[{},[0,0,4,5]]}]}]}],"b":[{},[2,1]],"c":[{},[2,1]],"č":[{},[2,1]],"d":[{},[2,1]],"e":[{"a":[{"l":[{},[3]]}],"c":[{"h":[{"t":[{},[0,0,6]]}]}],"č":[{"v":[{},[0,0,5]]}],"d":[{"č":[{},[5]],"i":[{"g":[{},[0,0,6]]}],"n":[{"j":[{"u":[{},[0,0,6]]}]}]}],"i":[{"b":[{"a":[{},[0,0,6]]}]}],"j":[{"o":[{},[0,0,5]]}],"k":[{"m":[{},[0,0,5]]}],"s":[{"d":[{"a":[{},[0,0,6]]}]}],"v":[{"s":[{"k":[{},[0,0,0,6]]}]}],"z":[{"n":[{"a":[{"č":[{},[0,0,6]]}]}],"u":[{"s":[{},[0,0,6]]}],"v":[{"e":[{},[0,0,6]]}]}]},[0,0,1]],"f":[{},[0,1]],"g":[{},[2,1]],"h":[{},[2,1]],"i":[{"n":[{"o":[{},[0,0,5,4]]},[0,4]],"z":[{"g":[{},[0,0,0,4]],"l":[{},[0,0,0,4]],"n":[{},[0,0,0,4]]}]},[0,0,1]],"j":[{},[2,1]],"k":[{},[2,1]],"l":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"b":[{"i":[{"d":[{},[0,0,0,6]]}]}],"d":[{"i":[{},[3]]}],"z":[{"o":[{},[0,0,5]]}]},[0,0,1]],"p":[{},[2,1]],"r":[{},[0,1]],"s":[{},[2,1]],"š":[{},[2,1]],"t":[{"h":[{"a":[{},[0,0,5]]},[0,4]]},[2,1]],"u":[{"k":[{"l":[{},[0,0,5]]}]}],"v":[{"j":[{"o":[{},[0,0,5]]},[0,3,2]]},[2,1]],"y":[{"a":[{"n":[{},[0,0,5]]}]}],"z":[{"l":[{},[0,0,2]]},[2,1]],"ž":[{"d":[{"a":[{},[0,0,5]]}]},[0,1]]}],"s":[{"b":[{},[2,1]],"c":[{".":[{},[4]],"i":[{},[0,2]]},[1]],"e":[{"k":[{"s":[{"a":[{},[0,0,4,5]],"i":[{},[0,0,0,5]]}]}],"m":[{"a":[{},[0,0,5]]}],"v":[{"p":[{},[0,0,5]]}]}],"f":[{},[2,1]],"i":[{"d":[{},[0,4]],"g":[{"n":[{".":[{},[0,0,6]]}]}],"s":[{},[0,0,0,1]]},[0,0,1]],"j":[{},[2,1]],"k":[{".":[{},[2]],"n":[{},[0,2]],"r":[{"e":[{},[4]]}]}],"l":[{"a":[{"v":[{},[0,4]]}]}],"o":[{"n":[{"i":[{"č":[{},[0,0,0,0,0,4]]},[0,0,0,0,5]]},[0,4]]}],"p":[{"l":[{"o":[{"d":[{},[0,4]]}]}],"o":[{"d":[{"l":[{},[0,0,0,0,4]]}]}]},[1]],"s":[{},[2,1]],"t":[{".":[{},[2]],"e":[{"n":[{},[0,4]]},[3]],"f":[{},[4]],"i":[{"č":[{},[0,4]],"m":[{},[5]],"r":[{},[0,4]]}],"k":[{},[2]],"m":[{},[2]],"r":[{"a":[{".":[{},[0,4]]}]},[1]]}],"u":[{"b":[{"o":[{},[0,0,4]]}]},[0,0,1]],"v":[{"e":[{"t":[{},[0,0,0,5]]}]}]}],"š":[{"č":[{".":[{},[2]],"k":[{},[2]],"n":[{},[2]]},[0,2]],"e":[{"s":[{},[0,0,2]]}],"j":[{},[2,1]],".":[{},[8]]}],"t":[{"a":[{"w":[{"i":[{},[0,0,5]]}],"z":[{},[0,0,0,4]]}],"b":[{},[2,1]],"c":[{"h":[{"o":[{},[0,0,0,5]]}]},[2,1]],"d":[{},[2,1]],"e":[{"k":[{"s":[{"t":[{},[0,0,0,6]]}]}],"m":[{"a":[{},[5]]}],"x":[{"a":[{},[0,0,5]]}]}],"f":[{},[0,1]],"i":[{"n":[{"d":[{},[4]],"o":[{"s":[{},[4]]}],"p":[{},[4]],"s":[{"e":[{},[4]]}],"t":[{},[4,3]]}]}],"k":[{},[2,1]],"l":[{"e":[{"t":[{"n":[{"o":[{},[6]]}]}]}]}],"m":[{},[2,1]],"n":[{"a":[{"j":[{},[4]]}]}],"o":[{"v":[{"ž":[{".":[{},[0,0,6]]}]}]}],"r":[{"t":[{"u":[{"r":[{},[0,0,6]]},[0,0,0,5]]}]}],"s":[{},[2,1]],"t":[{},[2,1]],"u":[{},[0,0,1]],"z":[{".":[{},[4]]}]}],"u":[{"a":[{},[2,1]],"b":[{"j":[{},[0,0,4]],"p":[{"o":[{},[0,0,5]]},[0,4]]},[0,1]],"c":[{},[0,1]],"č":[{},[0,1]],"d":[{"m":[{"i":[{".":[{},[0,0,6]]}]}]},[0,1]],"e":[{},[0,1]],"f":[{},[0,1]],"g":[{},[0,1]],"h":[{},[0,1]],"i":[{},[0,1]],"j":[{},[0,1]],"k":[{"a":[{},[0,1]],"e":[{},[0,1]],"o":[{},[0,1]]}],"l":[{},[0,1]],"m":[{},[0,1]],"n":[{},[0,1]],"p":[{"č":[{"k":[{"a":[{},[0,0,6]]}]}]},[0,1]],"r":[{"a":[{},[0,1]],"e":[{},[0,1]],"g":[{},[4]],"i":[{},[0,1]]}],"s":[{"p":[{},[1]]},[0,1]],"š":[{"e":[{"s":[{},[0,0,0,3]]}]},[0,1]],"t":[{"h":[{"o":[{},[0,0,0,5]]},[0,4]]},[0,1]],"v":[{},[0,1]],"x":[{"e":[{"m":[{},[0,0,5]]}]}],"z":[{},[0,1]],"ž":[{},[0,1]]}],"v":[{"b":[{},[2,1]],"c":[{},[2,1]],"č":[{"a":[{},[0,1]],"e":[{"r":[{},[0,4]]},[0,1]],"i":[{},[0,1]]},[2]],"d":[{},[2,1]],"e":[{"č":[{"l":[{},[0,0,4]],"m":[{},[0,0,4]]}],"i":[{},[0,0,4]],"t":[{"i":[{"n":[{},[0,0,4]]}],"l":[{"e":[{"t":[{},[0,0,0,0,0,6]]}]}]}]}],"f":[{},[0,1]],"g":[{},[0,1]],"i":[{"d":[{"v":[{"a":[{},[0,0,0,6]]},[0,0,5]]}],"v":[{},[1]],"ž":[{"g":[{".":[{},[0,0,6]]}]}]}],"j":[{"o":[{},[4]]},[2,1]],"k":[{},[2,1]],"m":[{},[2,1]],"n":[{},[2,1]],"o":[{"r":[{"d":[{},[0,0,5]]}],"z":[{"l":[{"e":[{},[0,0,0,5]]}]}]}],"p":[{"a":[{},[3,2]],"i":[{"j":[{},[0,4]],"l":[{},[0,4]]}]},[2,1]],"s":[{"k":[{"n":[{},[0,5]]}]}],"š":[{"e":[{"k":[{},[0,5]]}],"k":[{},[4]]}],"t":[{"k":[{},[0,0,4]]},[2,1]],"z":[{"a":[{},[0,2]],"g":[{},[3,2]],"k":[{},[2,3]],"o":[{},[2]],"p":[{},[0,3]],"u":[{},[0,2]]},[0,0,2]]}],"w":[{"a":[{},[1]],"o":[{},[0,0,2]]}],"x":[{"f":[{},[0,1]]}],"y":[{"e":[{},[1]],"f":[{},[2,1]],"j":[{},[0,1]],"l":[{},[0,1]],"w":[{},[0,1]]}],"z":[{"a":[{"n":[{"e":[{".":[{},[0,6]]}]}],"u":[{"k":[{},[0,0,5]]}],"v":[{"p":[{},[0,0,3]]}],"z":[{"d":[{},[0,0,5]]},[0,0,1,2]]},[1,2]],"b":[{"i":[{"r":[{},[3]]}]},[2,1]],"c":[{},[0,1]],"č":[{},[2,1]],"d":[{"j":[{"u":[{},[0,0,5]]}],"v":[{},[0,3]]},[2,1,2]],"g":[{"n":[{"i":[{},[0,4]]}],"o":[{"t":[{},[0,5]]}]},[0,1]],"h":[{},[2,1]],"i":[{"g":[{},[0,1]],"s":[{},[2,1]],"š":[{"č":[{},[4,5]]}]},[1]],"j":[{},[2,1]],"k":[{"u":[{},[0,3]]},[2,1]],"l":[{"a":[{"s":[{},[0,5]]}],"i":[{"l":[{},[3]],"t":[{},[5]],"v":[{},[5]],"z":[{},[0,0,0,0,5]]},[0,1]],"j":[{},[1]],"o":[{"g":[{},[3]],"m":[{},[0,5]],"ž":[{},[3]]}],"u":[{},[0,1]]}],"m":[{},[2,1]],"n":[{},[1]],"o":[{"b":[{},[0,1]],"d":[{},[2,1]],"g":[{},[0,1]],"l":[{},[0,2]],"m":[{},[0,4]]},[1]],"p":[{},[2,1]],"r":[{"e":[{"d":[{"č":[{},[4]]}],"š":[{},[4]],"z":[{},[4]],"ž":[{},[4]]}],"i":[{},[4]],"u":[{},[4]]},[1,1]],"s":[{},[2,1]],"š":[{},[0,1]],"t":[{},[0,1]],"u":[{"j":[{},[0,4]],"p":[{},[2,1]],"z":[{},[2,1]]},[1]],"v":[{"e":[{"n":[{},[0,4]]}],"n":[{},[0,3]],"o":[{"j":[{},[3,4]],"k":[{},[0,4]]}]},[0,1,2]],"z":[{},[2,1,2]],"ž":[{},[0,1]]}],"ž":[{"b":[{},[2,1]],"c":[{},[2,1]],"č":[{},[2,1]],"j":[{},[2,1]],"k":[{},[2,1]],"m":[{"i":[{},[4]]}],".":[{},[8]]}]}';
  var hyphenation = [];

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
