"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "exporterRouter", {
    enumerable: true,
    get: function() {
        return exporterRouter;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _exporter = require("./exporter");
const _exportProgram = require("../programExporter/exportProgram");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const exporterRouter = _express.default.Router();
exporterRouter.get('/referenceData', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store, query } = req;
    const { includedDataTypes = {} } = query;
    for (const dataType of Object.values(includedDataTypes)){
        // When it is ReferenceData, check if user has permission to list ReferenceData
        if (_constants.REFERENCE_TYPE_VALUES.includes(dataType)) {
            req.checkPermission('list', 'ReferenceData');
            continue;
        }
        // Otherwise, if it is other types (eg: patient, lab_test_types,... ones that have their own models)
        // check the permission against the models
        const nonReferenceDataModelName = (0, _lodash.upperFirst)(dataType);
        req.checkPermission('list', nonReferenceDataModelName);
    }
    const filename = await (0, _exporter.exporter)(store, query.includedDataTypes);
    res.download(filename);
}));
exporterRouter.get('/program/:programId', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Program');
    const { store } = req;
    const { programId } = req.params;
    const filename = await (0, _exportProgram.exportProgram)(store, programId);
    res.download(filename);
}));

//# sourceMappingURL=exporterRouter.js.map