"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientExporter", {
    enumerable: true,
    get: function() {
        return PatientExporter;
    }
});
const _dateTime = require("@tamanu/shared/utils/dateTime");
const _DefaultDataExporter = require("./DefaultDataExporter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientExporter = class PatientExporter extends _DefaultDataExporter.DefaultDataExporter {
    constructor(...args){
        super(...args);
        _define_property(this, "customCellFormatter", {
            dateOfBirth: (value)=>{
                return (0, _dateTime.parseDate)(value);
            }
        });
    }
};

//# sourceMappingURL=PatientExporter.js.map