"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "UserExporter", {
    enumerable: true,
    get: function() {
        return UserExporter;
    }
});
const _DefaultDataExporter = require("./DefaultDataExporter");
let UserExporter = class UserExporter extends _DefaultDataExporter.DefaultDataExporter {
    async getData() {
        const users = await this.models.User.findAll({
            include: [
                {
                    model: this.models.Facility,
                    as: 'facilities',
                    attributes: [
                        'id'
                    ]
                }
            ]
        });
        return users.map(({ dataValues: { facilities, ...rest } })=>({
                ...rest,
                allowedFacilities: facilities.map(({ id })=>id).join(',')
            }));
    }
    getHeadersFromData(data) {
        return Object.keys(data[0]);
    }
};

//# sourceMappingURL=UserExporter.js.map