"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createModelExporter", {
    enumerable: true,
    get: function() {
        return createModelExporter;
    }
});
const _constants = require("@tamanu/constants");
const _AdministeredVaccineExporter = require("./AdministeredVaccineExporter");
const _DefaultDataExporter = require("./DefaultDataExporter");
const _PatientExporter = require("./PatientExporter");
const _LabTestPanelExporter = require("./LabTestPanelExporter");
const _PermissionExporter = require("./PermissionExporter");
const _PatientFieldDefinitionExporter = require("./PatientFieldDefinitionExporter");
const _ReferenceDataExporter = require("./ReferenceDataExporter");
const _TranslatedStringExporter = require("./TranslatedStringExporter");
const _UserExporter = require("./UserExporter");
const CustomExportersByDataType = {
    permission: _PermissionExporter.PermissionExporter,
    patient: _PatientExporter.PatientExporter,
    administeredVaccine: _AdministeredVaccineExporter.AdministeredVaccineExporter,
    labTestPanel: _LabTestPanelExporter.LabTestPanelExporter,
    patientFieldDefinition: _PatientFieldDefinitionExporter.PatientFieldDefinitionExporter,
    translatedString: _TranslatedStringExporter.TranslatedStringExporter,
    user: _UserExporter.UserExporter
};
const createModelExporter = (context, dataType)=>{
    const referenceDataTypes = [
        ..._constants.REFERENCE_TYPE_VALUES,
        'diagnosis'
    ];
    const CustomExporterClass = CustomExportersByDataType[dataType];
    if (CustomExporterClass) {
        return new CustomExporterClass(context, dataType);
    }
    if (referenceDataTypes.includes(dataType)) {
        return new _ReferenceDataExporter.ReferenceDataExporter(context, dataType);
    }
    return new _DefaultDataExporter.DefaultDataExporter(context, dataType);
};

//# sourceMappingURL=createModelExporter.js.map