"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "validateProgramDataElementRecords", {
    enumerable: true,
    get: function() {
        return validateProgramDataElementRecords;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _parseornull = require("@tamanu/shared/utils/parse-or-null");
const _numbers = require("../../utils/numbers");
const _stats = require("../stats");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const checkIfWithinGraphRange = (normalRange, graphRange)=>{
    if ((0, _numbers.isNumberOrFloat)(normalRange.min) && normalRange.min < graphRange.min) {
        return false;
    }
    if ((0, _numbers.isNumberOrFloat)(normalRange.max) && normalRange.max > graphRange.max) {
        return false;
    }
    return true;
};
const validateNormalRangeAsObject = (normalRange, graphRange)=>{
    if (!checkIfWithinGraphRange(normalRange, graphRange)) {
        throw new Error(`normalRange must be within graphRange, got normalRange: ${JSON.stringify(normalRange)}, graphRange: ${JSON.stringify(graphRange)}}`);
    }
    return true;
};
const validateNormalRangeAsArray = (normalRange, graphRange)=>{
    for (const normalRangeObject of normalRange){
        validateNormalRangeAsObject(normalRangeObject, graphRange);
    }
    return true;
};
const validateNormalRange = (normalRange, graphRange)=>{
    if (_yup.object().isType(normalRange)) {
        return validateNormalRangeAsObject(normalRange, graphRange);
    }
    if (_yup.array().isType(normalRange)) {
        return validateNormalRangeAsArray(normalRange, graphRange);
    }
    return false;
};
function validateVitalVisualisationConfig(visualisationConfigString, validationCriteriaString) {
    const visualisationConfig = (0, _parseornull.parseOrNull)(visualisationConfigString);
    const validationCriteria = (0, _parseornull.parseOrNull)(validationCriteriaString);
    if (visualisationConfig) {
        if (!validationCriteria) {
            throw new Error('validationCriteria must be specified if visualisationConfig is presented');
        }
        if (!validationCriteria.normalRange) {
            throw new Error('validationCriteria must have normalRange');
        }
        validateNormalRange(validationCriteria.normalRange, visualisationConfig.yAxis.graphRange);
    }
}
function validateProgramDataElementRecords(records, { context, sheetName, stats: previousStats = {} }) {
    if (!_config.default.validateQuestionConfigs.enabled) {
        return previousStats;
    }
    const { errors } = context;
    const stats = {
        ...previousStats
    };
    const programDataElementRecords = records.filter(({ model })=>model === 'ProgramDataElement');
    for (const programDataElementRecord of programDataElementRecords){
        const newErrors = [];
        const { values } = programDataElementRecord;
        const { visualisationConfig = '', code: dataElementCode } = values;
        const surveyScreenComponentRecord = records.find((r)=>r.values.dataElementId === values.id) || {};
        const { validationCriteria = '' } = surveyScreenComponentRecord.values;
        try {
            validateVitalVisualisationConfig(visualisationConfig, validationCriteria);
        } catch (e) {
            const error = new Error(`sheetName: ${sheetName}, code: '${dataElementCode}', ${e.message}`);
            newErrors.push(error);
        }
        if (newErrors.length > 0) {
            (0, _stats.updateStat)(stats, (0, _stats.statkey)('ProgramDataElement', sheetName), 'errored', newErrors.length);
            errors.push(...newErrors);
        }
    }
    return stats;
}

//# sourceMappingURL=vitalsValidation.js.map