"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    closeDatabase: function() {
        return closeDatabase;
    },
    initDatabase: function() {
        return initDatabase;
    },
    initReporting: function() {
        return initReporting;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _hooks = require("./hooks");
const _database = require("@tamanu/shared/services/database");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getOrCreateConnection = async ({ testMode, ...configOverrides }, key = 'main')=>{
    const store = await (0, _database.openDatabase)(key, {
        ..._config.default.db,
        ...configOverrides,
        testMode
    });
    // drop and recreate db
    if (testMode) {
        await store.sequelize.drop({
            cascade: true
        });
        await store.sequelize.migrate('up');
    }
    if (key === 'main') {
        await (0, _hooks.addHooks)(store);
    }
    return store;
};
async function initDatabase({ testMode = false, dbKey = 'main' }) {
    // connect to database
    return await getOrCreateConnection({
        testMode,
        saltRounds: _config.default.auth.saltRounds
    }, dbKey);
}
async function initReportStore(schemaName, credentials) {
    const { username, password, pool } = credentials;
    const overrides = {
        alwaysCreateConnection: false,
        migrateOnStartup: false,
        pool,
        username,
        password
    };
    if (!Object.values(_constants.REPORT_DB_SCHEMAS).includes(schemaName)) {
        _logging.log.warn(`Unknown reporting schema ${schemaName}, skipping...`);
        return null;
    }
    if (!username || !password) {
        _logging.log.warn(`No credentials provided for ${schemaName} reporting schema, skipping...`);
        return null;
    }
    return getOrCreateConnection(overrides, `reporting-${schemaName}`);
}
async function initReporting() {
    const { connections } = _config.default.db.reportSchemas;
    return Object.entries(connections).reduce(async (accPromise, [schemaName, { username, password }])=>{
        const instance = await initReportStore(schemaName, {
            username,
            password
        });
        if (!instance) return accPromise;
        return {
            ...await accPromise,
            [schemaName]: instance
        };
    }, Promise.resolve({}));
}
async function closeDatabase() {
    return (0, _database.closeAllDatabases)();
}

//# sourceMappingURL=index.js.map