"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "insertEncounter", {
    enumerable: true,
    get: function() {
        return insertEncounter;
    }
});
const _testhelpers = require("@tamanu/shared/test-helpers");
const _constants = require("@tamanu/constants");
const _chance = require("../chance");
const insertEncounter = async (store, setupData, patientId)=>{
    const { Encounter } = store.models;
    const [, department, location] = _chance.chance.pickone(setupData.facilitiesDepartmentsAndLocations);
    const encounter = await Encounter.create({
        ...(0, _testhelpers.fake)(Encounter),
        type: _constants.ENCOUNTER_TYPES.CLINIC,
        examinerId: _chance.chance.pickone(setupData.examiners).id,
        patientId,
        locationId: location.id,
        departmentId: department.id
    });
    return encounter;
};

//# sourceMappingURL=insertEncounter.js.map