"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "insertCovidTest", {
    enumerable: true,
    get: function() {
        return insertCovidTest;
    }
});
const _testhelpers = require("@tamanu/shared/test-helpers");
const _constants = require("@tamanu/constants");
const _chance = require("../../../chance");
const insertCovidTest = async ({ LabTest, LabRequest }, setupData, { encounterId })=>{
    const labRequest = await LabRequest.create({
        ...(0, _testhelpers.fake)(LabRequest),
        labTestCategoryId: _chance.chance.pickone(setupData.labTestCategories).id,
        status: _chance.chance.pickone(Object.values(_constants.LAB_REQUEST_STATUSES).filter((s)=>s !== _constants.LAB_REQUEST_STATUSES.DELETED)),
        encounterId
    });
    return LabTest.create({
        ...(0, _testhelpers.fake)(LabTest),
        labRequestId: labRequest.id,
        date: _chance.chance.date({
            year: _chance.chance.integer({
                min: 1970,
                max: 2021
            })
        }),
        status: _constants.LAB_TEST_STATUSES.RECEPTION_PENDING
    });
};

//# sourceMappingURL=insertCovidTest.js.map